---
name: taiyo-style-sales-letter
description: 太陽スタイル完全準拠のセールスレター作成。176パターン・80項目チェックリスト・taiyo-analyzer連携による品質保証付き。
version: "1.0.0"
author: TAISUN
category: marketing
tags: [sales-letter, copywriting, taiyo-style, high-conversion]
dependencies: [taiyo-analyzer]
---

# Taiyo Style Sales Letter Skill

## Overview

**日給5000万円**を生み出した太陽スタイルを完全適用したセールスレター作成スキル。
176パターンに基づく自動品質チェック、80項目チェックリスト、taiyo-analyzer連携により**Sランク品質**を保証。

## When to Use

```
「太陽スタイルでセールスレターを書いて」
「高成約率のセールスレターを作成して」
「taiyo-style-sales-letter を使って」
「/taiyo-style-sales-letter [商品名]」
```

## 作成フロー

```
┌─────────────────────────────────────────────────────────────┐
│            Taiyo Style Sales Letter Flow                     │
├─────────────────────────────────────────────────────────────┤
│                                                             │
│  1. ヒアリング (商品/ターゲット/価格)                        │
│       ↓                                                     │
│  2. 構造設計 (27ブロック + 感情曲線)                         │
│       ↓                                                     │
│  3. ドラフト作成 (太陽パターン適用)                          │
│       ↓                                                     │
│  4. taiyo-analyzer でスコアチェック                           │
│       ↓                                                     │
│  5. 80点未満 → 自動改善 → 再チェック                         │
│       ↓                                                     │
│  6. 80点以上 → 完成版出力                                    │
│                                                             │
└─────────────────────────────────────────────────────────────┘
```

## 27ブロック構造

### Part 1: オープニング (ブロック0-5)
| Block | Name | Purpose | 太陽 Pattern |
|-------|------|---------|--------------|
| 0 | プリヘッド | 注意喚起 | 恐怖トリガー + 緊急性 |
| 1 | ヘッドコピー | 最大インパクト | 数値系キラーワード + 断定形 |
| 2 | サブヘッド | 補足・具体化 | 希望トリガー |
| 3 | オープニングストーリー | どん底描写 | 感覚系 + 恐怖系 |
| 4 | 共感・問題提起 | 読者巻き込み | 疑問形 + 読者巻き込み型語尾 |
| 5 | 敵の特定 | 外部要因化 | 対比・二極化系 |

### Part 2: ボディ前半 (ブロック6-12)
| Block | Name | Purpose | 太陽 Pattern |
|-------|------|---------|--------------|
| 6 | 解決策の予感 | 希望の光 | 希望・快楽トリガー |
| 7 | 転機ストーリー | 出会いの瞬間 | ストーリー第2幕 |
| 8 | 発見・気づき | ブレイクスルー | 感嘆・強調型語尾 |
| 9 | 実践・試行錯誤 | リアリティ | 具体的数字 |
| 10 | 成功体験 | 証拠提示 | 社会的証明トリガー |
| 11 | メソッド紹介 | 独自性 | 権威・専門性トリガー |
| 12 | ベネフィット列挙 | 価値訴求 | 希望系キラーワード |

### Part 3: ボディ後半 (ブロック13-19)
| Block | Name | Purpose | 太陽 Pattern |
|-------|------|---------|--------------|
| 13 | 実績・証拠 | 信頼構築 | 数値系 + 社会的証明 |
| 14 | お客様の声 | 第三者証言 | 引用・証言型語尾 |
| 15 | Before/After | 変化の可視化 | 対比・二極化系 |
| 16 | 商品内容詳細 | 理解促進 | 説明形語尾 |
| 17 | 他との違い | 差別化 | 比較・対比型語尾 |
| 18 | 誰のためか | ターゲット明確化 | 読者巻き込み型 |
| 19 | 誰のためでないか | 除外条件 | 否定・警告型語尾 |

### Part 4: オファー (ブロック20-23)
| Block | Name | Purpose | 太陽 Pattern |
|-------|------|---------|--------------|
| 20 | 価格アンカリング | 価値認識 | 数値系 + 対比 |
| 21 | 実価格提示 | 衝撃価格 | 感嘆・強調型 |
| 22 | 特典紹介 | 価値積み上げ | 希望系 + 数値系 |
| 23 | 保証・リスクリバーサル | 安心感 | 実証済み系 |

### Part 5: クロージング (ブロック24-27)
| Block | Name | Purpose | 太陽 Pattern |
|-------|------|---------|--------------|
| 24 | 限定性・緊急性 | 行動促進 | 緊急性・希少性トリガー |
| 25 | 行動しない未来 | 損失回避 | 恐怖トリガー + 失う系 |
| 26 | CTA | 明確な行動指示 | 行動喚起型語尾 |
| 27 | 追伸 | 最終押し | 緊急性 + 恐怖 + 希望 |

## 太陽 スタイル必須要素

### 語尾バランス（黄金比率）
```
断定形: 55-60%
疑問形: 25-30%
説明形: 15-20%
```

### 文章リズム
```
短文 (1-15文字): 48%
中文 (16-30文字): 32%
長文 (31文字以上): 20%

平均文長: 21-24文字
1文1行率: 91%以上
空白行使用: 94%以上
```

### キラーワード配置
| セクション | 必須カテゴリ |
|-----------|-------------|
| ヘッドコピー | 数値系 + 希望系 |
| オープニング | 恐怖系 + 感覚系 |
| ボディ | 社会的証明 + 実証済み系 |
| オファー | 緊急性系 + 限定系 |
| クロージング | 失う系 + 今すぐ系 |

### 心理トリガー配置
```
恐怖→希望サイクル: 5回以上
感情振幅: 最大化
三層脳アプローチ: 必須
```

## 感情曲線設計

```
感情
  ^
100|              ★成功        ★CTA
   |             /  \         /
 50|         ___/    \____   /
   |        /              \_/
  0|-------/
   |      /
-100|★どん底
   +---------------------------------> ブロック
      0  5  10  15  20  25  27
```

## 品質保証プロセス

### Step 1: ドラフト作成
27ブロック構造に従い、各ブロックに適切な太陽パターンを適用

### Step 2: taiyo-analyzer チェック
```
taiyo_analyze(draft, {
  contentType: 'sales-letter',
  detailLevel: 'detailed',
  includeRewrite: true
})
```

### Step 3: スコア判定
| スコア | アクション |
|-------|----------|
| 90+ | そのまま完成 |
| 80-89 | 軽微な調整後完成 |
| 70-79 | 改善提案を適用して再チェック |
| 60-69 | 構造見直し + 再作成 |
| 60未満 | 根本的見直し |

### Step 4: 80項目チェックリスト確認
最終確認として80項目チェックリストを実行

## 出力フォーマット

### 完成版出力
```markdown
# [商品名] セールスレター

## メタ情報
- 作成日: YYYY-MM-DD
- 太陽スコア: XX/100 (Xランク)
- 文字数: X,XXX文字
- 推定読了時間: X分

---

[27ブロック構造のセールスレター本文]

---

## 品質レポート
### スコア内訳
| 項目 | スコア |
|-----|-------|
| 語尾パターン | XX/20 |
| キラーワード | XX/20 |
| 心理トリガー | XX/20 |
| 文章リズム | XX/15 |
| ストーリー構造 | XX/15 |
| 全体バランス | XX/10 |

### チェックリスト達成率
- オープニング: XX/15項目
- ボディ: XX/25項目
- オファー: XX/15項目
- クロージング: XX/15項目
- フォーマット: XX/10項目
```

## ヒアリング項目

### 必須情報
1. **商品名**:
2. **商品カテゴリ**: (講座/コンサル/ツール/物販)
3. **価格帯**: (〜10万/10-30万/30-100万/100万〜)
4. **ターゲット**: (年齢/性別/職業/悩み)
5. **主要ベネフィット**: (3つ)
6. **実績・証拠**: (数字で)
7. **競合との違い**:

### オプション情報
- 特典内容
- 保証内容
- 限定条件
- ストーリー素材

## 関連スキル

- `taiyo-analyzer` - スコアリング・改善提案
- `sales-letter` - 基本版セールスレター
- `taiyo-style` - 太陽スタイル適用
- `lp-analysis` - LP分析
- `copywriting-helper` - コピーライティング支援

## 使用例

### 基本使用
```
ユーザー: 太陽スタイルでセールスレターを書いて
→ ヒアリング開始 → 27ブロック作成 → スコアチェック → 完成版出力
```

### 特定ブロックのみ
```
ユーザー: ヘッドコピーだけ太陽スタイルで書いて
→ ブロック0-2を集中作成 → 部分スコアチェック
```

### 改善依頼
```
ユーザー: このセールスレターを太陽スタイルに改善して
→ 現状分析 → 改善点特定 → リライト → スコア比較
```
