---
name: taiyo-style-step-mail
description: 太陽スタイル完全準拠のステップメール作成。6つの教育要素×心理トリガー×感情ジェットコースターで開封率・成約率を最大化。
version: "1.0.0"
author: TAISUN
category: marketing
tags: [step-mail, email-marketing, taiyo-style, automation]
dependencies: [taiyo-analyzer]
---

# Taiyo Style Step Mail Skill

## Overview

**日給5000万円**を生み出した太陽スタイルをステップメールに完全適用。
6つの教育要素に心理トリガーと感情ジェットコースターを組み合わせ、開封率・クリック率・成約率を最大化。

## When to Use

```
「太陽スタイルでステップメールを作って」
「高成約率のメールシーケンスを作成」
「/taiyo-style-step-mail」
「7日間のステップメールを作って」
```

## ステップメール設計フレームワーク

### 全体構造（推奨7-14通）

```
┌─────────────────────────────────────────────────────────────┐
│           Taiyo Style Step Mail Structure                    │
├─────────────────────────────────────────────────────────────┤
│                                                             │
│  Day 0: ウェルカム＋衝撃の約束                               │
│       ↓                                                     │
│  Day 1-2: 問題認識の深化（恐怖トリガー）                     │
│       ↓                                                     │
│  Day 3-4: 解決策の予感（希望トリガー）                       │
│       ↓                                                     │
│  Day 5-6: 信用構築（社会的証明）                             │
│       ↓                                                     │
│  Day 7: セールス開始（緊急性トリガー）                       │
│       ↓                                                     │
│  Day 8-10: 追撃セールス（希少性＋損失回避）                  │
│                                                             │
└─────────────────────────────────────────────────────────────┘
```

### 6つの教育要素 × 太陽パターン

| 教育要素 | 目的 | 配置日 | 太陽パターン |
|---------|------|-------|-------------|
| **目的** | 理想未来を描く | Day 0, 3 | 希望・快楽トリガー + 感覚系キラーワード |
| **問題** | 現状の危機認識 | Day 1-2 | 損失回避トリガー + 恐怖系キラーワード |
| **手段** | 解決策の提示 | Day 3-4 | 権威トリガー + 実証済み系 |
| **投資** | 価値の認識 | Day 5 | 対比系 + 数値系キラーワード |
| **信用** | 信頼の確立 | Day 4-6 | 社会的証明 + 引用・証言型語尾 |
| **行動** | 具体的行動促進 | Day 7-10 | 緊急性・希少性 + 行動喚起型語尾 |

## 各通のテンプレート構造

### Day 0: ウェルカムメール

**目的**: 期待感MAX + 次回予告で開封習慣化

**構成**:
```
┌─────────────────────────────────────────┐
│  件名: [衝撃的な数字] + [約束]           │
├─────────────────────────────────────────┤
│  1. 感謝 + 自己紹介（2-3行）             │
│  2. 衝撃の約束（具体的数字付き）         │
│  3. なぜあなたに送るのか                 │
│  4. この先何が届くか予告                 │
│  5. 明日の予告（超具体的）               │
│  6. 追伸（緊急性の種まき）               │
└─────────────────────────────────────────┘
```

**太陽パターン**:
- 件名: 数値系キラーワード必須
- 本文: 希望トリガー → 明日の恐怖トリガー予告
- 語尾: 断定形60% + 疑問形30%

### Day 1: 問題認識①（恐怖の始まり）

**目的**: 読者の「痛み」を明確化

**構成**:
```
┌─────────────────────────────────────────┐
│  件名: [読者の悩み] + [疑問形]           │
├─────────────────────────────────────────┤
│  1. 共感から始める                       │
│  2. 「実は私も...」ストーリー            │
│  3. 問題を放置した未来（恐怖描写）       │
│  4. でも大丈夫、という希望の光           │
│  5. 明日の予告                           │
│  6. 追伸（問いかけ）                     │
└─────────────────────────────────────────┘
```

**太陽パターン**:
- 恐怖→希望サイクル: 2回
- キラーワード: 恐怖系 + 共感系
- 語尾: 読者巻き込み型30%

### Day 2: 問題認識②（恐怖の深化）

**目的**: 痛みを極限まで描写

**構成**:
```
┌─────────────────────────────────────────┐
│  件名: [衝撃的事実] or [警告]            │
├─────────────────────────────────────────┤
│  1. 昨日の復習（1行）                    │
│  2. さらに深い問題提起                   │
│  3. 「このままだと...」最悪シナリオ      │
│  4. 社会的証明（同じ悩みの人数）         │
│  5. 転機の予告                           │
│  6. 追伸（明日への期待感）               │
└─────────────────────────────────────────┘
```

**太陽パターン**:
- 感情曲線: 最低点まで落とす
- キラーワード: 損失系 + 時間損失系
- 心理トリガー: 損失回避を徹底

### Day 3: 解決策の予感

**目的**: 希望の光を見せる

**構成**:
```
┌─────────────────────────────────────────┐
│  件名: [転機] + [希望のキーワード]       │
├─────────────────────────────────────────┤
│  1. 昨日の恐怖を軽く触れる               │
│  2. 転機ストーリー（自分の体験）         │
│  3. 発見の瞬間                           │
│  4. 解決策の概要（詳細は後日）           │
│  5. ビフォーアフターの暗示               │
│  6. 追伸（具体的成果の予告）             │
└─────────────────────────────────────────┘
```

**太陽パターン**:
- 感情曲線: 急上昇
- キラーワード: 希望系 + 逆転系
- 語尾: 感嘆・強調型増加

### Day 4: 信用構築①（証拠提示）

**目的**: 実績で信頼を獲得

**構成**:
```
┌─────────────────────────────────────────┐
│  件名: [具体的成果数字]                  │
├─────────────────────────────────────────┤
│  1. 解決策の具体的成果                   │
│  2. 実績者の声（3名分）                  │
│  3. なぜこの方法が効くのか               │
│  4. 誰でもできる理由                     │
│  5. 次回予告（さらなる証拠）             │
│  6. 追伸（期間限定の予告）               │
└─────────────────────────────────────────┘
```

**太陽パターン**:
- 社会的証明: 3重構造
- キラーワード: 数値系（端数含む）
- 語尾: 引用・証言型

### Day 5: 信用構築②（価値認識）

**目的**: 投資価値を理解させる

**構成**:
```
┌─────────────────────────────────────────┐
│  件名: [投資vs損失] の対比               │
├─────────────────────────────────────────┤
│  1. 追加の成功事例                       │
│  2. 投資しないリスク（機会損失）         │
│  3. 投資した場合のリターン               │
│  4. 価格アンカリングの伏線               │
│  5. 明後日からの特別案内予告             │
│  6. 追伸（限定性の予告）                 │
└─────────────────────────────────────────┘
```

**太陽パターン**:
- 対比構造: 投資するvs.しない
- キラーワード: 対比系 + 損失系
- 心理トリガー: 損失回避 + 希望

### Day 6: セールス前夜

**目的**: 期待感を最高潮に

**構成**:
```
┌─────────────────────────────────────────┐
│  件名: [明日◯時] 重大発表               │
├─────────────────────────────────────────┤
│  1. これまでの振り返り                   │
│  2. 明日の案内を予告                     │
│  3. 先行者の声（すでに成功した人）       │
│  4. なぜ今なのか（理由）                 │
│  5. 準備しておくこと                     │
│  6. 追伸（見逃し厳禁の警告）             │
└─────────────────────────────────────────┘
```

**太陽パターン**:
- 緊急性: 具体的日時
- キラーワード: 今すぐ系 + 限定系
- 感情: 期待と不安の両方

### Day 7: セールス開始

**目的**: 成約を獲得

**構成**:
```
┌─────────────────────────────────────────┐
│  件名: [公開開始] + [限定条件]           │
├─────────────────────────────────────────┤
│  1. 待望の案内開始                       │
│  2. オファー内容（価値→価格）            │
│  3. 特典一覧                             │
│  4. 限定条件（人数/期間）                │
│  5. 申込方法                             │
│  6. 追伸（締切警告）                     │
└─────────────────────────────────────────┘
```

**太陽パターン**:
- 緊急性・希少性: 全開
- キラーワード: 全カテゴリ投入
- 語尾: 行動喚起型30%

### Day 8-10: 追撃セールス

**テーマ別**:
- Day 8: よくある質問への回答
- Day 9: 決断できない人へ（最後の一押し）
- Day 10: 最終警告（締切当日）

## 件名の黄金法則

### 開封率を最大化する件名パターン

| パターン | 例 | 効果 |
|---------|---|-----|
| 数字+疑問 | 「なぜ97.3%の人が失敗するのか？」 | 好奇心 |
| 警告型 | 「【警告】これを知らないと...」 | 恐怖 |
| 秘密暴露 | 「誰も教えてくれなかった真実」 | 独占欲 |
| 期間限定 | 「【本日23:59まで】」 | 緊急性 |
| 質問形 | 「◯◯で悩んでいませんか？」 | 共感 |
| Before/After | 「借金300万→月収100万になった方法」 | 変化 |
| 反常識 | 「努力するな、という話」 | 意外性 |

### 件名の文字数
- 推奨: 20-30文字
- 最大: 40文字
- スマホ表示: 25文字以内推奨

## 本文の黄金法則

### 文章リズム（メール版）
```
短文: 55%（通常より多め）
中文: 30%
長文: 15%

平均文長: 18-20文字
1文1行率: 98%以上
空白行使用: 100%（段落間必須）
```

### 1通あたりの構成
- 文字数: 800-1500文字（長すぎない）
- 段落数: 8-12段落
- 追伸: 必須（重要情報を再掲）

### 感情ジェットコースター（1通内）
```
感情
  ^
 50|    ＿＿     ＿＿
   |   /  \   /  \
  0|--/    \_/    \--
   |
-50|
   +-----------------> 本文進行
```
- 1通につき2-3回の感情変化
- 最後は必ず上向きで終わる

## 品質チェック

### 各通のtaiyo-analyzerスコア目標
| 項目 | 目標スコア |
|-----|----------|
| 語尾パターン | 16/20以上 |
| キラーワード | 14/20以上 |
| 心理トリガー | 16/20以上 |
| 文章リズム | 13/15以上 |
| 全体 | 70/100以上 |

### シーケンス全体チェック
- [ ] 6つの教育要素すべて網羅
- [ ] 恐怖→希望サイクル5回以上（全体で）
- [ ] 各通に次回予告あり
- [ ] 緊急性が段階的に上昇
- [ ] 追伸が全通にある

## 出力フォーマット

```markdown
# [商品名] ステップメール（全◯通）

## シーケンス概要
- 期間: ◯日間
- 通数: ◯通
- 目的: [セールス/教育/ナーチャリング]

---

## Day 0: [件名]

### メタ情報
- 目的: ウェルカム + 期待感醸成
- 教育要素: 目的
- 太陽スコア: XX/100

### 本文

[本文内容]

---

## Day 1: [件名]
...
```

## 関連スキル

- `taiyo-analyzer` - スコアリング
- `step-mail` - 基本版ステップメール
- `taiyo-style` - 太陽スタイル適用
- `copywriting-helper` - コピーライティング支援
