---
name: taiyo-style-vsl
description: 太陽スタイル完全準拠のVSL（ビデオセールスレター）台本作成。15章構造×心理トリガー×感情曲線で視聴完了率・成約率を最大化。
version: "1.0.0"
author: TAISUN
category: marketing
tags: [vsl, video-sales-letter, taiyo-style, script]
dependencies: [taiyo-analyzer]
---

# Taiyo Style VSL Skill

## Overview

**日給5000万円**を生み出した太陽スタイルをVSL（ビデオセールスレター）に完全適用。
15章構造に心理トリガーと感情ジェットコースターを組み合わせ、視聴完了率・成約率を最大化。

## When to Use

```
「太陽スタイルでVSLを作って」
「ビデオセールスレターの台本を作成」
「/taiyo-style-vsl」
「セールス動画のスクリプトを書いて」
```

## VSL設計フレームワーク

### 15章構造 × 太陽パターン

```
┌─────────────────────────────────────────────────────────────┐
│              Taiyo Style VSL 15章構造                        │
├─────────────────────────────────────────────────────────────┤
│                                                             │
│  【序章】注意獲得（0-3分）                                   │
│  ├── 第1章: 冒頭の大フック＆警告                            │
│  └── 第2章: 超リアルBeforeストーリー                        │
│                                                             │
│  【起】問題提起（3-10分）                                    │
│  ├── 第3章: 最初の証拠提示                                  │
│  ├── 第4章: ネガティブ訴求・第一波                          │
│  └── 第5章: 顧客事例A・B・C                                 │
│                                                             │
│  【承】希望と深化（10-20分）                                 │
│  ├── 第6章: ポジティブ訴求・第一波                          │
│  ├── 第7章: ネガティブ訴求・第二波                          │
│  ├── 第8章: 大量の反論つぶし                                │
│  └── 第9章: 追加顧客事例D・E・F                             │
│                                                             │
│  【転】価値教育（20-35分）                                   │
│  ├── 第10章: 価値観教育＆ノウハウ一部公開                   │
│  ├── 第11章: 中盤証拠提示                                   │
│  └── 第12章: 最終証拠（インタビュー）                       │
│                                                             │
│  【結】クロージング（35-45分）                               │
│  ├── 第13章: オファー提示                                   │
│  ├── 第14章: 保証・限定・最終反論                           │
│  └── 第15章: クロージング総仕上げ                           │
│                                                             │
└─────────────────────────────────────────────────────────────┘
```

## 各章の詳細設計

### 第1章: 冒頭の大フック＆警告（0-1分）

**目的**: 3秒で視聴者の心を掴む

**構成**:
```
[0:00-0:03] 衝撃の一言（数字 or 警告）
[0:03-0:15] 約束（この動画で得られるもの）
[0:15-0:30] 対象者の明確化
[0:30-1:00] 見続けるべき理由
```

**太陽パターン**:
- キラーワード: 数値系（「日給5万円」等）+ 緊急性系
- 語尾: 断定形70%
- 心理トリガー: 希望 + 恐怖（見ないと損）

**例文**:
```
「たった3日で月収100万円を超えた方法があります。

この動画を最後まで見れば、
あなたも同じ結果を手に入れる
具体的な方法がわかります。

ただし、ある条件があります。

この方法は誰にでも効くわけではありません。
対象外の人が見ても時間の無駄です。

あなたが対象者かどうか、
今から30秒で判断できます。」
```

### 第2章: 超リアルBeforeストーリー（1-3分）

**目的**: 共感と感情移入を生む

**構成**:
```
[1:00-1:30] どん底の状況描写
[1:30-2:00] 具体的な苦しみ（五感で描写）
[2:00-2:30] 何度も失敗した経験
[2:30-3:00] 諦めかけた瞬間
```

**太陽パターン**:
- キラーワード: 恐怖系 + 感覚系
- 語尾: 省略・余韻型20%
- 心理トリガー: 損失回避（過去形）

**感情曲線**:
```
開始 → -80（どん底）
```

### 第3章: 最初の証拠提示（3-5分）

**目的**: 信頼性の構築開始

**構成**:
```
[3:00-3:30] 転機の予感
[3:30-4:00] 具体的な成果（数字）
[4:00-4:30] 証拠画像/動画の言及
[4:30-5:00] 「どうやって？」という疑問提起
```

**太陽パターン**:
- キラーワード: 数値系（端数含む）
- 心理トリガー: 社会的証明
- 語尾: 引用・証言型

### 第4章: ネガティブ訴求・第一波（5-8分）

**目的**: 社会情勢・将来不安を描く

**構成**:
```
[5:00-6:00] 社会の変化（データ引用）
[6:00-7:00] このままだと起こること
[7:00-8:00] 多くの人が陥る罠
```

**太陽パターン**:
- キラーワード: 損失系 + 時間損失系
- 心理トリガー: 損失回避を徹底
- 語尾: 否定・警告型増加

**感情曲線**:
```
-30 → -70（再び下降）
```

### 第5章: 顧客事例A・B・C（8-12分）

**目的**: Before/Afterで可能性を示す

**構成**:
```
各事例2分 × 3名 = 6分
- Before: 過去の状況
- 転機: 出会い/決断
- After: 現在の成果
- メッセージ: 視聴者へ一言
```

**太陽パターン**:
- キラーワード: 対比系 + 数値系
- 心理トリガー: 社会的証明3重
- 語尾: 引用・証言型40%

### 第6章: ポジティブ訴求・第一波（12-14分）

**目的**: 希望の未来を描く

**構成**:
```
[12:00-12:30] 成功後の生活描写
[12:30-13:00] 具体的なシーン（五感）
[13:00-13:30] 家族・周囲の変化
[13:30-14:00] 「あなたも...」への橋渡し
```

**太陽パターン**:
- キラーワード: 希望系 + 感覚系
- 心理トリガー: 希望・快楽トリガー
- 語尾: 仮定・条件型20%

**感情曲線**:
```
-70 → +50（急上昇）
```

### 第7章: ネガティブ訴求・第二波（14-17分）

**目的**: 騙され経験・リスクを描く

**構成**:
```
[14:00-15:00] よくある失敗パターン
[15:00-16:00] 詐欺・騙された経験
[16:00-17:00] 時間とお金を失う恐怖
```

**太陽パターン**:
- キラーワード: 恐怖系を強化
- 心理トリガー: 損失回避（最高潮）
- 語尾: 否定・警告型

**感情曲線**:
```
+50 → -90（最低点）
```

### 第8章: 大量の反論つぶし（17-22分）

**目的**: Q&A先出し×10で不安解消

**構成**:
```
10個の反論に対して各30秒
- 「でも◯◯では？」
- 「それは△△だからです」
- 「だから安心してください」
```

**よくある反論例**:
1. 「自分にもできるか不安」
2. 「時間がない」
3. 「お金がない」
4. 「パソコンが苦手」
5. 「過去に失敗した」
6. 「怪しくないか」
7. 「再現性はあるか」
8. 「サポートはあるか」
9. 「返金はできるか」
10. 「本当に結果が出るか」

**太陽パターン**:
- 語尾: 断定形60% + 疑問形30%
- キラーワード: 安心系 + 実証済み系

### 第9章: 追加顧客事例D・E・F（22-26分）

**目的**: 多様な背景の成功者を紹介

**ポイント**:
- 年齢層を分散（20代/40代/60代）
- 職業を分散（会社員/主婦/経営者）
- 成果レベルを分散（初成果/月収50万/月収300万）

**太陽パターン**:
- 社会的証明を積み重ね
- 「自分にもできそう」を最大化

### 第10章: 価値観教育（26-30分）

**目的**: 常識破壊→新フレーム＆ノウハウ一部公開

**構成**:
```
[26:00-27:00] 常識の否定
[27:00-28:00] 新しいフレームワーク提示
[28:00-29:00] ノウハウの一部公開
[29:00-30:00] 「これだけでも価値がある」
```

**太陽パターン**:
- キラーワード: 独自造語系
- 心理トリガー: 権威・専門性
- 語尾: 断定形70%

### 第11章: 中盤証拠提示（30-33分）

**目的**: 感情を揺さぶる証拠

**構成**:
- 銀行口座のスクリーンショット
- 売上管理画面
- お客様からのメッセージ
- メディア掲載実績

**太陽パターン**:
- キラーワード: 数値系（端数必須）
- 心理トリガー: 社会的証明の決定打

### 第12章: 最終証拠・インタビュー形式（33-37分）

**目的**: 最も説得力のある証拠

**構成**:
```
2-3名のインタビュー形式
- 「どんな状況でしたか？」
- 「何が変わりましたか？」
- 「今の生活は？」
- 「これから始める人へ」
```

**感情曲線**:
```
-90 → +80（回復＆上昇）
```

### 第13章: オファー提示（37-40分）

**目的**: 商品内容・価格・特典を提示

**構成**:
```
[37:00-38:00] 商品名＆コンセプト
[38:00-39:00] 内容詳細（価値強調）
[39:00-39:30] 価格アンカリング
[39:30-40:00] 実価格＆特典紹介
```

**太陽パターン**:
- キラーワード: 数値系 + 限定系
- 心理トリガー: 希少性の開始
- 価格提示: 「◯◯万円の価値が、今だけ△△円」

### 第14章: 保証・限定・最終反論（40-43分）

**目的**: 最後の不安を解消

**構成**:
```
[40:00-41:00] 返金保証の説明
[41:00-42:00] 先着枠・限定性
[42:00-43:00] 最終Q&A（5問）
```

**太陽パターン**:
- キラーワード: 緊急性系全開
- 心理トリガー: 希少性・緊急性
- 語尾: 行動喚起型増加

### 第15章: クロージング総仕上げ（43-45分）

**目的**: 行動を促す最終押し

**構成**:
```
[43:00-43:30] 今動かないリスク
[43:30-44:00] 動いた場合の未来
[44:00-44:30] 最後のメッセージ
[44:30-45:00] CTA（具体的な申込方法）
```

**太陽パターン**:
- 恐怖→希望の最終サイクル
- キラーワード: 今すぐ系 + 失う系
- 語尾: 行動喚起型40%

**感情曲線**:
```
+80 → +100（最高潮でCTA）
```

## 感情曲線の全体設計

```
感情
   ^
+100|                              ★CTA
    |                           __/
 +50|          __     ___    __/
    |         /  \___/   \__/
   0|--\     /
    |   \   /
 -50|    \_/
    |
 -90|    ★最低点
    +---------------------------------> 時間
       5   10   15   20   25   30   35   40   45分

    第1-2章  第4-7章    第10-12章   第13-15章
```

## 台本の文字量目安

| 章 | 時間 | 文字数 | 備考 |
|---|-----|-------|-----|
| 1-2章 | 3分 | 900字 | 掴み重視 |
| 3-5章 | 7分 | 2,100字 | 証拠＆事例 |
| 6-9章 | 10分 | 3,000字 | 感情変化重視 |
| 10-12章 | 7分 | 2,100字 | 教育＆証拠 |
| 13-15章 | 8分 | 2,400字 | セールス |
| **合計** | **35-45分** | **10,500字** | |

## 品質チェック

### taiyo-analyzerスコア目標
| 章 | 目標スコア |
|---|----------|
| 第1-2章（掴み） | 85/100以上 |
| 第4-7章（感情） | 80/100以上 |
| 第13-15章（CTA） | 90/100以上 |
| 全体平均 | 80/100以上 |

### 必須チェック項目
- [ ] 冒頭3秒で興味を引く
- [ ] 感情曲線が設計通り
- [ ] 証拠が3段階で提示
- [ ] 顧客事例が6名以上
- [ ] 反論が10個以上つぶされている
- [ ] 限定性・緊急性が明確
- [ ] CTAが具体的

## 出力フォーマット

```markdown
# [商品名] VSL台本

## 基本情報
- 想定尺: ◯分
- 総文字数: ◯◯,◯◯◯字
- 太陽スコア: XX/100

---

## 第1章: 冒頭の大フック＆警告
**時間**: 0:00-1:00
**目的**: 視聴者の注意を掴む

[台本テキスト]

---

## 第2章: 超リアルBeforeストーリー
...
```

## 関連スキル

- `taiyo-analyzer` - スコアリング
- `vsl` - 基本版VSL
- `taiyo-style` - 太陽スタイル適用
- `launch-video` - ローンチ動画
