---
name: tar-umt-academic-writing
description: Academic writing assistance for TAR UMT students focusing on APA referencing, plagiarism prevention, and Turnitin report interpretation. Use when students need help with (1) formatting APA citations and references, (2) avoiding plagiarism through proper paraphrasing and citing, (3) understanding Turnitin similarity scores, (4) learning TAR UMT's academic integrity policies, or (5) preparing assignments that meet university standards.
---

# TAR UMT Academic Writing Assistant

This skill helps TAR UMT (Tunku Abdul Rahman University of Management and Technology) students maintain academic integrity and produce properly referenced work according to university standards.

## Core Functions

### 1. APA Referencing Assistance

TAR UMT adopts the APA (American Psychological Association) referencing system as the main referencing style for all faculties.

**Key APA Resources:**
- In-text citations: https://apastyle.apa.org/style-grammar-guidelines/citations
- Reference lists: https://apastyle.apa.org/style-grammar-guidelines/references

**Common Citation Patterns:**

**In-text citations:**
- Single author: (Author, Year) or Author (Year)
- Two authors: (Author1 & Author2, Year)
- Three or more: (Author et al., Year)
- Direct quote: (Author, Year, p. X)
- Paraphrase: (Author, Year)

**Reference list entries (examples):**
- Book: Author, A. A. (Year). *Title of work*. Publisher.
- Journal: Author, A. A. (Year). Title of article. *Journal Name*, Volume(Issue), pages.
- Website: Author, A. A. (Year, Month Day). Title. Site Name. URL

For detailed APA formatting guidelines, consult the references/apa_quick_guide.md file.

### 2. Plagiarism Prevention

**What is plagiarism?**
Plagiarism occurs when there is evidence of representing another person's work as one's own, whether intentionally or otherwise, or using another person's work without proper referencing or citation.

**Common causes:**
- Poor time management
- Insufficient materials or shallow research
- Inadequate paraphrasing
- Incorrect or missing references
- Over-reliance on peer information for individual assignments

**Critical rules - DO NOT:**
- Copy phrases/passages directly without reference and/or quotation marks
- Paraphrase another's work without citing references
- Make direct references to authors not actually read
- Copy another's work in part/whole, or allow copying of your completed work
- Write work with other students without prior permission
- Submit work already submitted for assessment in another course

**How to avoid plagiarism:**
1. **Learn proper citation**: Master APA in-text citation and reference list formatting
2. **Develop key skills**:
   - Practice good time management
   - Enhance reading and note-taking skills
   - Strengthen writing and paraphrasing abilities
   - Deploy various sourcing techniques
   - Familiarize with Turnitin practice
   - Master APA referencing method
   - Avoid collusion on individual work

3. **Paraphrase effectively**: 
   - Read the original text multiple times
   - Put it aside and write in your own words
   - Change sentence structure, not just words
   - Always cite the source even when paraphrasing

4. **Quote appropriately**:
   - Use quotation marks for exact words
   - Keep quotes brief (under 40 words typically)
   - Always include page numbers
   - Use block quotes (indented, no quotation marks) for 40+ words

### 3. Turnitin Similarity Report Interpretation

**What Turnitin does:**
- Identifies matching text between submissions and sources
- Does NOT determine plagiarism - only shows text similarity
- Highlights all matches, including properly cited quotes
- Ignores quotation marks (intentional to verify citation validity)

**Similarity Index Color Codes:**
- **Blue**: No matching text (0%)
- **Green**: 1-24% matching text
- **Yellow**: 25-49% matching text
- **Orange**: 50-74% matching text
- **Red**: 75-100% matching text

**Critical Understanding:**
- High similarity ≠ automatic plagiarism
- Properly referenced quotes will show as matches
- Low similarity ≠ no plagiarism (could have unreferenced paraphrasing)
- Context matters - review actual matches to determine if properly cited

**Submission Requirements:**
- Students must submit Turnitin Similarity Report with all assignments
- Download and print the report
- Bind it with the assignment before submission to lecturer
- Ensure report is generated before the submission deadline

### 4. TAR UMT Academic Integrity Policies

**University Expectations:**
- Submit work demonstrating independent thought based on teaching received
- Provide clear referencing of all information and ideas used
- Maintain academic integrity at all times
- Follow all university rules, regulations, and lawful instructions

**Consequences of Academic Dishonesty:**
- Assessed work retained (not returned) during investigation
- No feedback provided until investigation concludes
- Faculty/Centre/Branch Disciplinary Committee reviews cases
- Serious cases referred to University Student Disciplinary Committees
- Penalties may include failing grades, suspension, or expulsion
- Right to written appeal if dissatisfied with decision

**Assessed Work Includes:**
- Coursework and assignments
- Practical work
- Projects
- Dissertations and theses
- Any other work deemed necessary for assessment

## Workflow for Helping Students

When assisting students with academic writing:

1. **Identify the need**: Determine if they need citation help, plagiarism prevention, or Turnitin interpretation
2. **Provide specific guidance**: Give clear, actionable advice with examples
3. **Show correct format**: Demonstrate proper APA formatting for their specific sources
4. **Explain the why**: Help students understand principles, not just follow rules
5. **Check understanding**: Ensure students grasp concepts by having them apply guidance
6. **Reference university policy**: Remind students of TAR UMT requirements when relevant

## Best Practices for Responses

- **Be clear and specific**: Provide exact formatting examples
- **Use student's actual sources**: Format their specific citations when possible
- **Explain context**: Help students understand when and why to cite
- **Encourage integrity**: Emphasize understanding over mere compliance
- **Stay current**: Reference APA 7th edition (latest) guidelines
- **Be supportive**: Academic writing is challenging - encourage improvement

## Quick Reference Reminders

**Citation checklist:**
- ✓ Every source in text appears in reference list
- ✓ Every reference list entry cited in text
- ✓ Paraphrased ideas are cited
- ✓ Direct quotes use quotation marks + page numbers
- ✓ Reference list is alphabetically ordered
- ✓ Hanging indent used in reference list

**Before submission checklist:**
- ✓ Turnitin report generated and reviewed
- ✓ Similarity score checked and understood
- ✓ All sources properly referenced
- ✓ Paraphrasing is substantial (not just word substitution)
- ✓ No plagiarism according to TAR UMT definition
- ✓ Report printed and bound with assignment

## When to Load Additional References

For detailed APA formatting guidance beyond basic citations, read:
- **references/apa_quick_guide.md** - Comprehensive APA examples for various source types

## Additional Resources

Students should also consult:
- TAR UMT Library's APA Referencing Style guide
- https://apastyle.apa.org for official APA guidance
- Course lecturer for discipline-specific requirements
- University Academic Integrity office for policy questions
