# APA Referencing Quick Guide (7th Edition)

This guide provides detailed examples for formatting common sources in APA style, following the American Psychological Association 7th edition guidelines.

## General Principles

### In-Text Citations

**Basic format:**
- Parenthetical: (Author, Year)
- Narrative: Author (Year)

**With page numbers (for quotes):**
- Parenthetical: (Author, Year, p. X)
- Narrative: Author (Year, p. X)

**Multiple authors:**
- 1 author: (Smith, 2020)
- 2 authors: (Smith & Jones, 2020)
- 3+ authors: (Smith et al., 2020)

### Reference List

**General format:**
- Alphabetically ordered by author surname
- Hanging indent (first line flush left, subsequent lines indented)
- Double-spaced
- Only capitalize first word of title and subtitle, and proper nouns

## Books

### Single Author
**In-text:** (Brown, 2019) or Brown (2019)
**Reference:** Brown, A. (2019). *Marketing fundamentals*. Oxford University Press.

### Two Authors
**In-text:** (Johnson & Lee, 2021) or Johnson and Lee (2021)
**Reference:** Johnson, M., & Lee, S. (2021). *Digital transformation strategies*. Wiley.

### Three or More Authors
**In-text:** (Chen et al., 2020) or Chen et al. (2020)
**Reference:** Chen, L., Wong, K., Tan, R., & Kumar, S. (2020). *Data analytics for business*. McGraw-Hill Education.

### Edited Book
**Reference:** Davis, P. (Ed.). (2022). *Contemporary business practices*. Pearson.

### Book Chapter
**Reference:** Williams, T. (2021). Sustainable supply chains. In R. Garcia (Ed.), *Modern logistics management* (pp. 145-168). Routledge.

### E-book
**Reference:** Martinez, E. (2020). *Financial accounting principles*. https://doi.org/10.1234/5678

## Journal Articles

### Journal Article with DOI
**In-text:** (Anderson, 2022) or Anderson (2022)
**Reference:** Anderson, R. (2022). The impact of artificial intelligence on employment. *Journal of Business Research*, 45(3), 234-256. https://doi.org/10.1016/j.jbusres.2022.01.023

### Journal Article without DOI
**Reference:** Thompson, K. (2021). Consumer behavior in digital markets. *Malaysian Business Review*, 12(4), 89-107.

### Article with Multiple Authors
**In-text:** (Lee et al., 2023) or Lee et al. (2023)
**Reference:** Lee, Y., Tan, M., & Ahmad, H. (2023). E-commerce adoption in Southeast Asia. *Asian Journal of Marketing*, 18(2), 145-162. https://doi.org/10.1234/ajm.2023.5678

### Online Journal Article
**Reference:** Hassan, N. (2022). Digital marketing trends in Malaysia. *Online Marketing Review*, 7(1), 23-41. http://www.omr.edu.my/articles/2022/digital-trends

## Websites and Online Sources

### Webpage with Author
**In-text:** (Green, 2023) or Green (2023)
**Reference:** Green, J. (2023, March 15). *Understanding blockchain technology*. Tech Insights. https://www.techinsights.com/blockchain-guide

### Webpage without Author
**In-text:** (Ministry of Education, 2022) or Ministry of Education (2022)
**Reference:** Ministry of Education Malaysia. (2022, June 10). *Higher education statistics 2022*. https://www.moe.gov.my/statistics2022

### Webpage with No Date
**In-text:** (World Health Organization, n.d.) or World Health Organization (n.d.)
**Reference:** World Health Organization. (n.d.). *Mental health guidelines*. Retrieved November 4, 2025, from https://www.who.int/mental-health

### Online News Article
**Reference:** Lim, S. (2023, October 1). Malaysia's economic outlook remains positive. *The Star*. https://www.thestar.com.my/business/economy/2023/10/01/economic-outlook

### Blog Post
**Reference:** Chan, P. (2022, August 20). Five tips for effective remote work. *Productivity Blog*. https://www.productivityblog.com/remote-work-tips

## Reports and Grey Literature

### Government Report
**Reference:** Department of Statistics Malaysia. (2023). *Economic census 2023: Key findings*. https://www.dosm.gov.my/census2023

### Corporate/Organization Report
**Reference:** World Economic Forum. (2022). *The future of jobs report 2022*. https://www.weforum.org/reports/future-of-jobs-2022

### White Paper
**Reference:** McKinsey & Company. (2023). *Digital transformation in Malaysian businesses*. https://www.mckinsey.com/my/digital-transformation

## Conference Papers and Presentations

### Conference Paper
**Reference:** Chong, W. L. (2023, May 15-17). Machine learning applications in finance [Conference presentation]. International Conference on Technology and Business, Kuala Lumpur, Malaysia.

### Conference Proceedings
**Reference:** Rahman, A. (2022). Sustainability in supply chain management. In K. Tan (Ed.), *Proceedings of the 2022 Operations Management Conference* (pp. 78-92). IEEE.

## Theses and Dissertations

### Published Thesis
**Reference:** Ng, L. H. (2021). *Consumer adoption of mobile payment systems in Malaysia* [Doctoral dissertation, Universiti Malaya]. UM Repository. http://studentsrepo.um.edu.my/12345

### Unpublished Thesis
**Reference:** Subramaniam, K. (2022). *The role of social media in brand building* [Master's thesis, Tunku Abdul Rahman University of Management and Technology]. Unpublished manuscript.

## Social Media

### Facebook Post
**Reference:** National Geographic [@natgeo]. (2023, September 20). *Climate change impact on marine life* [Image attached] [Status update]. Facebook. https://www.facebook.com/natgeo/posts/12345

### Twitter/X Post
**Reference:** Gates, B. [@BillGates]. (2023, July 10). *AI will transform education in the next decade* [Tweet]. Twitter. https://twitter.com/BillGates/status/1234567890

### Instagram Post
**Reference:** Harvard Business Review [@harvardbusiness]. (2023, June 5). *Leadership tips for 2023* [Photograph]. Instagram. https://www.instagram.com/p/ABCD1234

## Videos and Multimedia

### YouTube Video
**Reference:** TED. (2023, April 12). *The future of work | Jane Doe* [Video]. YouTube. https://www.youtube.com/watch?v=abc123xyz

### Podcast Episode
**Reference:** Smith, J. (Host). (2023, May 15). *Episode 42: Understanding cryptocurrency* (No. 42) [Audio podcast episode]. In *Tech Talk Podcast*. Spotify. https://open.spotify.com/episode/12345

## Special Cases

### Secondary Source (Citing a Source You Haven't Read)
**In-text:** Original work by Wilson (as cited in Brown, 2022)
**Reference:** Brown, A. (2022). *Modern marketing theories*. Pearson.
*Note: Only cite Brown (2022) in reference list, not Wilson*

### Personal Communication (Email, Interview)
**In-text only:** (K. Tan, personal communication, October 15, 2023)
*Note: Do NOT include in reference list*

### No Author
**In-text:** (*Title of Work*, 2023) or *Title of Work* (2023)
**Reference:** *Annual business trends report*. (2023). Business Publications Inc.

### Multiple Works by Same Author
**Same year:**
- In-text: (Smith, 2022a), (Smith, 2022b)
- Reference: Arrange alphabetically by title, add letters a, b, c after year

## Common Formatting Rules

### Capitalization
- **Book/article titles**: Only capitalize first word, first word after colon, and proper nouns
- **Journal titles**: Capitalize all major words
- **Websites**: Use the capitalization from the source

### Italics
- Book titles
- Journal names
- Volume numbers (but NOT issue numbers)
- Periodical titles

### DOI and URL
- Preferred format: https://doi.org/XX.XXXX/XXXX
- If no DOI, use URL
- No "Retrieved from" unless content may change (n.d. sources)
- No period after DOI or URL

### Author Names
- Surname, Initials (without space between initials)
- Up to 20 authors: List all
- 21+ authors: List first 19, then ... then final author

### Dates
- Year only: (2023)
- Year and month: (2023, May)
- Year, month, and day: (2023, May 15)
- No date: (n.d.)

## Quick Reference Chart

| Source Type | In-Text Example | Reference Example |
|-------------|----------------|-------------------|
| Book | (Author, Year) | Author, A. A. (Year). *Title*. Publisher. |
| Journal | (Author, Year) | Author, A. A. (Year). Title. *Journal*, vol(issue), pages. DOI |
| Website | (Author/Org, Year) | Author/Org. (Year, Month Day). *Title*. Site. URL |
| Report | (Organization, Year) | Organization. (Year). *Title*. URL |
| Thesis | (Author, Year) | Author, A. A. (Year). *Title* [Type]. Institution. URL |

## Examples for TAR UMT Context

### Citing University Documents
**Reference:** Tunku Abdul Rahman University of Management and Technology. (2023). *Guideline on plagiarism*. https://portal.tarumt.edu.my/guidelines

### Citing Course Materials
**In-text:** (Department of Finance, 2023)
**Reference:** Department of Finance, TAR UMT. (2023). *FIN301 course handbook*. Unpublished manuscript.

### Citing Lecture Notes
**In-text:** (Prof. Tan, 2023, September 20)
**Reference:** Tan, K. L. (2023, September 20). *Week 5: Marketing strategies* [Lecture notes]. MKT201, Tunku Abdul Rahman University of Management and Technology.

## Common Mistakes to Avoid

❌ **Wrong:** Retrieved from https://www.example.com
✓ **Right:** https://www.example.com

❌ **Wrong:** Author, A.A. (2023). Title of article. Journal of Studies, 10(2), 45-60. doi:10.1234/example
✓ **Right:** Author, A. A. (2023). Title of article. *Journal of Studies*, 10(2), 45-60. https://doi.org/10.1234/example

❌ **Wrong:** Smith, J., Jones, K., & Lee, M. (2023)
✓ **Right:** Smith, J., Jones, K., & Lee, M. (2023) - Correct for 3 authors!

❌ **Wrong:** (Smith, Jones, & Lee, 2023) for second citation
✓ **Right:** (Smith et al., 2023) for second and subsequent citations

## For More Information

- Official APA Style website: https://apastyle.apa.org
- TAR UMT Library APA guide
- Your course lecturer or tutor
- TAR UMT Writing Center (if available)