---
name: tar-umt-fyp-rds
description: Comprehensive guide for TAR UMT Data Science (RDS) students completing their Final Year Project. Use when RDS students need help with (1) understanding FYP processes and requirements, (2) structuring FYP reports and deliverables, (3) writing research-based chapters and thesis, (4) selecting appropriate data science projects, (5) understanding research methodology and theoretical frameworks, (6) conducting experiments and statistical analysis, (7) preparing for system testing and presentations, (8) meeting submission deadlines and formats, (9) report formatting and structure requirements, or (10) any other FYP-related guidance specific to Data Science students at TAR UMT.
---

# TAR UMT Final Year Project Guide for Data Science (RDS) Students

## Overview

This skill provides comprehensive guidance for Bachelor of Computer Science (Data Science) students completing their Final Year Project at TAR UMT, Penang Branch. It covers the complete FYP journey from project selection through final submission, with special emphasis on research-based projects.

## When to Use This Skill

Use this skill when students ask about:
- FYP processes, workflows, or deadlines
- Project selection and proposal requirements
- FYP report structure and formatting
- Document formatting and appendices requirements
- Abstract writing guidelines
- Detailed chapter-by-chapter writing instructions for research thesis
- Research methodology and theoretical frameworks
- Experimental design, hypothesis testing, and statistical analysis
- Literature review methodology and structure
- Model improvement and comparison strategies
- Deliverables for Project I or Project II
- Programme specialization requirements for RDS students
- Assessment rubrics and grading criteria
- System testing and presentation requirements
- Academic integrity and ethics requirements
- Application-based project deployment and documentation

## Reference Documents

### For Report Formatting and Structure

**`references/report_formatting_guide.md`** - Read this when students need:
- Document structure and order (cover page, declaration, abstract, TOC, chapters, references, appendices)
- Abstract writing guidelines (5 components, 300 words maximum, no bullets/headings)
- Declaration statement exact wording
- Appendices requirements and structure:
  - Appendix A: User Guide (mandatory for all projects)
  - Appendix B: Developer Guide (for Smart Campus and Real-Life projects)
  - Other appendices as needed
- Chapter 6: System Deployment (for application-based projects)
- Chapter 7: Discussions and Conclusion structure (for application-based projects)
- Chapter summary and evaluation requirements
- Formatting tips for data science projects
- Quick checklist for report structure

### For Detailed Research Writing Guidance

**`references/research_writing_guide.md`** - Read this when students need:
- Detailed chapter-by-chapter writing instructions for research-based FYP
- Pre-project planning (5 essential items to answer before starting)
- Comprehensive structure for research proposals
- In-depth guidance for Chapters 1-7 of research thesis
- Literature review methodology (S-D-C-L approach: Summarize, Describe, Criticise, Link)
- Research methodology and theoretical framework construction
- Experimental design and evaluation criteria
- Statistical analysis and hypothesis testing guidance
- Results interpretation and research implications
- Model improvement strategies (high vs low novelty approaches)
- Pre-trained model enhancement methods
- Confidence interval calculations with formulas
- Understanding theoretical breadth vs depth
- Publication strategies for top journals
- Comprehensive FAQs covering 10 common research questions
- Benchmark dataset sources and recommendations
- FYP Preview and Viva preparation guidelines

### For APA Citations and Academic Integrity

**`tar-umt-academic-writing` skill** - Use this when students need:
- APA referencing and citation format
- Avoiding plagiarism through proper paraphrasing
- Understanding Turnitin similarity reports
- TAR UMT's academic integrity policies

## Key FYP Information for RDS Students

### FYP Structure

The FYP is completed over TWO courses:
1. **BACS3403 Project I** - Planning, requirements analysis, and system design
2. **BACS3413 Project II** - Implementation, testing, presentation, and final report

Students must PASS Project I (≥50%) to proceed to Project II.

### RDS Programme Specialization

RDS students focus on **Data Science** projects including:

**Application-based projects:**
- Data visualization and exploratory tools (business, healthcare, transport, manufacturing, etc.)
- Time-series forecasting models
- Machine learning models for intelligent systems
- Backend systems for big data harvesting
- Data flow interfaces and access mechanisms

**Research-based projects:**
- Feature engineering research
- Data mining techniques
- Artificial intelligence and machine learning
- Natural language processing
- Anomaly detection
- Social network analysis
- Image & video processing, computer vision
- Machine learning approaches for various applications

### Project Types

Students can choose from:
1. **Application Projects** - Develop data science software/systems (see report_formatting_guide.md for deployment chapter)
2. **Research Projects** - Address research questions with ML/AI approaches (see research_writing_guide.md for detailed guidance)
3. **Entrepreneurial Projects** - Develop applications for commercialization

### Project Characteristics

Projects may have:
- **Competition alignment** - Submit to external competitions (e.g., hackathons, Imagine Cup)
- **External clients** - Industrial projects with external organizations (requires MoA)
- **Internal clients** - Smart Campus, cross-faculty, or departmental projects

## Project I (BACS3403) Requirements

### Deliverables (submit progressively):
1. **Project Proposal** (Forms 1, 2, 3) - Must be approved by supervisor AND moderator
   - For research-based proposals, see research_writing_guide.md for detailed structure
2. **Chapter 1: Introduction**
   - For research-based Chapter 1 structure, see research_writing_guide.md Section "Chapter 1: Introduction"
3. **Chapter 2: Literature Review** (for research) or **Related Work** (for applications)
   - For literature review methodology and structure, see research_writing_guide.md Section "Chapter 2: Literature Review"
   - Learn the S-D-C-L method (Summarize, Describe, Criticise, Link) in the guide
4. **Chapter 3: Methods and Requirements Analysis**
   - For research methodology, see research_writing_guide.md Section "Chapter 3: Research Methodology"
   - Includes theoretical framework, proposed solution, and salient features
5. **Chapter 4: Research Design** (for research) or **System Design** (for applications)
   - For research design, see research_writing_guide.md Section "Chapter 4: Research Design"
   - Covers datasets, experimental setup, and evaluation criteria
6. **Project I Portfolio** - All deliverables compiled

### Key Points:
- Show DRAFT versions to supervisor before submitting finals
- Quality of initial drafts affects marks
- Meet regularly with supervisor (≥2 times/month)
- Maintain project file with all documentation
- For research projects, ensure you have answered the 5 essential items (see research_writing_guide.md)

## Project II (BACS3413) Requirements

### Deliverables:
1. **Test Plans** - Prepare comprehensive test cases
2. **System Preview** - Demo to supervisor (see research_writing_guide.md for FYP Preview guidelines)
3. **Final System Testing** - With supervisor and moderator (MUST PASS to pass FYP)
4. **5-minute Formal Presentation** - Present project overview
5. **Draft FYP Report** - Complete report including:
   - **Front Matter** (see report_formatting_guide.md):
     - Cover page
     - Title page
     - Copyright statement
     - Declaration (exact wording provided)
     - Abstract (300 words max, 5 components, no bullets - see detailed guidelines)
     - Acknowledgement
     - Table of Contents
   - **Updated Chapters from Project I** (Chapters 1-4)
   - **New Chapters:**
     - Chapter 5: Results and Evaluation (see research_writing_guide.md Section "Chapter 5: Results and Evaluation")
     - Chapter 6: For application projects see report_formatting_guide.md "Chapter 6: System Deployment"; for research projects see research_writing_guide.md "Chapter 6: Future Work"
     - Chapter 7: For application projects see report_formatting_guide.md "Chapter 7: Discussions and Conclusion"; for research projects see research_writing_guide.md "Chapter 7: Conclusion"
   - **References** (APA format - use tar-umt-academic-writing skill)
   - **Appendices** (see report_formatting_guide.md for detailed requirements):
     - Appendix A: User Guide (mandatory)
     - Appendix B: Developer Guide (for Smart Campus/Real-Life projects)
     - Other appendices as needed
6. **Poster** - A1 size PowerPoint format
7. **Final FYP Report** (softcopy only)
8. **Digital Submission** - Source code, abstract, keywords, poster

### Critical Requirements:
- Must PASS final system testing to pass FYP
- Ensure sufficient data in databases for demonstration
- Prepare sample data and test cases
- Print requirements document for moderator
- Demonstrate understanding of your work
- For research projects, ensure all experiments are completed with statistical tests (95% confidence intervals)
- Follow exact report structure (see report_formatting_guide.md)
- Include mandatory appendices (User Guide always required)

## RDS-Specific Project Guidelines

### For Higher Grades (A/A-):

**Application-based:**
- Understand and implement algorithms from scratch (e.g., support vector regression)
- Adopt frameworks/libraries (Azure ML Studio, TensorFlow, Keras, PyTorch)
- Implement image processing (face recognition, object detection using OpenCV, MATLAB)
- Develop systems with fuzzy logic for forecasting
- Create automated systems using linguistic analysis and ML
- Implement e-commerce with ML-based customer segmentation
- Apply steganography methods with access control
- Develop computer vision automation using OpenCV

**Research-based:**
- Novel feature engineering techniques
- Hybrid models combining multiple approaches
- Transfer learning with pre-trained models
- Ensemble methods (bagging, boosting, stacking)
- Deep learning architectures (CNN, RNN, LSTM, GAN, Transformer)
- Optimization algorithms (genetic algorithms, particle swarm)
- Advanced NLP techniques (BERT, GPT, word embeddings)
- Explainable AI methods
- Federated learning approaches
- Active learning strategies

### For Average Grades (B/C):

**Application-based:**
- Implement existing algorithms using libraries (scikit-learn, TensorFlow, Keras)
- Basic data preprocessing and cleaning
- Standard ML models (regression, classification, clustering)
- Data visualization dashboards (Matplotlib, Seaborn, Plotly, Tableau)
- Web-based data applications (Flask, Django)
- Database integration with data systems
- Basic recommendation systems

**Research-based:**
- Standard ML algorithms with parameter tuning
- Comparative studies of existing methods
- Apply established techniques to new datasets
- Basic feature selection and engineering
- Standard evaluation metrics and validation
- Replication studies with improvements

## Research-Based Projects (RDS Focus)

### Pre-Project Planning (Essential)

Before starting your research project, you MUST answer these 5 items (detailed in research_writing_guide.md):
1. What's your research question and hypothesis?
2. What gap are you filling in existing research?
3. What datasets will you use (benchmark + real-world)?
4. What evaluation metrics and baseline methods?
5. How does it align with SDGs?

### Research Methodology Requirements

**Must include:**
- Clear research questions or hypotheses
- Theoretical framework grounding your approach
- Justification for ML/AI methods chosen
- Description of datasets (features, size, preprocessing)
- Experimental design (train/test split, cross-validation, etc.)
- Baseline methods for comparison
- Evaluation metrics (accuracy, precision, recall, F1, RMSE, etc.)
- Statistical validation (confidence intervals, hypothesis testing)

**For detailed guidance, see research_writing_guide.md**

### Model Improvement Strategies

**Two approaches:**

**1. High Novelty (for stronger research):**
- Propose new model architectures
- Novel feature engineering methods
- Hybrid approaches combining techniques
- New optimization strategies
- Original theoretical contributions

**2. Low Novelty (still acceptable):**
- Apply existing models to new datasets
- Hyperparameter optimization
- Ensemble of existing methods
- Transfer learning from pre-trained models
- Comparative analysis of techniques

**For detailed model improvement strategies and pre-trained model enhancement, see research_writing_guide.md FAQ 4 and FAQ 5**

### SDG Alignment
All research must align with at least one Sustainable Development Goal (SDG).
- Discuss alignment in Chapters 1, 2, and 7
- Show how research contributes to SDG objectives
- Link findings to SDG impacts

**For SDG information and alignment guidance, see research_writing_guide.md FAQ 10**

## Academic Integrity for RDS Students

### Plagiarism - STRICTLY PROHIBITED:
- Do NOT copy code without proper attribution
- Do NOT copy text from papers/websites without citation
- Do NOT use others' ML models without acknowledgment
- Do NOT submit work done by others or previous students
- Do NOT collaborate on individual assignments without permission

### Proper Attribution:
- Cite all sources using APA format (use tar-umt-academic-writing skill)
- Acknowledge datasets, pre-trained models, and open-source libraries
- Document all code sources and adaptations
- Reference research papers that informed your approach

### Research Ethics:
- If collecting data via surveys, get supervisor approval for questions
- Do NOT collect personal data (name, IC, contact) without Faculty Ethics Committee approval
- For TAR UMT student surveys, get Faculty Ethics Committee approval
- Keep collected data confidential and secure
- Follow TAR UC's Ethical Guidelines for Research

## Common Mistakes to Avoid

1. **Starting late** - Begin supervisor search and project selection early
2. **Poor time management** - Missing deadlines affects grades
3. **Insufficient meetings** - Meet supervisor regularly (≥2 times/month)
4. **Low-quality drafts** - Invest time in drafts; quality affects final marks
5. **Plagiarism** - Always cite sources and acknowledge code/model sources
6. **Incomplete testing** - Prepare comprehensive test cases and sample data
7. **Missing Turnitin report** - All submissions need Turnitin similarity reports
8. **Ignoring specialization requirements** - Ensure project meets RDS criteria
9. **Poor data preparation** - Ensure databases have sufficient demonstration data
10. **Weak documentation** - Document data sources, preprocessing, model choices
11. **Not answering the 5 essential items** - Critical for research proposals
12. **Insufficient statistical rigor** - Must include confidence intervals and hypothesis testing
13. **Poor literature review** - Not using S-D-C-L method systematically
14. **Missing SDG alignment** - Must relate to at least one SDG
15. **Incorrect report format** - Follow structure in report_formatting_guide.md
16. **Missing abstract components** - Abstract must have all 5 components (see report_formatting_guide.md)
17. **Incomplete appendices** - User Guide is mandatory for all projects
18. **No chapter summaries** - Every chapter needs summary and evaluation section

## Turnitin Requirements

- Students must submit Turnitin Similarity Report with all submissions
- Turnitin identifies matching text (including properly cited quotes)
- Turnitin does NOT determine plagiarism - supervisor does
- Color codes: Blue (0%), Green (1-24%), Yellow (25-49%), Orange (50-74%), Red (75-100%)
- High similarity % doesn't automatically mean plagiarism if properly cited
- Download and print Similarity Report to bind with assignments

## Assessment Focus Areas

Supervisors assess:
1. **Technical competence** - ML/data science skills, coding quality
2. **Research methodology** - Appropriate methods for data science, theoretical framework
3. **Analysis depth** - Quality of data analysis and interpretation, statistical rigor
4. **Innovation** - Novel approaches or improvements (high/low novelty)
5. **Documentation quality** - Clear, well-organized report following structure guidelines
6. **Project management** - Meeting deadlines, regular progress
7. **Presentation skills** - Clear communication of technical concepts
8. **Data handling** - Proper data collection, preprocessing, storage
9. **Model development** - Appropriate model selection and tuning
10. **Results interpretation** - Meaningful insights from analysis with research implications
11. **Literature quality** - Thorough review using S-D-C-L method
12. **Theoretical contribution** - Understanding of theoretical breadth vs depth
13. **SDG alignment** - Clear connection to sustainable development goals
14. **Report formatting** - Follows TAR UMT template structure (see report_formatting_guide.md)
15. **Appendices completeness** - All required appendices included and well-structured

## Quick Reference: Key Deadlines

Check FYP Google Classroom for specific deadlines for your cohort:
- Supervisor-Student matching
- Project Proposal submission
- Chapter submissions (Project I)
- Project I Portfolio
- Test Plans (Project II)
- System Preview
- Final System Testing
- Draft Report
- Final Report & Digital Submission

## Quick Reference: Essential Resources

### Benchmark Dataset Sources
- Mendeley Data: https://data.mendeley.com/
- ScienceDirect Data In Brief: https://www-sciencedirect-com.tarc.idm.oclc.org/journal/data-in-brief
- Network Data: https://networkrepository.com/
- Hugging Face: https://huggingface.co/datasets
- Kaggle: https://www.kaggle.com/datasets
- Malaysia Open Data: https://data.gov.my
- UCI Repository: https://archive.ics.uci.edu
- CEC Benchmarks: https://www3.ntu.edu.sg/home/epnsugan/index_files/cec-benchmarking.htm

**For complete list with explanations, see research_writing_guide.md**

### SDG Information
Sustainable Development Goals: https://sdgs.un.org/goals

### APA Citation Guide
TAR UMT APA Guide: https://www.tarc.edu.my/files/library/52FBEA86-8783-4DC9-889A-A5FE31EC9B8D.pdf
BibTeX to APA Converter: https://bibtex.online/

## Getting Help

1. **Primary contact:** Your FYP supervisor
2. **FYP Committee:** For process/administrative questions
3. **Programme Leader:** For programme-specific questions
4. **Google Classroom:** All forms, templates, announcements
5. **Detailed Research Writing:** Read `references/research_writing_guide.md`
6. **Report Formatting:** Read `references/report_formatting_guide.md`
7. **APA Citations & Plagiarism:** Use `tar-umt-academic-writing` skill

## Important Notes

- Projects with Grade B and above will be uploaded to TAR UC Institutional Repository
- FYP reports and artifacts are subject to IP rights policy
- Students working in teams write INDIVIDUAL reports
- Each team member must demonstrate their contribution
- Failure to pass system testing = failure of FYP
- Repeat students continue with same project (no major scope changes)
- Research-based projects must include hypothesis testing and statistical analysis
- All research must align with at least one SDG
- Use S-D-C-L method for literature review
- Report results with 95% confidence intervals
- Follow exact report structure from template (see report_formatting_guide.md)
- Abstract must be ≤300 words with all 5 components
- User Guide appendix is mandatory for ALL projects
- Developer Guide appendix required for Smart Campus and Real-Life projects

## Complete FYP Checklist

### Before Starting (Project 0):
- [ ] Answered the 5 essential items (see research_writing_guide.md)
- [ ] Aligned with at least one SDG
- [ ] Identified benchmark and real-world datasets
- [ ] Confirmed research is not redundant
- [ ] Reviewed similar published work

### During Project I:
- [ ] Proposal approved by supervisor AND moderator
- [ ] Chapter 1 complete with hypothesis (for research)
- [ ] Chapter 2 complete using S-D-C-L method
- [ ] Chapter 3 complete with theoretical framework (for research)
- [ ] Chapter 4 complete with experimental design
- [ ] Met with supervisor ≥2 times/month
- [ ] FYP Preview prepared
- [ ] Each chapter has summary and evaluation section

### During Project II:
- [ ] Chapter 5 complete with statistical analysis
- [ ] Chapter 6 complete (Deployment for application, Future Work for research)
- [ ] Chapter 7 complete with SDG alignment
- [ ] All experiments completed (95% CI for research)
- [ ] All figures/tables numbered and referenced
- [ ] Cover page formatted correctly
- [ ] Declaration page included with signature
- [ ] Abstract ≤300 words with 5 components, no bullets/headings
- [ ] Acknowledgement page included
- [ ] Table of Contents generated
- [ ] All appendices labeled (A, B, C...)
- [ ] Appendix A: User Guide complete (mandatory)
- [ ] Appendix B: Developer Guide complete (if required)
- [ ] All appendices cited in main text
- [ ] References in APA format with DOIs
- [ ] Turnitin report obtained
- [ ] Final viva prepared

### Report Structure Verification:
- [ ] Cover page → Title page → Copyright → Declaration → Abstract → Acknowledgement → TOC → Chapters 1-7 → References → Appendices
- [ ] Every chapter ends with "Chapter Summary and Evaluation"
- [ ] All formatting follows TAR UMT template (see report_formatting_guide.md)

---

**Remember:** Your FYP is a demonstration of your data science skills, research abilities, and professional development. For research-based projects, invest time in quality work with proper theoretical foundations, comprehensive experiments, and rigorous statistical analysis. For application-based projects, ensure complete documentation including deployment plans and user guides. Maintain academic integrity, follow the exact report structure, and communicate regularly with your supervisor for the best outcome.

**Quick Guide Reference:**
- **For research project content:** Use `references/research_writing_guide.md`
- **For report formatting and structure:** Use `references/report_formatting_guide.md`
- **For APA citations:** Use `tar-umt-academic-writing` skill
