# TAR UMT FYP Report Formatting and Structure Guide

## Overview

This guide provides detailed formatting and structural requirements for your FYP report based on TAR UMT's official template. Use this guide alongside the research_writing_guide.md for research-based projects.

## Document Structure and Order

Your FYP report must follow this exact order:

1. **Cover Page** (with TAR UMT logo)
2. **Title Page** (with supervisor name)
3. **Copyright Statement**
4. **Declaration**
5. **Abstract**
6. **Acknowledgement**
7. **Table of Contents**
8. **Main Chapters** (Chapters 1-7)
9. **References** (use APA format - see tar-umt-academic-writing skill)
10. **Appendices**

---

## Cover Page and Title Page

### Cover Page Requirements:
- Project title
- "By"
- Student name
- TAR UMT logo (provided in template)
- Faculty of Computing and Information Technology
- Tunku Abdul Rahman University of Management and Technology
- Location (Kuala Lumpur/Penang)
- Academic Year

### Title Page Requirements:
- Project title
- "By"
- Student name
- "Supervisor: [Supervisor Name]"
- Standard text: "A project report submitted to the Faculty of Computing and Information Technology in partial fulfillment of the requirement for the [Degree Name] [Programme Name]"
- Faculty and university details

### Copyright Statement:
Standard text provided:
"Copyright by Tunku Abdul Rahman University of Management and Technology. All rights reserved. No part of this project documentation may be reproduced, stored in retrieval system, or transmitted in any form or by any means without prior permission of Tunku Abdul Rahman University of Management and Technology."

---

## Declaration

Your declaration page must include this exact statement:

> "The project submitted herewith is a result of my own efforts in totality and in every aspect of the project works. All information that has been obtained from other sources had been fully acknowledged. I understand that any plagiarism, cheating or collusion or any sorts constitutes a breach of TAR University rules and regulations and would be subjected to disciplinary actions."

Followed by:
- Signature line
- Student name
- Date
- Student ID

---

## Abstract

The abstract is a **one-page summary** (maximum **300 words**) that appears BEFORE the Table of Contents.

### Important Rules:
- ✅ One page only
- ✅ Maximum 300 words
- ✅ No subheadings
- ✅ No bullet points
- ✅ Write as continuous prose (like research paper abstracts)
- ✅ Summarize the entire project

### Five Components to Include:

**1. Purpose**
- Main purpose of the project
- Problem to be solved
- Why it's necessary to solve it
- How the project contributes to the solution
- For research projects: State research questions/hypothesis

**2. Scope**
- Size and areas covered
- Functions and features of the system
- Modules or sub-modules involved
- Functional areas in the organization
- For research projects: Dataset types, model approaches

**3. Methodology**
- Methodology used (e.g., SDLC, Agile, Research Methodology)
- Tools and technologies (e.g., Python, TensorFlow, scikit-learn, PyTorch)
- Techniques used (e.g., Random Forest, CNN, LSTM, clustering)
- Models implemented (e.g., classification models, regression models)
- For research projects: Experimental design, evaluation metrics

**4. Testing Criteria Used**
- Assessment methods used
- For application projects: System testing, user acceptance testing
- For research projects: Evaluation metrics (accuracy, precision, recall, F1-score, RMSE, etc.)
- Statistical validation methods used (if applicable)

**5. Results and Conclusion**
- Key outcomes achieved
- Strengths of the system/research
- Weaknesses or limitations identified
- For research projects: Key findings, performance improvements
- Brief mention of future work

### Example Structure (Data Science Research Project):
"This research investigates [problem statement] in [domain]. The purpose is to [objective] by developing a novel [approach/model]. The scope encompasses [dataset description, size, features] and focuses on [specific aspects]. The methodology employs [research methodology] with [ML/AI techniques], utilizing [tools/frameworks] for implementation. Experiments were designed using [experimental setup], and models were evaluated using [metrics]. The proposed [model/approach] was tested on [datasets] and compared against [baseline methods]. Results demonstrate [key findings], achieving [performance metrics]. The research concludes that [main conclusion], with limitations in [areas] suggesting future work in [directions]."

### Example Structure (Data Science Application Project):
"This project develops [system name] to address [problem] in [domain]. The purpose is to provide [functionality] by implementing [solution approach]. The scope covers [modules/features], including [key functionalities] for [target users]. The methodology adopts [SDLC approach] with [programming languages/frameworks], incorporating [ML models/techniques] for [specific features]. Data processing utilizes [tools/libraries], and the system integrates [technologies]. Testing encompasses [testing types] to ensure [quality aspects]. Results show successful implementation of [features], with strengths in [areas] and opportunities for enhancement in [aspects]. The system demonstrates [value proposition] for [end users]."

---

## Acknowledgement

This section acknowledges those who contributed directly or indirectly to your project completion.

### Typically Include:
- Project supervisor(s)
- Moderator(s)
- Family members
- Industry partners or external clients (if applicable)
- Friends or classmates who provided assistance
- Organizations that provided data or resources
- Anyone who provided technical support or guidance

### Tips:
- Keep it professional and sincere
- Be specific about how people helped
- Usually 1/2 to 1 page
- Express genuine gratitude

---

## Main Chapters Structure

### For Research-Based Projects:
Follow the detailed chapter guidance in `research_writing_guide.md`:
- Chapter 1: Introduction
- Chapter 2: Literature Review
- Chapter 3: Research Methodology
- Chapter 4: Research Design
- Chapter 5: Results and Evaluation
- Chapter 6: Future Work
- Chapter 7: Conclusion

### For Application-Based Projects:
Standard chapter structure:
- Chapter 1: Introduction
- Chapter 2: Literature Review / Related Work
- Chapter 3: Methodology and Requirements Analysis
- Chapter 4: System Design
- Chapter 5: Implementation and Testing
- Chapter 6: System Deployment (see below)
- Chapter 7: Discussions and Conclusion (see below)

---

## Chapter 6: System Deployment (Application Projects)

This chapter is for **application-based projects** where you're deploying a data science system.

### 6.1 Deployment Plan
Describe your deployment strategy:
- Deployment environment (cloud, on-premise, hybrid)
- Infrastructure requirements
- Deployment architecture
- For data science applications: Model serving approach (REST API, batch processing, real-time)
- Scalability considerations
- Security measures

### 6.2 On-site Setup
Preparations and procedures for system setup:
- Pre-deployment checklist
- Setup procedures (step-by-step)
- Configuration requirements
- Database/data storage setup
- Model deployment procedures
- Testing on deployment environment
- Schedule and timeline

### 6.3 Training Procedure
User training plan:
- Training content and materials
- Training schedule
- Target audience (different user roles)
- Training methods (hands-on, documentation, video tutorials)
- For data science systems: How to interpret model outputs, dashboard usage

### 6.4 Follow-up
Post-deployment support plan:
- Monitoring procedures
- Performance tracking
- Model performance monitoring (for ML systems)
- Data drift detection (if applicable)
- Bug reporting and resolution process
- System maintenance schedule
- User feedback collection
- Update procedures

### 6.5 Chapter Summary and Evaluation
- Problems faced during deployment
- Solutions implemented
- Tools and techniques used
- Lessons learned

---

## Chapter 7: Discussions and Conclusion (Application Projects)

For research-based projects, follow the guidance in `research_writing_guide.md`. For application-based projects, use this structure:

### 7.1 Summary
Summarize the entire project:
- Problem addressed
- Proposed solution
- Justification for tool/technique choices
- Key methodologies used
- Data science approaches employed

### 7.2 Achievements
Evaluate against project objectives:
- Completed objectives and deliverables
- Successfully implemented modules/features
- Performance metrics achieved
- Strengths of the work:
  - Technical accomplishments
  - Model performance
  - System functionality
  - User experience
- Weaknesses identified:
  - Technical limitations
  - Performance constraints
  - Scope limitations

### 7.3 Contributions
Discuss the value and impact:
- Creativity and innovation in your approach
- Technical contributions:
  - Novel data preprocessing techniques
  - Unique feature engineering
  - Model architecture innovations
  - Algorithm improvements
- Practical contributions:
  - Problem-solving value
  - User benefits
  - Business impact
- Why the system is necessary
- Marketability or commercialization potential

### 7.4 Limitations and Future Improvements
Be honest about limitations:
- **Technical limitations:**
  - Model accuracy/performance constraints
  - Dataset size or quality limitations
  - Computational resource constraints
  - Scalability issues
- **Scope limitations:**
  - Features not implemented
  - User roles not covered
  - Incomplete functionality
- **Future improvements:**
  - Additional features to implement
  - Model enhancements (different algorithms, ensemble methods)
  - Data collection improvements
  - User interface enhancements
  - Performance optimizations
  - Integration with other systems

### 7.5 Issues and Solutions

**IMPORTANT NOTE:** For technical problems related to code, hardware, internet connection, data issues, etc:

**Technical Issues:**
- List technical problems faced and state how they were resolved
- List unsolved technical problems for future enhancement
- Data science specific issues:
  - Data quality problems and solutions
  - Model training challenges
  - Overfitting/underfitting issues
  - Computational limitations
  - Library/framework compatibility issues

**Project Management Issues:**
- Timeline challenges
- Resource allocation problems
- Team coordination (if team project)
- Scope management

**Lessons Learned:**
- Valuable experiences gained
- What would you do differently
- Best practices discovered
- Skills developed

---

## Appendices

Appendices should contain **supportive materials directly referred to** in your report. Keep appendices to a **minimum**.

### Important Principles:

**✅ Include in Main Body:**
- All directly relevant materials
- Essential figures, diagrams, or tables
- Anything necessary for understanding the project

**✅ Include in Appendices:**
- Supportive materials referenced in the main text
- Materials too voluminous for main body
- Supplementary information

**❌ Do NOT Include in Appendices:**
- Materials never referenced in main text
- Entire documents when only excerpts are relevant
- Irrelevant materials

### Required Appendices Numbering:
- Use letters: Appendix A, Appendix B, Appendix C, etc.
- Equations: Eq. (A.1), Eq. (A.2), then Eq. (B.1), Eq. (B.2)
- Tables: Table A.1, Table A.2, then Table B.1
- Figures: Fig. A.1, Fig. A.2, then Fig. B.1

---

## APPENDIX A: User Guide (MANDATORY)

This appendix is **required for all projects**.

### Must Include:

**1. Login Credentials**
- List username and password for all user roles
- For data science applications: admin, data analyst, viewer, etc.
- Include test accounts if applicable

**2. System Screenshots and Functionality**
- Clear screenshots of each page/interface
- Explain the function of each button/control
- Step-by-step workflows
- For data science applications:
  - Dashboard interfaces
  - Data upload/input screens
  - Model prediction/results screens
  - Visualization features
  - Report generation

### Sections to Include:

#### System Documentation

**A. System Requirements**
Minimum hardware and software requirements:
- Operating System (Windows/Mac/Linux versions)
- Processor specifications
- RAM requirements
- Storage space
- Graphics requirements (if applicable)
- Software dependencies:
  - Python version and required libraries (pandas, numpy, scikit-learn, tensorflow, etc.)
  - Database management system (PostgreSQL, MongoDB, etc.)
  - Web server requirements (if web-based)
  - Browser requirements (if web application)

**B. Installation Guide**
Provide step-by-step installation instructions:
1. System setup
2. Software installation
3. Database setup (including schema creation)
4. Configuration files setup
5. Environment variables
6. Dependencies installation (pip install requirements.txt)
7. Model files location and loading
8. Initial data setup
9. Running the application

For data science applications, include:
- How to set up virtual environment
- Installing Python packages
- Loading pre-trained models
- Setting up data directories
- Database connection configuration

#### Operation Documentation

**C. User Operation Guide**
Step-by-step guide on using the system:

**Getting Started:**
1. How to launch the application
2. Login process (with credentials)
3. Navigation overview
4. User interface layout

**Core Features:** (for each major feature)
1. Purpose of the feature
2. Step-by-step usage instructions
3. Screenshots showing each step
4. Expected outcomes
5. Error handling

**For Data Science Applications, include:**
- Data upload procedures
- Data preprocessing options
- Model selection (if multiple models)
- Running predictions/analysis
- Interpreting results
- Visualizations and reports
- Exporting results
- Data management features

**Different User Roles:** (if applicable)
- Administrator functions
- Data analyst functions
- Viewer/end-user functions
- Each role's specific workflows

---

## APPENDIX B: Developer Guide (CONDITIONAL)

**Required for:**
- Smart Campus Projects
- Real-Life Projects (with external clients)
- Projects intended for future development

**Not required for:**
- Simple classroom projects
- Proof-of-concept projects

### Must Include:

**1. Development Environment Setup**
- IDE recommendations
- Development tools required
- Version control setup (Git)
- Development dependencies

**2. Software, Installers, and Libraries**
List all necessary components:
- Programming language version
- Framework versions
- Required libraries and packages with versions
- API keys and external service requirements
- Database system and version

For data science projects:
- Python libraries (pandas, numpy, scikit-learn, tensorflow, pytorch, matplotlib, seaborn, etc.)
- Jupyter notebook requirements (if used)
- Model training libraries
- Data processing tools
- Visualization libraries

**3. Project Structure**
- Directory structure explanation
- File organization
- Module descriptions
- Configuration files

**4. Authentication Details**
- Database credentials (for development)
- API keys and secrets (use environment variables)
- Service accounts
- Third-party service authentication

**5. Code Documentation**
- Key functions and classes
- Module interactions
- Data flow
- Model architecture (for ML projects)
- Training pipeline (if applicable)

**6. Development Workflow**
- How to add new features
- Testing procedures
- Deployment process
- Version control practices

**7. Troubleshooting**
- Common development issues
- Debug procedures
- Log file locations
- Known issues and workarounds

---

## Other Appendices (As Needed)

### APPENDIX C: Supporting Documents
Examples of what to include:
- Company reports or documentation (if external client)
- Sample forms (invoice, purchase order, etc.)
- Project meeting documentation:
  - Minutes of meetings
  - Progress tracking documents
  - Communication memos

### APPENDIX D: Research Materials (for research projects)
- Questionnaires and survey results
- Interview questions and results
- Observation sheets and results
- Experiment test plans and detailed results
- Additional statistical analyses
- Detailed data preprocessing steps

### APPENDIX E: Design Documents (if not in main body)
- Additional UML diagrams
- Database schema (if extensive)
- Wireframes and mockups
- System architecture diagrams
- Data flow diagrams

### APPENDIX F: Dataset Information (for data science projects)
- Dataset description and sources
- Data dictionary (detailed feature descriptions)
- Data collection methodology
- Data cleaning procedures
- Statistical summaries of data
- Sample data records

### APPENDIX G: Model Details (for research projects)
- Hyperparameter tuning results
- Cross-validation results
- Detailed confusion matrices
- ROC curves and other performance plots
- Model comparison tables
- Training logs

### Non-Disclosure Agreement (NDA)
- Include if applicable for industry projects
- Usually as a separate appendix

---

## Chapter Summary and Evaluation (End of Each Chapter)

At the end of **every chapter**, include a brief section that evaluates the chapter contents.

### Should Include:
1. **Problems Faced**
   - Challenges encountered in this phase
   - Technical difficulties
   - Resource constraints
   - For data science: data issues, model challenges, computational problems

2. **Solutions Implemented**
   - How problems were resolved
   - Alternative approaches tried
   - Workarounds developed

3. **Tools and Techniques Used**
   - Software and libraries used in this phase
   - Methodologies applied
   - Reasons for choosing them
   - For data science: specific algorithms, frameworks, evaluation methods

### Keep it Brief:
- Usually 1/2 to 1 page
- Focused on this chapter's work
- Reflective and honest

---

## Formatting Tips

### General Formatting:
- Use consistent heading styles (TAR UMT template provides these)
- Number all figures and tables
- Reference all figures and tables in text
- Use captions for figures and tables
- Maintain consistent fonts and spacing

### For Data Science Projects:
- Include code snippets in appendices, not main body (unless essential)
- Format tables and results clearly
- Use appropriate precision for numerical results
- Label all axes on charts and graphs
- Include units where applicable
- Use standard notation for mathematical expressions

### Citations:
- Use APA format throughout (refer to tar-umt-academic-writing skill)
- Cite datasets used
- Cite pre-trained models or libraries
- Acknowledge open-source tools
- Reference research papers that informed your approach

---

## Quick Checklist: Report Structure

Before submission, verify:

- [ ] Cover page with all required elements
- [ ] Title page with supervisor name
- [ ] Copyright statement (exact wording)
- [ ] Declaration page (exact wording and signature)
- [ ] Abstract (≤300 words, 5 components, no bullets/headings)
- [ ] Acknowledgement page
- [ ] Table of Contents (auto-generated in Word)
- [ ] All main chapters (1-7) complete
- [ ] References in APA format (use tar-umt-academic-writing skill)
- [ ] Appendix A: User Guide (mandatory)
- [ ] Appendix B: Developer Guide (if required for your project type)
- [ ] Other appendices as needed
- [ ] All figures numbered and referenced in text
- [ ] All tables numbered and referenced in text
- [ ] Chapter summaries at end of each chapter
- [ ] Consistent formatting throughout
- [ ] Page numbers present
- [ ] Turnitin similarity report obtained

---

## Using This Guide

**For Research-Based Projects:**
- Use this guide for: Document structure, Abstract, Declaration, Appendices
- Use `research_writing_guide.md` for: Chapters 1-7 content guidance

**For Application-Based Projects:**
- Use this guide for: All formatting and structure including Chapters 6-7
- Use `research_writing_guide.md` for: Research methodology concepts if needed

**For APA Citations:**
- Always refer to the `tar-umt-academic-writing` skill

---

**Remember:** This formatting guide ensures your report meets TAR UMT's official standards. Follow it carefully to avoid formatting-related issues during submission or assessment.
