# TAR UMT Research Writing Guide for RDS Students

## Overview

This guide provides detailed, chapter-by-chapter instructions for writing research-based Final Year Projects for Data Science (RDS) students at TAR UMT, Penang Branch. It covers everything from the initial proposal through to the final thesis.

**Use this guide when you need:**
- Detailed structure for each chapter of your research thesis
- Guidance on writing methodology and theoretical frameworks
- Instructions for experimental design and evaluation
- Help with statistical analysis and hypothesis testing
- Understanding of how to structure literature reviews
- Guidance on model improvement and comparison strategies

---

## Pre-Project Planning: The 5 Essential Items

Before starting your proposal, answer these five critical questions:

### 1. Topic of Interest
- What specific situations have been observed that require questions to be answered in your research?
- Contract your title based on the Topic of Interest. It should communicate:
  - Key variables/technologies
  - Population studies
  - Research design

### 2. Background of the Problem with Literature Review
- What is already known about the research problem?
- What aspects have NOT been investigated yet?
- Citations required - recent and reputed references

### 3. Significance of the Study
- How would the research contribute to the 'body of knowledge'?
- What are the expected substantial outcomes?
- Advantages and contributions

### 4. Definition of Concepts
- What are the definitions of the terms/concepts that will be investigated?
- This influences your theoretical foundation/framework

### 5. Research Objectives
- What goals can be achieved to respond to the research problem?
- Should be SPECIFIC, MEASURABLE, and ACHIEVABLE

---

## Self-Check Criteria for Research-Based FYP

**Source of inspiration:**
1. Published articles (preferable)
2. Updated world-local authority initiatives
3. 17 Sustainable Development Goals (SDGs)

**Quality checks:**
1. Will you be able to produce an article (for publication) based on your findings?
2. Is your work a redundant proposal compared with published models?
3. How robust is your proposed model by testing on both benchmark and real-world datasets?

**Benchmark Dataset Sources:**
- Mendeley Data: https://data.mendeley.com/
- ScienceDirect Data In Brief: https://www-sciencedirect-com.tarc.idm.oclc.org/journal/data-in-brief
- Network Data: https://networkrepository.com/
- Hugging Face: https://huggingface.co/datasets
- Kaggle: https://www.kaggle.com/datasets
- Malaysia Open Data: https://data.gov.my
- UCI Repository: https://archive.ics.uci.edu
- TSPLIB: http://comopt.ifi.uni-heidelberg.de/software/TSPLIB95/
- CEC Benchmarks: https://www3.ntu.edu.sg/home/epnsugan/index_files/cec-benchmarking.htm

---

## Research Proposal Structure

### Abstract (200-250 words maximum)
Write this AFTER completing your proposal. The abstract should include (in order):
1. Brief background of your research
2. Research problem(s)
3. Research objective(s)
4. Research methodology
5. Summary of results (only in final thesis)
6. Research contributions and significance

### Problem Section
**How to write:**
- Conduct a thorough literature review about the problems in your target domain
- Begin with a brief background of your research
- Discuss the problems you've found in literature (with citations - recent and reputed references)
- Think of these problems as opportunities for your research

**Key questions to address:**
- What are the major problems related to your research?
- What is already known about the problem (what have others done)?
- What aspects have NOT been investigated yet?

### Solution Section

**State your research objectives:**
- Three to four objectives
- Must be SPECIFIC, MEASURABLE, and ACHIEVABLE
- Can be verified at the end of your milestones
- Alternatively, state research questions if applicable

**Describe your proposed solution:**
- Outline the importance of methodology
- Focus on specific algorithms, methods, models, and techniques
- Explain how they will address the research questions
- Briefly discuss data sources (where to obtain, what it's about, how it relates to your solution)
- Must be geared towards achieving your research objectives

**Definition of Concepts:**
- Define the terms/concepts that will be investigated
- This influences your theoretical foundation/framework

### Target Market
Populate from Technical, Economical/Cost, Operational, Market, and Social Feasibilities

### Competition/Contribution
- **Contribution:** Relate your research to at least one (1) SDG
- **Competition:** Review at least 2 existing solutions related to your work
- Discuss how your research is different/better from them

### Milestones
Use Gantt chart covering two semesters (Project I & II)

### References
- APA format
- Recent (~3 years)
- Reputable references (preferably journal/conference papers, books)

---

## Chapter 1: Introduction

### Structure and Content

#### 1.1 Overview
- At least one paragraph
- Include research methodology overview
- More in-depth than paper writing

#### 1.2 Motivations
- At least one paragraph
- From background of problem (Item 2)
- More in-depth than paper writing

#### 1.3 Problem Statement
- At least one paragraph
- From background of problem (Item 2)
- More in-depth than paper writing

#### 1.4 Research Objectives and Hypothesis
- At least one paragraph
- From objectives (Item 5)
- **Hypothesis:** Proposes a relationship between two or more types of variables (dependent and independent)
- Hypothesis testing is performed on samples to provide statistical evidence on the plausibility of the null hypothesis
- More in-depth than paper writing

**Understanding Hypothesis Testing:**
Recall knowledge from BACS2042 Research Methods and/or BMDS2113 Data Visualization. A good empirical research-based solution with scientific method should consist of:
- Recap problem statement(s) and research question(s) [Chapter 1]
- Recap research topic area and objective(s) [Chapter 1]
- Formulate Hypotheses [Chapter 1]
- Test with Experiments [Chapter 4]
- Analyze data from experiments [Chapter 5]
- Report findings from experiments [Chapter 5]
- Report knowledge contributions by identifying research implications to answer research questions [Chapter 5]

#### 1.5 Knowledge Contribution (Significance of Study)
- At least one paragraph
- From significance of study (Item 3)
- More in-depth than paper writing

#### 1.6 Thesis Organization
- Update before finalizing your draft
- Include research plan (Gantt chart) and research team
- More in-depth than paper writing

#### 1.7 Summary
- Brief recap of the chapter
- More in-depth than paper writing

---

## Chapter 2: Literature Review

### Overview
This chapter requires extensive review of previous work related to your research. You need to relate the background of problem/work to at least one SDG in each section 2.x with multiple sentences.

### Structure and Content

#### 2.1 Review of Problem Domain
Define and discuss the problem domain of your study.
- Extend the depth of your problem statement(s) from Chapter 1
- Include multiple subtopics (2.1.1, 2.1.2, etc.)

**Problem domain:** The area of your proposed research that needs to be examined to solve a problem.

#### 2.2 Review of Alternative Ways for Problem Domain
Available alternative ways to tackle the domain problem, including:
- Algorithms
- Methods
- Models
- Approaches
- Techniques
- Frameworks
- Research solutions from published literature

**Organization strategies:**
- Categorize by types
- Chronological order
- Geographical area
- Modules and functionalities

For each way (2.2.1, 2.2.2, etc.):
- Discuss involved concepts/theories/approach/model/method/algorithms (use **S** and **D**)
- Highlight their contributions in improved solutions (use **C** and **L**)

#### 2.3 Review of Adopted/Adapted Ways for Problem Domain
In-depth review on specific adopted/adapted ways similar to your proposed work. This section is a comprehensive review on your selected ways that will be implemented in your proposed research.

For each adopted/adapted way (2.3.1, 2.3.2, etc.):
- Discuss involved concepts/theories/approach/model/method/algorithms (use **S** and **D**)
- Highlight their contributions in improved solutions (use **C** and **L**)
- Extended discussion of existence of versions, variants, capacities, abilities
- Robustness of handling other domain problems
- Ensure the way is able to formulate your proposed work and align with your objectives

**Understanding Novelty Levels:**
- **High Novelty:** Adopting (using as-is) existing methods
- **Low Novelty:** Adapting (modifying) existing methods for your context

#### 2.4 Feasibility Study of Research Solution

##### 2.4.1 Technical Feasibility
Assessment of technical practicality of your proposed solution.

##### 2.4.2 Economical/Cost Feasibility
Comparison of existing solutions with cost analysis.

##### 2.4.3 Operational Feasibility
Assessment of how the solution works in practice.

##### 2.4.4 Market Feasibility
Analysis of potential market/user base.

##### 2.4.5 Social Feasibility
Impact on society and alignment with SDGs.

**Important:** Include related comparison of existing solutions and published articles. Discuss and highlight:
- Modules/models/methods/algorithms
- Functionalities
- Abilities of each solution (against your proposed solution - use S, D, C, and L)

#### 2.5 Summary
Brief recap of the chapter.

### How to Write Review (S-D-C-L Method)

**S: Summarize** the read article generally
- Provide an overview of what the article is about
- Include author, year, main topic

**D: Describe** the related details of the article
- Go deeper into specific methods, algorithms, or findings
- Explain the technical details relevant to your work

**C: Criticise and/or Compliment** the target components related to your research
- Identify strengths and weaknesses
- Discuss limitations or advantages
- Evaluate performance or applicability

**L: Link** them to your research
- Explain how this work relates to your proposed solution
- Justify why you're reviewing this particular work
- Connect it to your research objectives

---

## Chapter 3: Research Methodology

Outline the importance of methodology for serving your proposed solution. Paraphrase specific techniques/approaches/models/methods/algorithms that will be used, and explain how they will address the research questions.

**Always support Chapter 3 with:**
- UML diagrams (see https://www.visual-paradigm.com/tutorials/)
- Pseudocode (see https://en.wikipedia.org/wiki/Pseudocode)
- Algorithms (see https://en.wikipedia.org/wiki/Algorithm)
- Equations (see https://en.wikipedia.org/wiki/Equation)
- Other relevant materials

### Structure and Content

#### 3.1 Theoretical Framework
Explain the formation of the proposed solution and datasets with environment(s).

**Theoretical Framework:** Describes the existing/adopted/adapted theory, concepts, and definitions used to collect relevant data, analyze data, and produce meaningful empirical findings. It provides a foundation for understanding your research problem and developing required research hypotheses.

**Theoretical Framework vs Conceptual Framework:**
- **Theoretical Framework:** Utilizes established theories, concepts, and definitions to guide research and extend existing knowledge
- **Conceptual Framework:** Represents the researcher's own construction of concepts and their interrelationships within the study

#### 3.2 Proposed Solution

##### 3.2.1 Process and Flow
Paraphrase the detailed logical flow and process of the proposed solution and its sub-solutions (if any).

##### 3.2.2 Additional Subtopics
Add more subtopics through categorization of processes/components.

#### 3.3 Salient Feature 1 / Composite Features 1
Outline the expected proofs on special characteristics of the proposed solution contributing towards the claimed significance of study (Chapter 1).

##### 3.3.1 Performance Evaluation
Discuss how each/composite salient feature is formulated towards upgrading the overall performance.
- Highlight the use of performance/evaluation metrics
- Reference supportive details from published literature

##### 3.3.2 Model Comparison
Discuss how each/composite salient feature will be appraised towards obtaining better outcomes compared to original, variant, and published solutions.
- Highlight the use of performance/evaluation metrics
- Reference supportive details from published literature

##### 3.3.3 Robustness Achievement
Discuss which dataset(s) with each/composite salient feature is considered towards serving satisfactory robustness in your targeted area of study.
- Highlight the use of performance/evaluation metrics
- Reference supportive details from published literature

##### 3.3.4 Additional Subtopics
Add more subtopics emphasizing the greatness of the proposed model.

#### 3.4 Salient Feature 2 / Composite Features 2
Repeat the structure from 3.3 for additional features.

#### 3.x Additional Relevant Topics
Add any other relevant topics as needed.

#### 3.x Summary
Brief recap of the chapter.

---

## Chapter 4: Research Design

This chapter should be comprehensive in describing your experimental setup, datasets, and evaluation criteria.

### Structure and Content

#### 4.1 Benchmark Dataset 1

##### 4.1.1 Data Source and Collection
- Provide informative source of data downloaded/information obtained
- Data distribution
- Steps of data preparation
- Any specific techniques involved in getting the data

##### 4.1.2 Data Cleansing, Transformation and Specification
- Analytical methods with output results are expected
- Detailed explanation of preparation and related specifications
- Examples:
  - Resolving imbalanced classes for machine learning
  - Filtering outlier data points
  - Handling missing values
  - Feature engineering steps

##### 4.1.3 Descriptive Analysis of Data
- Analytical methods with output results are expected
- Overview of the raw data (from source)
- In-depth view on the processed data (for your proposed model)
- Statistical summaries (mean, median, standard deviation, etc.)
- Data visualizations (distributions, correlations, etc.)

##### 4.1.4 Experimental Setup
Discuss the expected experiments that will be conducted with the adopted data.

**Provide all relevant information:**
- Software (Python version, libraries and versions)
- Hardware (CPU, GPU specifications, RAM)
- Cloud resources and settings (if applicable)
- Configurations (hyperparameters, settings)
- Environment details (operating system, dependencies)
- Parameter settings

**Ensure experiments can be rerun/reproduced** to provide a similar set of outcomes.

**Potential categories of experimental comparisons:**
1. Base models (original/native approaches)
2. To-be-incorporated and its variants models (created by you or downloaded code)
3. Published models (from articles)

##### 4.1.5 Experimental Evaluation Criteria
List and discuss your experimental scenario with defined experiments.

**Include:**
- Hypothesis (from Chapter 1)
- Appropriate adoption of statistical tests on the performance metrics
- Previous research comparison (if any)
- How to analyze the findings
- Ways to visualize the findings from experiments

**Recall knowledge from BMDS2113 Data Visualization** but adopt your preferred programming language in FYP.

#### 4.2 Benchmark Dataset 2 (if any)
Repeat the structure from 4.1 for additional benchmark datasets.

#### 4.3 Real-World Dataset 1
Imitate the contents as benchmark data above. Real-world datasets often require more extensive preprocessing and explanation.

#### 4.4 Real-World Dataset 2 (if any)
Repeat the structure from 4.3 for additional real-world datasets.

#### 4.5 Summary
Brief recap of the chapter.

---

## Chapter 5: Results and Evaluation

This chapter reports your experimental results, statistical analysis, and findings.

### Structure and Content

#### 5.1 Experiment 1 (corresponding to Dataset 4.1)

##### 5.1.1 Result and Analysis
- Report numerical and digital literacy experiment results with detailed information
- Visualizations (tables, graphs, charts)
- Statistical tests supporting your hypothesis
- Raw results presentation

##### 5.1.2 Discussion and Findings
Discuss with respect to the evaluation criteria (section 4.1.5):
- Outcomes of statistical test(s) (answering hypothesis in Chapter 1)
- Performance metrics (at least 95% confidence interval)
- Comparison with previous research work (if any)
- Interpretation of results
- What the results mean in context

##### 5.1.3 Research Implications
- Relate findings to research question
- Connect to objective(s)
- How findings bring impacts to the domain of study
- Cite previous research for context

##### 5.1.4 Additional Topics
Add relevant topics from BMDS2113 Data Visualization and BACS2043 Research Methods, adopting quantitative research methods.

#### 5.2 - 5.4 Experiments 2-4
Repeat the structure from 5.1 for each experiment corresponding to datasets in Chapter 4.

#### 5.x Summary
Summarize the major findings and implications across all experiments.

---

## Chapter 6: Future Work

### Structure and Content

#### 6.1 Limitations of Study
Address limitations of your research:
- Formulation of research aim and objectives
- Application of data collection method
- Sample size constraints
- Scope of discussions and analysis
- Any other limitations

Propose future research suggestions that address these limitations.

#### 6.2 Limitations of Methodology
Build upon findings of your research:
- Findings you did not anticipate
- Methodological constraints
- Suggest future research to address unanswered aspects

#### 6.3 Recommendations of Study
Constructing the same research in a new context:
- Different data sources
- Different domains
- Different locations
- Different cultures
- Different settings

#### 6.4 Recommendations on Methodology
Re-assessing and expanding theory, framework, or model:
- Effects of specific events
- Emergence of new theories or evidence
- Other recent phenomena affecting your research problem

#### 6.5 Summary
Brief recap of the chapter.

---

## Chapter 7: Conclusion

### Structure and Content

Give a glance of view in findings. Remember to emphasize:
- How your work has answered the SDG(s) as claimed in Chapters 1 and 2
- Analysis of research outcomes
- Recap achievements and contributions
- Final thoughts on the research journey

---

## References Section

**Requirements:**
- APA format (strictly follow TAR UMT guidelines)
- DO NOT include orphan references without citing-in-text
- Check the list of references before report submission
- Recent sources (~3 years)
- Reputable references (preferably journal/conference papers, books)
- Include DOIs where available

**APA Reference Guide:**
https://www.tarc.edu.my/files/library/52FBEA86-8783-4DC9-889A-A5FE31EC9B8D.pdf

**BibTeX to APA Converter:**
https://bibtex.online/

---

## Appendix

**Structure:**
- A1.x Samples of raw and processed datasets
- B1.x Detailed experimental results with results of statistical tests
- C1.x Extensive outputs of your programs
- D1.x Details information on remote source code repository (e.g., GitHub)
- E1.x Various guides for Setup Experiments and End-User on reproducing the work
- F1.x Additional materials as needed

**Important:** DO NOT include orphan appendices without citing-in-text. Label all appendices properly before citing them in your report.

---

## FYP Preview (End of Project I)

**Presentation to project supervisor covering:**

1. Topic of interest (Item 1) and Overview of Project solution (from Project I report)
2. Background of the problem / Research question (from Project I report)
3. Significance of the study (from Project I report)
4. Research objectives (from Project I report)
5. The in-progress of both input data processing and experimental results (tabular and/or with chart):
   - a) Data Cleansing, Transformation, Specification with descriptive analysis
   - b) Comparison results of proposed work vs. base work(s)
   - c) Comparison results of proposed work vs. to-be-incorporate work(s)

---

## Full System Preview / Viva (Project II)

**Presentation to Examiner and Moderator covering:**

1. Topic of interest and Overview (finalized version)
2. Background of the problem / Research question (finalized version)
3. Significance of the study (finalized version)
4. Research objectives (finalized version)
5. Completion of input data processing and experimental results (tabular and/or with chart)
6. Completion of results and evaluation (tabular and/or with chart and brief explanations)
7. Completion of future work (brief explanations)

---

## Frequently Asked Questions (FAQs)

### FAQ 1: How many benchmark datasets should I use?

**Answer:** One dataset is sufficient for your research-based FYP. However, you might need more than one dataset (including real-world datasets) if you aim for publication, focusing solely on your model evaluation.

For high-impact journals, multiple datasets demonstrate robustness. Example: A 2023 article (https://doi.org/10.1016/j.asoc.2023.110431) used 10 datasets.

### FAQ 2: Must I create graphs/charts for my research?

**Answer:** YES. Graphing/charting and tabularizing numbers in a structured way demonstrates your numerical and digital literacy skills. This is essential for research-based FYPs.

To enhance publication potential:
1. Incorporate model development
2. Compare models to enhance novelty

### FAQ 3: Can I remove columns from downloaded datasets?

**Answer:** Consider from two perspectives:

**For model development and comparison:**
- Keep ALL columns to ensure fair comparison (apple-to-apple) with previous published work
- This is especially important when claiming your model is more favorable than others

**For flexibility:**
- You can adapt and think creatively for Malaysian/Asian context
- But maintain all original columns for fair baseline comparisons

### FAQ 4: How to improve a model?

**Higher Degree of Novelty (Fundamental Improvements):**
1. Adapting a theoretical framework
2. Modifying mathematical equations of the model
3. Proposing a novel multi-modal, multi-agent, or hybrid model architecture

These improvements need justification from literature reviews on your creativity towards the body of knowledge.

**Lower Degree of Novelty (Higher-Level Improvements):**
1. Modifying numeric/string values or options of passing parameters
2. Changing sequences of model processing on training and testing
3. Applying different types of data pre-processing and post-processing

**Both approaches need:**
- Substantial assessment of practicality (experimental results)
- Merits (performance metrics)
- Viability (evaluation proofs of model robustness on datasets)
- Present details in Chapters 3, 4, and 5

### FAQ 5: How to improve pre-trained models with limited computational resources?

**Methods for improving Pre-trained Language Models (PLMs):**

**a. Modification of Pre-training Tasks**
- Adapt and enhance pre-training objectives
- Can markedly improve PLM performance

**b. Increase of Input Size**
- Extend context window without quadratic parameter growth
- Be careful about using too much AI-generated data (can worsen performance)
- Reference: Nature article https://doi.org/10.1038/d41586-024-02355-z

**c. Multilingual Training**
- Simultaneously train the same model in different languages
- Generate joint meaning representation
- Especially beneficial for languages with little training data

**d. Adding Extra Knowledge**
- Include additional information not covered by training data
- Incorporate facts and rules from knowledge bases (KB)
- Include additional text collections
- Keeps content up-to-date

**e. Changing Model Size**
- Theoretical results show performance improves with larger PLMs (Foundation Models)
- Mixture-of-experts approach
- Or reduce computation effort and memory footprint without sacrificing performance

**f. Further Fine-tuning for Specific Applications**
- Benchmarking and/or real-world problem applications
- Different strategies: several fine-tuning steps or multiple tasks
- Larger PLMs can be instructed by prompts (Foundation Models)
- Few-shot prompts optimization for adequate model reaction

Reference: https://doi.org/10.1007/978-3-031-23190-2_3

### FAQ 6: How to calculate Confidence Interval?

**Definition:** An interval generated on the basis that a specified proportion of confidence intervals include the true parameter in repeated sampling.

**Example:** 30 runs of your experiment with the same configurations but using different seeds.

**Confidence Level:** 95% means that in repeated sampling, 95% of the confidence intervals include the parameter.

**Calculation for Population Mean:**

**Case 1: When population standard deviation (σ) is known**
```
CI = x̄ ± Z(α/2) × (σ/√n)

Where:
- x̄ = sample mean
- Z(α/2) = Z-value for desired confidence level (1.96 for 95%)
- σ = population standard deviation
- n = sample size
```

**Case 2: When population standard deviation is unknown (use sample standard deviation)**
```
CI = x̄ ± t(α/2, n-1) × (s/√n)

Where:
- x̄ = sample mean
- t(α/2, n-1) = t-value with n-1 degrees of freedom
- s = sample standard deviation
- n = sample size
```

### FAQ 7: Theoretical Breadth vs Theoretical Depth

**Theoretical Breadth:** The range & diversity of perspectives applied to explain phenomena.

**Theoretical Depth:** The thoroughness with which a single theoretical framework is examined, extended, & empirically tested.

**Four Categories of Theoretical Contributions:**

**a. Validation**
- Research validating existing theories without extensive theoretical development

**b. Augmentation**
- Extends existing theories by introducing new constructs or relationships
- Enhances the original framework

**c. Expansion**
- Broadens the scope of existing theories to new contexts or domains
- Demonstrates applicability beyond original settings

**d. Synthesis**
- Integrates multiple theoretical perspectives
- Develops a comprehensive framework
- Offers broad understanding of complex phenomena

**Todo Tasks:**
1. **Clarity matters:** Let reviewers/examiners know the type of theoretical contribution your research offers
2. **Alignment matters:** Ensure theoretical contribution aligns with research objectives and questions
3. **Depth & Rigor:** Provide evidence of rigorous test/examination of the theory
4. **Relevance:** Extract practical implications from your theoretical contributions

### FAQ 8: Principles for Publishing in Top Journals

**a. A Clear Theoretical Contribution**
- Clearly define theoretical framework, constructs, and how study extends prior work
- Ensure study fits into identifiable theoretical paradigm

**b. Balance Theoretical and Empirical Strengths**
- Strong empirical research needs theoretical positioning
- Papers with minimal theoretical contributions must justify practical/empirical impact

**c. Anticipate Common Reviewer Critiques**
- Think through counterarguments
- Address potential weaknesses
- Avoid "laundry lists" of variables without unifying theoretical lens

**d. Position for Journal's Audience**
- Ensure theoretical contribution is relevant to literature in the journal
- Select theory and extend insights found in that journal

**e. Explicitly State Your Theoretical Contributions**
- Articulate contribution type clearly:
  - Introducing new variable
  - Introducing new theory
  - Refining existing theory
  - Offering methodological advancements

**f. Use Theory to Enhance Generalizability**
- Theory helps make empirical insights transferable across contexts
- Make this explicit for readers

**g. Respond Thoughtfully to Reviewer Feedback**
- If asked to strengthen theoretical contributions, refine theoretical position
- Adding citations rarely helps
- Adding theory with supporting citations persuades reviewers

### FAQ 9: What is Literature Review?

**Definition:** An activity of reviewing previous work, including:
- Published works (IEEE, Elsevier/ScienceDirect, Springer) - **Recommended**
- Commercial and open-source products (off-the-shelf software, API libraries)
- Unpublished work - **NOT recommended for FYP adoption** (personal websites, blogs)

### FAQ 10: SDG Alignment

**Sustainable Development Goals (SDGs):** Available at https://sdgs.un.org/goals

Your research MUST relate to at least one SDG. Discuss this alignment in:
- Chapter 1 (Introduction)
- Chapter 2 (Literature Review)
- Chapter 7 (Conclusion)

---

## Important Reminders

**Academic Integrity:**
- All work must be original and NOT previously submitted
- Modified work from other students is strictly NOT acceptable
- All information from other sources must be duly acknowledged
- Internet sources need citation just like any other publications
- Refer to University's Plagiarism Policy for details

**Quality Standards:**
- Invest time in quality work
- Maintain academic integrity
- Communicate regularly with supervisor (≥2 times/month)
- Meet all deadlines
- Prepare comprehensive documentation

**Statistical Rigor:**
- Use appropriate statistical tests
- Report confidence intervals (at least 95%)
- Conduct hypothesis testing properly
- Validate results across multiple datasets when possible

**Research Ethics:**
- Get supervisor approval for data collection
- Follow Faculty Ethics Committee guidelines
- Keep collected data confidential and secure
- Follow TAR UC's Ethical Guidelines for Research

---

## Quick Reference Checklist

**Before Starting:**
- [ ] Answered the 5 essential items
- [ ] Aligned with at least one SDG
- [ ] Identified benchmark and real-world datasets
- [ ] Confirmed research is not redundant

**During Project I:**
- [ ] Project proposal approved by supervisor AND moderator
- [ ] Chapter 1 complete with hypothesis
- [ ] Chapter 2 complete with thorough literature review using S-D-C-L method
- [ ] Chapter 3 complete with theoretical framework and methodology
- [ ] Chapter 4 complete with research design and experimental setup
- [ ] Met with supervisor regularly (≥2 times/month)
- [ ] FYP Preview prepared and presented

**During Project II:**
- [ ] Chapter 5 complete with results, analysis, and implications
- [ ] Chapter 6 complete with limitations and future work
- [ ] Chapter 7 complete with conclusion and SDG alignment
- [ ] All experiments completed with statistical tests
- [ ] Confidence intervals calculated (95%)
- [ ] All figures/tables numbered and referenced
- [ ] All appendices labeled and cited in text
- [ ] References in APA format with DOIs
- [ ] Turnitin report obtained
- [ ] Final viva presentation prepared

---

**End of Research Writing Guide**

For process and administrative questions, refer to the main FYP guide in SKILL.md.
For APA citations and plagiarism prevention, use the tar-umt-academic-writing skill.
