# Course Plan: {{title}}

**Source:** {{sourceDirectory}}
**Total:** {{totalLessons}} lessons, ~{{totalWordCount}} words
**Generated:** {{date}}

## Overview

{{description}}

## Proposed Structure

{{#each units}}
### {{order}}. {{title}}

{{description}}

{{#each lessons}}
- **{{title}}**{{#if audienceLayer}} [{{audienceLayer}}]{{/if}}
  {{#if description}}{{description}}{{/if}}
  - Source: `{{sourceFile}}`
{{/each}}

{{/each}}

## Suggested Competencies

{{#each suggestedCompetencies}}
- {{this}}
{{/each}}

## Build Commands

```bash
# 1. Create the course
deno run --allow-net --allow-env scripts/create-course.ts \
  --title "{{title}}" \
  --description "{{description}}"

# 2. Note the course ID from the output, then create units:
{{#each units}}
deno run --allow-net --allow-env scripts/add-unit.ts \
  --course-id <COURSE_ID> \
  --title "{{title}}" \
  --order {{order}}

# 3. Add lessons to unit {{order}} (note unit ID from output):
{{#each lessons}}
deno run --allow-net --allow-env --allow-read scripts/add-lesson.ts \
  --unit-id <UNIT_{{../order}}_ID> \
  --title "{{title}}" \
  --content-file "{{sourceFile}}"{{#if audienceLayer}} \
  --audience-layer {{audienceLayer}}{{/if}} \
  --order {{order}}

{{/each}}
{{/each}}
```

## Review Checklist

- [ ] Course title and description are accurate
- [ ] Unit groupings make pedagogical sense
- [ ] Lesson ordering follows learning progression
- [ ] Audience layers are correctly assigned
- [ ] All source files are accounted for
- [ ] Competencies cover key learning objectives
- [ ] No content gaps require research

## Next Steps

1. Review and approve this plan
2. Run the build commands above
3. Open http://localhost:4101/courses/<COURSE_ID>
4. Verify structure in the Content tab
5. Add competencies in the Competencies tab
6. Refine lesson content as needed

---

*Generated by teach-course-builder skill. Review and modify as needed.*
