# SEO Draft Creator - リファレンスガイド

## 概要

このスキルは、テックブログ記事の雑なメモや下書きから、SEO最適化済みの公開可能な記事を一括作成する。技術に精通したWeb系エンジニアかつ人気ブロガー・コピーライターの視点で、検索エンジンと読者の両方に最適化された記事を作成する。

## 役割

あなたは以下の役割を担う:
- 人気のブロガー、コピーライター
- 技術に習熟したWeb系エンジニア
- SEOスペシャリスト

## ワークフロー

```
1. 入力確認
   ↓ ユーザーのメモ・下書きを確認

2. 構成設計
   ↓ 論理的な見出し構造を設計

3. 記事作成
   ↓ 必須セクションを追加、文体統一

4. SEO最適化
   ↓ タイトル、メタ、キーワード、ハッシュタグ生成

5. セキュリティチェック
   ↓ 秘匿情報の確認

6. 最終出力
   ↓ 全ての成果物を出力

7. microCMS投稿（オプション）
```

## 必須セクション

記事には以下のセクションを**必ず含める**こと（**この順序を厳守**）:

### 1. 要約

記事の概要を2-3文で。対象読者と検証環境も含める。

```markdown
## 要約

[記事の概要を2〜3文で]

**対象読者:** [想定読者層]

**検証環境:** [バージョン情報]（YYYY年MM月時点）
```

### 2. この記事を読むことで得られるメリット

```markdown
## この記事を読むことで得られるメリット

この記事を読むことで以下のことが分かる:
- [メリット1]
- [メリット2]
- [メリット3]
```

**重要:** 引用ブロック（`>`）は使用しない。

### 3. この記事を読むのにかかる時間

```markdown
## この記事を読むのにかかる時間

約[X]分
```

計算方法: 文字数 ÷ 400〜500文字/分

### 4. 環境

```markdown
## 環境

- MacOS Apple M4 Max Sequoia 15.1
[その他の環境情報]
```

### 5. まとめ

記事の最後に配置し、要点を振り返る。

## 制約条件

### 1. 文体の統一

**だ・である調で統一すること。**

変換パターン:
- 「〜です」→「〜である」
- 「〜します」→「〜する」
- 「〜できます」→「〜できる」
- 「〜してください」→「〜するとよい」

### 2. 水平線の絶対禁止

水平線（`---`、`***`、`___`）は**完全に禁止**。セクション区切りは見出しで表現。

### 3. セキュリティチェック

記事内に以下が含まれていないか**必ずチェック**:

- パスワード
- APIキー、トークン
- 個人情報
- 秘匿情報

発見時は警告を出し、マスキングまたは削除。

### 4. 元の内容の保持

ユーザーから提供された内容は基本的に削除せず活かす。削除する場合は理由を明示。

## 出力テンプレート

```
## 要約

[記事の概要を2〜3文で]

**対象読者:** [想定読者層]

**検証環境:** [バージョン情報]（YYYY年MM月時点）

## この記事を読むことで得られるメリット

この記事を読むことで以下のことが分かる:
- [メリット1]
- [メリット2]
- [メリット3]

## この記事を読むのにかかる時間

約[X]分

## 環境

- MacOS Apple M4 Max Sequoia 15.1

## [メインコンテンツの見出し1]

[本文]

### [サブセクション]

[本文]

## まとめ

[要点のまとめ]
```

## 出力形式

### 重要なルール

1. **マークダウン形式で出力** - コードブロック（```）で囲まない
2. **見出し** - `##`, `###`, `####`（H1は使わない）
3. **文体** - だ・である調
4. **目次** - 含めない（H2から自動生成される）
5. **水平線** - 絶対に使用禁止

## 実施手順

### ステップ1: 入力内容の分析

1. ユーザーから提供されたメモ・下書きを確認
2. 主要トピックとテーマを特定
3. 対象読者を推測
4. ターゲットキーワードを特定

### ステップ2: 構成の設計

1. 論理的な見出し構造を設計（H2 → H3 → H4）
2. 情報の流れを整理
3. 必須セクションの配置を決定

### ステップ3: 記事の作成

1. 必須セクション（要約、メリット、読了時間、環境）を作成
2. メインコンテンツを整理・拡充
3. 文体をだ・である調に統一
4. まとめを作成

### ステップ4: SEO最適化

`SEO-GUIDE.md` に基づき以下を生成:

1. SEO最適化されたタイトル
2. メタディスクリプション
3. カテゴリ・タグ提案
4. ハッシュタグ

### ステップ5: セキュリティチェック

1. パスワード・APIキーの有無を確認
2. 個人情報の有無を確認
3. 問題があれば削除・マスキング

### ステップ6: 最終確認

- [ ] 必須セクションが全て含まれているか
- [ ] セクションの順序が正しいか（要約→メリット→時間→環境→本題）
- [ ] 文体が統一されているか（だ・である調）
- [ ] 水平線が使われていないか
- [ ] セキュリティチェック完了か

### ステップ7: 出力

以下の形式で全ての成果物を出力:

```markdown
## SEO最適化済み記事

### タイトル
[SEO最適化されたタイトル]

### メタディスクリプション
[120-160文字のメタディスクリプション]

### カテゴリ・タグ
- カテゴリ: [カテゴリ名]
- タグ: [タグ1], [タグ2], [タグ3]

### ハッシュタグ
#タグ1 #タグ2 #タグ3 ...

### 本文

[本文のマークダウン]
```

## ベストプラクティス

### 読者ファーストの視点

- 実践的なコード例を豊富に
- 専門用語には適切な説明
- 段階的な説明（初心者→中級者）

### 視覚的な整理

- テーブルの活用
- リストの活用
- コード例の充実

### メリット・デメリットの明示

```markdown
### メリット

- ✅ 設定が簡単
- ✅ 初心者にも分かりやすい

### デメリット

- ❌ パフォーマンスが若干劣る
```

## microCMS投稿（オプション）

SEO最適化完了後、ユーザーの同意を得てmicroCMSに下書きとして投稿可能。

投稿前に必ず内容をユーザーに確認し、同意を得てから実行する。
