# SEO最適化ガイド

## 概要

このガイドでは、テックブログ記事のSEO最適化に必要な要素を解説する。タイトル、メタディスクリプション、キーワード配置、ハッシュタグ生成について記載。

## 1. タイトル最適化

### 基本ルール

- **文字数**: 30-35文字以内（検索結果で切れない長さ）
- **キーワード**: ターゲットキーワードを前半に配置
- **具体性**: 数字や具体的なベネフィットを含める

### 効果的なタイトルパターン

```
【2025年版】[キーワード]｜[具体的なベネフィット]
[キーワード]完全ガイド｜[数字]つの[方法/例]
[課題]を解決する[数字]つの方法｜[対象読者]向け
```

### 例

```
Before: Reactのhooksについて
After: React Hooks完全ガイド｜useState/useEffectの使い方7選

Before: Pythonで文字化けを直す
After: 【2025年版】Python文字化け対処法｜5つの確実な解決策
```

### チェックポイント

- [ ] 30-35文字以内か
- [ ] ターゲットキーワードが前半にあるか
- [ ] 数字や具体性があるか
- [ ] クリックしたくなる内容か

## 2. メタディスクリプション

### 基本ルール

- **文字数**: 120-160文字
- **キーワード**: ターゲットキーワードを自然に含める
- **CTA**: 行動を促す表現を含める

### テンプレート

```
[記事の概要を1文で]。[具体的な内容]を[対象読者]向けに解説。[ベネフィット]が分かる。
```

### 例

```
React Hooksの基礎から実践まで徹底解説。useState、useEffect、カスタムフックの使い方を実例7つで学べる。初心者から中級者まで必見のガイド。
```

### チェックポイント

- [ ] 120-160文字か
- [ ] キーワードが含まれているか
- [ ] 記事の価値が伝わるか
- [ ] 読みたくなる内容か

## 3. 本文のキーワード最適化

### キーワード密度

- **目標**: 1-3%（自然な範囲）
- **配置箇所**:
  - 冒頭（最初の100文字以内）
  - 見出し（H2、H3）
  - 本文中（自然に分散）
  - まとめ

### 見出しへのキーワード含有

```markdown
## React Hooksとは？【基礎知識】

### useStateの使い方

#### 実装例：カウンター機能
```

### 共起語の活用

メインキーワードに関連する用語も含める:

- React Hooks → useState, useEffect, 関数コンポーネント, 状態管理
- Python 文字化け → エンコーディング, UTF-8, CP932, 標準出力

## 4. カテゴリ・タグ提案

### カテゴリ選定

記事の主題に基づき、以下から適切なカテゴリを選定:

- ソフトウェア開発
- フロントエンド
- バックエンド
- インフラ
- AI/機械学習
- ツール・環境構築
- プログラミング言語（Python、JavaScript等）

### タグ選定

- メインキーワード
- 使用技術・ライブラリ
- 対象レベル（初心者向け、中級者向け等）
- 関連トピック

### 例

```
カテゴリ: フロントエンド, React
タグ: React Hooks, useState, useEffect, 関数コンポーネント, JavaScript, 初心者向け
```

## 5. ハッシュタグ生成

### 基本ルール

- **数**: 10-15個
- **構成**:
  - メインキーワード関連: 3-5個
  - 技術スタック関連: 3-5個
  - 一般的なタグ: 2-3個
  - トレンドタグ: 1-2個

### テンプレート

```
#[メインキーワード] #[技術名] #[フレームワーク] #[言語] #プログラミング #エンジニア #開発 #[トレンド]
```

### 例（React Hooks記事）

```
#ReactHooks #React #useState #useEffect #JavaScript #フロントエンド #Web開発 #プログラミング #エンジニア #初心者向け #技術ブログ #React18
```

### 例（Python文字化け記事）

```
#Python #文字化け #エンコーディング #UTF8 #プログラミング #Python初心者 #開発Tips #トラブルシューティング #エンジニア #技術ブログ
```

## 6. 構造化データ（オプション）

### Article スキーマ

```json
{
  "@context": "https://schema.org",
  "@type": "TechArticle",
  "headline": "[タイトル]",
  "description": "[メタディスクリプション]",
  "author": {
    "@type": "Person",
    "name": "[著者名]"
  },
  "datePublished": "[公開日]",
  "dateModified": "[更新日]"
}
```

## SEO最適化チェックリスト

### 必須項目

- [ ] タイトルが30-35文字以内
- [ ] タイトルにキーワードが含まれている
- [ ] メタディスクリプションが120-160文字
- [ ] 見出しにキーワードが含まれている
- [ ] 本文の冒頭にキーワードがある

### 推奨項目

- [ ] 数字や具体性がタイトルに含まれている
- [ ] 共起語が本文に含まれている
- [ ] 適切なカテゴリ・タグが設定されている
- [ ] ハッシュタグが10-15個生成されている
