---
name: tech-blog-seo-draft-creator
description: テックブログ記事の下書きをSEO最適化込みで一括作成するスキル。雑なメモから体裁を整え、タイトル・メタディスクリプション・ハッシュタグまで生成。「SEO込みで記事にして」「SEO最適化された下書きを作成して」「公開できる形にして」などのリクエストで利用。
---

# Tech Blog SEO Draft Creator

雑なメモや下書きから、SEO最適化済みのテックブログ記事を一括作成するスキル。

## 使用するタイミング

- 「このメモをSEO最適化された記事にして」
- 「下書きをSEO込みで完成させて」
- 「公開できる形の記事にまとめて」
- 「SEO対策済みのブログ記事を作成して」

## クイックスタート

1. ユーザーの下書き・メモを確認
2. `REFERENCE.md` の手順に従って記事構造を整える
3. `SEO-GUIDE.md` に基づきタイトル・メタ情報を最適化
4. `references/security-check.md` でセキュリティチェック
5. 完成した記事を出力

## ファイル構成

- **REFERENCE.md** - 記事作成の詳細手順、必須セクション、文体ルール
- **SEO-GUIDE.md** - SEO最適化ガイド（タイトル、メタ、キーワード、ハッシュタグ）
- **references/** - 個別のガイドライン
  - `security-check.md` - セキュリティチェックガイド

## 出力内容

このスキルは以下を一括で生成する:

1. **SEO最適化されたタイトル** (30-35文字)
2. **メタディスクリプション** (120-160文字)
3. **カテゴリ・タグ提案**
4. **ハッシュタグ** (10-15個)
5. **本文** (必須セクション込み、だ・である調)
