# セキュリティチェックガイド

## 概要

テックブログ記事を公開する前に、セキュリティ上のリスクがある情報が含まれていないか、必ずチェックする必要がある。

## チェック対象の秘匿情報

### 1. パスワード

- プレーンテキストのパスワード
- デフォルトパスワード
- 推測可能なパスワード例

**対処法:** `[REDACTED]`、`your_password_here`に置き換えるか、環境変数から取得する形に変更

### 2. APIキー・トークン

- AWSアクセスキー（AKIA...）
- OpenAI APIキー（sk-...）
- GitHub Personal Access Token
- その他のサービスAPIキー

**対処法:** `[YOUR_API_KEY]`に置き換えるか、環境変数から取得する形に変更

### 3. 個人情報

- 実名（本名）
- メールアドレス
- 電話番号
- 住所

**対処法:** `user@example.com`などのダミーに置き換え

### 4. 秘匿情報・内部情報

- 内部URL・IPアドレス
- 非公開リポジトリ名
- データベース接続文字列
- サーバーの内部構成

**対処法:** 一般的な名前やダミーに置き換え

### 5. 環境変数の実際の値

- `.env`ファイルの実際の内容
- 環境変数の実際の値

**対処法:** ダミー値に置き換え、`.env.example`として示す

## 発見時の対処フロー

### ステップ1: ユーザーへの警告

```markdown
⚠️ **セキュリティ警告**

以下の秘匿情報が記事内で検出されました:

1. 行X: APIキーと思われる文字列
2. 行Y: メールアドレス

これらの情報はマスキングまたは削除しました。
```

### ステップ2: マスキング

- パスワード → `your_password_here`
- APIキー → `process.env.API_KEY`
- メールアドレス → `user@example.com`
- IPアドレス → `your_server_ip`

### ステップ3: 削除箇所の明示

修正した箇所を明確にユーザーに伝える。

## チェックリスト

### 認証情報

- [ ] パスワードが含まれていないか
- [ ] APIキー・トークンが含まれていないか
- [ ] 秘密鍵が含まれていないか

### 個人情報

- [ ] 実名が含まれていないか
- [ ] メールアドレス（ダミー以外）が含まれていないか
- [ ] 電話番号が含まれていないか

### 内部情報

- [ ] 内部URL・IPアドレスが含まれていないか
- [ ] 非公開リポジトリ名が含まれていないか

### 環境変数

- [ ] `.env`ファイルの実際の内容が含まれていないか
- [ ] 環境変数の実際の値が含まれていないか
