# SEO Rewriter - 情報収集フォーム

このファイルは、リライト作業時にユーザーから必要な情報を収集するためのフォーマットを定義します。

## フォーム1: リライト対象記事の基本情報

リライト作業を開始する前に、以下の情報をユーザーに確認します。

### 必須情報

#### 1. 記事の特定
- **記事タイトル**:
- **記事パス**: （例: `drafts/python-encoding.md` または記事URL）
- **記事内容**: （ファイルパスがある場合は自動読み込み、ない場合はユーザーから全文を取得）

#### 2. Google Search Console データ

以下の情報をGSCから取得してください：

- **掲載順位**: 〇位（平均掲載順位）
- **表示回数**: 〇回/月（過去3ヶ月または1ヶ月の平均）
- **CTR (クリック率)**: 〇%
- **クリック数**: 〇回/月

#### 3. 主要クエリ（トップ3-5個）

この記事で流入している主要な検索キーワードを教えてください：

1. キーワード1（表示回数: 〇回、順位: 〇位、CTR: 〇%）
2. キーワード2（表示回数: 〇回、順位: 〇位、CTR: 〇%）
3. キーワード3（表示回数: 〇回、順位: 〇位、CTR: 〇%）
4. キーワード4（表示回数: 〇回、順位: 〇位、CTR: 〇%）
5. キーワード5（表示回数: 〇回、順位: 〇位、CTR: 〇%）

### 任意情報

#### 4. リライトの目的・方針
- [ ] タイトル・メタディスクリプションの改善（CTR向上）
- [ ] コンテンツ拡充（FAQセクション、実践例の追加）
- [ ] 技術情報の更新（最新バージョン、ベストプラクティス）
- [ ] 見出し構造の改善
- [ ] 内部リンクの追加
- [ ] 構造化データの追加
- [ ] その他:

#### 5. 出力プラットフォーム
- [ ] note（表は使用不可、箇条書きで代替）
- [ ] はてなブログ（表使用可）
- [ ] WordPress（表・HTMLタグ使用可）
- [ ] その他:

#### 6. 競合記事の情報（任意）
- 競合記事URL:
- 競合記事の強み:
- 差別化ポイント:

---

## フォーム2: GSCデータの提供方法

ユーザーがGSCデータを提供する方法は以下のいずれか：

### 方法1: テキストで直接提供

```
記事URL: https://example.com/article
掲載順位: 15位
表示回数: 250回/月
CTR: 3.2%
クリック数: 8回/月

主要クエリ:
1. Python 文字化け（表示: 120回、順位: 12位、CTR: 4.2%）
2. Python print 日本語（表示: 80回、順位: 18位、CTR: 2.5%）
3. Python エンコーディング エラー（表示: 50回、順位: 20位、CTR: 2.0%）
```

### 方法2: スクリーンショット

GSCの画面キャプチャを添付していただければ、Claude Codeが画像を読み取って情報を抽出します。

**推奨スクリーンショット:**
1. 「検索パフォーマンス」→「ページ」タブで該当記事の行を表示
2. 該当記事をクリックして「クエリ」タブを表示（主要クエリ一覧）

### 方法3: CSVエクスポート

GSCから「検索パフォーマンス」データをCSV形式でエクスポートしていただければ、ファイルを読み込んで分析します。

**エクスポート手順:**
1. GSCで「検索パフォーマンス」を開く
2. 右上の「エクスポート」ボタンをクリック
3. 「Googleスプレッドシートにエクスポート」または「CSVをダウンロード」を選択
4. ファイルをClaude Codeに共有

---

## フォーム3: リライト完了後の更新

リライト作業完了後、以下の情報を `tech-blog/rewrite-tasks.md` に記録します：

- **ステータス**: `[x]` に更新
- **リライト完了日**: YYYY-MM-DD
- **実施内容**: タイトル改善、FAQ追加、コード例追加 など
- **備考**: 次回測定予定日（1ヶ月後）、期待される改善効果 など

---

## 対話フローの例

### ステップ1: 記事の特定
```
Claude: リライト対象の記事を教えてください。記事のファイルパスまたはタイトルをお願いします。
User: drafts/python-encoding.md
Claude: [ファイルを読み込み] 記事「Pythonの文字化け対処法」を確認しました。
```

### ステップ2: GSCデータの取得
```
Claude: この記事のGoogle Search Consoleデータを教えてください。以下の情報が必要です：
- 掲載順位
- 表示回数
- CTR
- クリック数
- 主要クエリ（トップ3-5個）

テキスト、スクリーンショット、CSVファイルのいずれかで提供してください。

User: [GSCデータを提供]
```

### ステップ3: リライト方針の確認
```
Claude: GSCデータを分析しました。

【現状分析】
- 掲載順位: 15位（11-30位の「惜しい記事」）
- 表示回数: 250回/月（多い）
- CTR: 3.2%（順位15位の平均は約2-5%なので平均的）
- クリック数: 8回/月

【優先度】
🔥🔥🔥 最優先（少しの改善で1ページ目に上がる可能性）

【推奨リライト内容】
1. タイトル最適化（数字・具体性を追加してCTR向上）
2. メタディスクリプション改善
3. 見出し構造の改善（H2-H3の階層を整理）
4. FAQセクション追加（よくある質問に先回りして答える）
5. 実践例・コード例の追加

上記の方針でリライトを実施してよろしいでしょうか？
または、他に優先したい項目はありますか？

User: お願いします
```

### ステップ4: リライト実施
```
Claude: リライトを実施します。
[リライト作業]
```

### ステップ5: 完了報告とタスク更新
```
Claude: リライトが完了しました。

【出力ファイル】
- tech-blog/output/python-encoding-optimized.md

【実施内容】
- タイトル最適化: 「Pythonの文字化け対処法」→「【2025年版】Python文字化け対処法｜Windows/Mac環境別の5つの解決策」
- メタディスクリプション作成: 120文字
- FAQセクション追加: 5つの質問
- コード例追加: 3つの実装パターン
- 見出し構造改善: H2-H3の論理的階層に整理

【期待される効果】
- 掲載順位: 15位 → 5-10位の改善見込み
- クリック数: 8回/月 → 15-20回/月の増加見込み

tech-blog/rewrite-tasks.md を更新しました。1ヶ月後に効果を測定してください。
```

---

## 補足: 複数記事の一括リライト

複数の記事を一度にリライトする場合は、`tech-blog/rewrite-tasks.md` に記事一覧を記入してから、優先度順に1つずつリライトを実施します。

### 推奨フロー
1. GSCで「惜しい記事」（掲載順位11-30位）を特定
2. `tech-blog/rewrite-tasks.md` に記事一覧を追記
3. 優先度が最も高い記事から順にリライト
4. 各記事のリライト完了後、ステータスを更新
5. 1ヶ月後に効果測定、必要に応じて再リライト
