# SEO Rewriter - リファレンスガイド

## 概要

このスキルは、テックブログ記事をSEOに強いコンテンツへリライトします。検索エンジンでの上位表示を目指し、タイトル最適化、メタタグ生成、本文の構造改善、コンテンツ拡充、技術情報の更新などを包括的に実施します。

## 基本的なリライトフロー

1. **記事分析**: 現在の記事内容、ターゲットキーワード、競合記事を分析
2. **SEO監査**: タイトル、見出し構造、キーワード配置、メタ情報を評価
3. **リライト実施**: 各要素を最適化してリライト
4. **最終チェック**: SEOチェックリストに基づいて品質確認

### 簡単な例

ユーザーから「このReactの記事をSEO最適化して」とリクエストされた場合:

1. 記事のURLまたはテキストを取得
2. ターゲットキーワードを特定（例: "React hooks 使い方"）
3. `references/seo-checklist.md`に基づいて各要素を最適化
4. リライト結果と改善提案を出力

## リライト対象記事の管理

### 管理ファイル: tech-blog/rewrite-tasks.md

リライト対象記事は `tech-blog/rewrite-tasks.md` で一元管理します。このファイルには以下の情報が記録されます：

- **ステータス**: 未着手 / 作業中 / 完了
- **優先度**: 🔥🔥🔥（最優先）、🔥🔥（高優先）、🔥（中優先）、💡（低優先）
- **記事情報**: タイトル、パス、掲載順位、表示回数、CTR、クリック数、主要クエリ
- **リライト完了日**: 完了後に記入
- **備考**: リライト方針、改善結果など

### 優先度の基準

Google Search Console のデータを元に、以下の基準で優先度を決定します：

| 優先度 | 条件 | 理由 |
|--------|------|------|
| 🔥🔥🔥 最優先 | 掲載順位11-30位 + 表示回数100以上/月 | 少しの改善で1ページ目に上がる可能性が高い |
| 🔥🔥 高優先 | CTR < 平均の半分 + 表示回数50以上/月 | タイトル改善で即効性がある |
| 🔥 中優先 | 技術情報が古い（1年以上更新なし） | 最新情報への更新で順位改善の可能性 |
| 💡 低優先 | 掲載順位31-50位 + 表示回数 < 50/月 | 時間があれば実施 |

### リライトの進め方

1. `tech-blog/rewrite-tasks.md` を確認し、最も優先度が高い未着手記事を選択
2. 該当記事のステータスを `[▶]` (作業中) に更新
3. リライト作業を実施
4. 完了後、ステータスを `[x]` (完了) に更新し、リライト完了日を記入
5. 次の優先度が高い記事に進む

**詳細**: `FORMS.md` と `references/rewrite-planning-guide.md` を参照

## 主な機能

### 1. SEOタイトル最適化

検索結果でクリックされやすい、魅力的で正確なタイトルを作成します。

**最適化ポイント:**
- ターゲットキーワードを自然に含める（できれば前半に配置）
- 文字数は30-35文字以内（検索結果で切れない長さ）
- 数字や具体性を含めてクリック率向上
- 感情的フックまたはベネフィットを明示

**例:**
```
Before: Reactのhooksについて
After: React Hooks完全ガイド｜useState/useEffect の使い方と実践例7選
```

**詳細:** `references/title-optimization.md` を参照

### 2. メタディスクリプション生成

検索結果のスニペットに表示される説明文を最適化します。

**最適化ポイント:**
- 文字数は120-160文字（モバイル・PC両対応）
- ターゲットキーワードを含める
- 記事の価値とベネフィットを明確に
- 行動を促す表現（CTA）を含める

**例:**
```html
<meta name="description" content="React Hooksの基礎から実践まで徹底解説。useState、useEffect、カスタムフックの使い方を実例7つで学べます。初心者から中級者まで必見のガイド。">
```

**詳細:** `references/meta-optimization.md` を参照

### 3. 本文のSEO最適化

本文の構造、キーワード配置、読みやすさを改善します。

**最適化ポイント:**
- **見出し構造（H2-H6）**: 論理的な階層構造、キーワード含有
- **キーワード密度**: 自然な範囲で1-3%、共起語も含める
- **段落構成**: 1段落3-5文、スキャン可能な構造
- **リスト・表の活用**: 情報を視覚的に整理（**注意: noteでは表は使用不可**）
- **内部リンク**: 関連記事への自然な導線
- **外部リンク**: 信頼できる参照元へのリンク

**例:**
```markdown
## React Hooksとは？【基礎知識】

React Hooksは、React 16.8で導入された...

### useStateの使い方

useStateは状態管理を行う基本的なHookです...

#### 実装例：カウンター機能
```

**詳細:** `references/content-optimization.md` を参照

### 4. コンテンツ拡充提案

検索意図を満たすための追加コンテンツを提案します。

**拡充提案項目:**
- **FAQセクション**: よくある質問と回答
- **実践例・コード例**: 具体的な実装パターン
- **比較表**: 類似技術・手法との比較
- **図解・スクリーンショット**: 視覚的な説明
- **トラブルシューティング**: よくあるエラーと解決法
- **関連トピック**: 読者が次に知りたい情報

**例:**
```markdown
## よくある質問（FAQ）

### Q1: useEffectはいつ実行されますか？
A: useEffectは...

### Q2: カスタムフックの作り方は？
A: カスタムフックは...
```

**詳細:** `references/content-expansion.md` を参照

### 5. 古い表現・情報の更新

技術記事の鮮度を保つため、最新情報に更新します。

**更新対象:**
- **バージョン情報**: ライブラリ・フレームワークの最新バージョン
- **非推奨API**: 現在推奨される代替手法への置き換え
- **ベストプラクティス**: 最新の開発手法・パターン
- **パフォーマンス**: 新しい最適化手法
- **セキュリティ**: 最新のセキュリティガイドライン

**例:**
```
Before: componentDidMountを使って...
After: useEffectフックを使って...（関数コンポーネント推奨）

Before: React 16で...
After: React 18の最新機能を使って...
```

**詳細:** `references/content-update.md` を参照

### 6. 構造化データ提案

検索エンジンが内容を理解しやすくするJSON-LD形式のスキーマを提案します。

**提案スキーマ:**
- **Article**: 記事の基本情報
- **BreadcrumbList**: パンくずリスト
- **HowTo**: チュートリアル記事用
- **FAQPage**: FAQ形式の記事用
- **Person/Organization**: 著者・組織情報

**例:**
```json
{
  "@context": "https://schema.org",
  "@type": "TechArticle",
  "headline": "React Hooks完全ガイド",
  "description": "React Hooksの使い方を...",
  "author": {
    "@type": "Person",
    "name": "山田太郎"
  },
  "datePublished": "2024-01-15",
  "dateModified": "2025-10-20"
}
```

**詳細:** `references/structured-data.md` を参照

### 7. 内部リンク戦略提案

サイト内の関連記事への効果的な導線を提案します。

**提案ポイント:**
- 関連性の高い記事への自然なリンク
- アンカーテキストにキーワードを含める
- 記事の流れを妨げない配置
- 「関連記事」セクションの追加

**例:**
```markdown
React Hooksをさらに深く学びたい方は、
[カスタムフックの実践的な使い方](./custom-hooks-guide.md)も
ぜひご覧ください。
```

**詳細:** `references/internal-linking.md` を参照

## SEOリライトの実施手順

### ステップ0: 事前準備（GSCデータの取得と記事情報の収集）

**重要**: リライト作業を開始する前に、必ずGoogle Search Consoleのデータを取得します。

#### 0-1. 記事の特定

ユーザーに以下を確認:
```
リライト対象の記事を教えてください。
- 記事のファイルパス（例: drafts/python-encoding.md）
- または記事のタイトル
```

#### 0-2. GSCデータの取得

ユーザーに以下の情報を依頼:
```
この記事のGoogle Search Consoleデータを教えてください：

【必須情報】
- 掲載順位: 〇位
- 表示回数: 〇回/月
- CTR: 〇%
- クリック数: 〇回/月

【主要クエリ（トップ3-5個）】
1. キーワード（表示: 〇回、順位: 〇位、CTR: 〇%）
2. ...

※提供方法: テキスト、スクリーンショット、CSVのいずれでもOK
```

**詳細**: `FORMS.md` を参照

#### 0-3. GSCデータの分析と優先度判定

取得したデータを元に、記事の現状を分析し、優先度を判定:

```markdown
【現状分析】
- 掲載順位: 〇位
- 表示回数: 〇回/月
- CTR: 〇%
- クリック数: 〇回/月
- 主要クエリ: [リスト]

【優先度】
🔥🔥🔥 / 🔥🔥 / 🔥 / 💡

【推奨リライト内容】
1. タイトル最適化（理由）
2. メタディスクリプション改善（理由）
3. コンテンツ拡充（理由）
...

上記の方針でリライトを実施してよろしいでしょうか？
```

ユーザーの承認を得てから、次のステップに進みます。

### ステップ1: 記事分析

GSCデータを踏まえて記事を詳細分析:

```
1. 記事のURLまたは全文を取得（ファイルを読み込み）
2. 現在のタイトル、見出し構造を把握
3. GSCの主要クエリと記事内容の整合性を確認
4. ターゲットキーワードの出現頻度をチェック
5. 競合記事との差分を確認（可能であれば）
```

### ステップ2: SEO監査

`references/seo-checklist.md`に基づいて現状を評価:

- [ ] タイトルにキーワードが含まれているか
- [ ] メタディスクリプションは最適か
- [ ] 見出し構造は論理的か（H1→H2→H3）
- [ ] キーワード密度は適切か
- [ ] 画像にalt属性があるか
- [ ] 内部リンクがあるか
- [ ] ページ速度は十分か
- [ ] モバイル対応しているか

### ステップ3: リライト実施

優先順位に基づいて各要素を最適化:

1. **タイトル・メタ情報** (高優先度)
2. **冒頭セクションの構成** (高優先度)
   - 導入文（リード文）: 記事の概要を1-2文で説明
   - 要約: `> **この記事で分かること**` の箇条書き
   - 対象読者と検証環境: `**対象読者:**` `**検証環境:**`
3. **見出し構造** (高優先度)
4. **本文のキーワード最適化** (中優先度)
5. **コンテンツ拡充** (中優先度)
6. **古い情報の更新** (中優先度)
7. **構造化データ** (低優先度)
8. **内部リンク** (低優先度)
9. **ファイル出力** (必須)

### ステップ4: 品質チェック

最終的な品質を確認:

- **冒頭セクション（必須）** - **この順序を厳守すること**:
  - [ ] `## 要約` のH2見出しから記事が開始し、2-3文の要約が記載されているか
  - [ ] 要約セクション内に `**対象読者:**` が明記されているか
  - [ ] 要約セクション内に `**検証環境:**` が明記されているか（バージョン情報と年月）
  - [ ] `## この記事を読むことで得られるメリット` のH2見出しがあるか
  - [ ] メリットセクション内に `この記事を読むことで以下のことが分かる:` の箇条書きがあるか（3-6項目、引用ブロック不要）
  - [ ] `## この記事を読むのにかかる時間` のH2見出しがあり、読了時間が明記されているか
  - [ ] `## 環境` のH2見出しがあるか（環境情報がある場合）
  - [ ] 上記の順序が正しいか（要約→メリット→読むのにかかる時間→環境→本題）
- 読みやすさ（文章の流れ、段落構成）
- 正確性（技術情報、コード例）
- 完全性（検索意図を満たしているか）
- ユーザビリティ（目次、FAQ、内部リンク）
- **文字化けチェック（日本語が正しく表示されているか、特殊文字が正しく表示されているか）**
- **水平線チェック（`---`、`***`、`___`が含まれていないことを確認）** ← **絶対に確認すること**

### ステップ5: ファイル出力

最適化した記事をマークダウンファイルとして出力する。

**出力ディレクトリ:**
```
tech-blog/output/
```

**ファイル命名規則:**
- 記事のメインキーワードを英語にした分かりやすい名前
- ケバブケース（kebab-case）を使用
- 例: `port-already-in-use-solution.md`, `react-hooks-guide.md`

**出力手順:**

1. **ディレクトリの確認・作成**
   ```bash
   mkdir -p tech-blog/output
   ```

2. **マークダウンファイルの作成**
   - HTMLコメント内にメタ情報と構造化データを含める
   - 本文はそのままマークダウン形式で出力
   - WYSIWYGエディタに直接貼り付け可能な形式

3. **ファイル内容の構成**
   ```markdown
   <!--
   SEO最適化済み記事
   生成日: YYYY-MM-DD
   元記事: [元記事のタイトルまたはURL]

   【HTMLメタタグ】
   <title>...</title>
   <meta name="description" content="...">
   ...
   -->

   [本文のマークダウン]

   <!--
   【構造化データ（JSON-LD）】
   以下をHTMLの<head>内に配置してください。

   <script type="application/ld+json">
   {...}
   </script>
   -->
   ```

4. **ユーザーへの通知**
   - 出力先のファイルパスを明示
   - ファイルの使い方を簡潔に説明

### ステップ6: タスク管理ファイルの更新

リライト作業が完了したら、`tech-blog/rewrite-tasks.md` を更新してタスクの進捗を記録します。

**更新内容:**

1. **ステータスの更新**
   - 該当記事の行のステータスを `[x]` (完了) に変更

2. **リライト完了日の記入**
   - 「リライト完了日」列に完了日を記入（例: 2025-11-08）

3. **備考欄の更新**
   - 実施したリライト内容を簡潔に記録
   - 例: 「タイトル改善、FAQ追加、コード例3つ追加」

4. **リライト実績サマリーの更新**
   - 完了記事数をカウント
   - 1ヶ月後に効果測定結果を追記

**記録例:**

```markdown
| ステータス | 記事タイトル | 記事パス | 順位 | 表示回数 | CTR | クリック数 | 主要クエリ | リライト完了日 | 備考 |
|:---:|---|---|:---:|:---:|:---:|:---:|---|:---:|---|
| [x] | Pythonの文字化け対処法 | drafts/python-encoding.md | 15位 | 250/月 | 3.2% | 8回 | Python 文字化け | 2025-11-08 | タイトル改善、FAQ追加、コード例3つ追加。1ヶ月後測定予定 |
```

**完了報告（ユーザーへの通知例）:**

```markdown
## SEOリライト完了報告

【記事情報】
- 元タイトル: Pythonの文字化け対処法
- 最適化後タイトル: 【2025年版】Python文字化け対処法｜Windows/Mac環境別の5つの解決策

【実施内容】
✅ タイトル最適化（数字・具体性を追加）
✅ メタディスクリプション作成（128文字）
✅ 見出し構造改善（H2-H3の論理的階層）
✅ FAQセクション追加（5つの質問）
✅ コード例追加（3つの実装パターン）
✅ 最新情報への更新（Python 3.12対応）

【出力ファイル】
- tech-blog/output/python-encoding-optimized.md

【期待される効果】
- 掲載順位: 15位 → 5-10位の改善見込み
- クリック数: 8回/月 → 15-20回/月の増加見込み
- CTR: 3.2% → 5-8%の改善見込み

【次のステップ】
1. tech-blog/rewrite-tasks.md を更新しました ✅
2. 1ヶ月後（2025-12-08頃）に効果測定を実施してください
3. 次の優先度が高い記事のリライトに進んでください
```

## 出力形式

リライト結果は以下の2つの形式で提供する:

1. **チャット内での表示**: ユーザーがすぐに内容を確認できるよう、主要な情報をチャット内に表示
2. **マークダウンファイル**: `tech-blog/output/` ディレクトリに完全版を出力

### 重要な出力ルール

**マークダウン形式で出力:**
- 本文はマークダウン記法を使用
- 見出しは `##`, `###`, `####`
- WYSIWYGエディタにそのまま貼り付け可能な形式
- **コードブロック（```）で囲まない** - 直接マークダウンテキストとして出力

**文体:**
- **「だ・である調」を使用**（「です・ます調」は使わない）
- 例: 「〜です」→「〜である」、「〜します」→「〜する」

**目次について:**
- ユーザーのWebサイトはH2要素（`##`）から自動的に目次を生成する
- そのため、記事内に目次セクションは**含めない**
- H2見出しを適切に配置するだけでOK

**水平線について:**
- 水平線（`---`、`***`、`___`）は**絶対に使用禁止**
- セクション区切りはH2見出しで表現
- **例外なく水平線は使わないこと**（まとめや参考文献セクションの前でも禁止）
- **チェック項目**: 記事作成後、必ず全文を確認して水平線が含まれていないことを確認する

### プラットフォーム別の最適化

**note用の最適化:**
- **表（テーブル）は使用不可** - noteはマークダウン表をサポートしていないため、表は使わず箇条書きで代替する
- 表の代替形式例:
  ```markdown
  **Web開発**
  - 求められる水準: フレームワークの基本理解、APIの扱い
  - 深い専門性が必要なケース: 超大規模システム、リアルタイム処理
  ```
- H1タイトルは削除（noteのタイトル欄に別途入力）
- 記事末尾にハッシュタグを追加（10〜15個）
- 記事末尾にCTA（スキ・フォロー依頼）を追加
- HTMLコメント（メタタグ、構造化データ）は削除

**はてなブログ用の最適化:**
- 表は使用可能
- 目次は自動生成されるため手動では不要
- はてな記法との互換性に注意

**WordPress用の最適化:**
- 表は使用可能
- HTMLタグも使用可能
- ショートコードの活用を検討

### 1. エグゼクティブサマリー

```markdown
## SEOリライト完了報告

### 主な改善点
- タイトル最適化: クリック率向上のため数字と具体性を追加
- 見出し構造: H2-H3の階層を整理、キーワード含有率向上
- コンテンツ拡充: FAQ、実践例を3つ追加
- 技術情報更新: React 16 → React 18の最新情報に更新

### SEOスコア
- Before: 45/100
- After: 82/100

### 期待される効果
- 検索順位: 3-5位の改善見込み
- クリック率: 15-25%の向上見込み

### 出力ファイル
- ファイルパス: `tech-blog/output/react-hooks-guide.md`
- このファイルをWYSIWYGエディタに直接貼り付けて使用できます
```

### 2. 最適化されたメタ情報

```html
<!-- タイトル -->
<title>React Hooks完全ガイド｜useState/useEffect の使い方と実践例7選</title>

<!-- メタディスクリプション -->
<meta name="description" content="React Hooksの基礎から実践まで徹底解説。useState、useEffect、カスタムフックの使い方を実例7つで学べます。初心者から中級者まで必見のガイド。">

<!-- OGPタグ -->
<meta property="og:title" content="React Hooks完全ガイド｜useState/useEffect の使い方と実践例7選">
<meta property="og:description" content="React Hooksの基礎から実践まで徹底解説。">
<meta property="og:type" content="article">
```

### 3. リライトされた本文の出力例

**WYSIWYGエディタに直接貼り付け可能なマークダウン形式で出力:**

**重要: コードブロックで囲まず、直接マークダウンテキストとして出力する**

#### 標準的な記事構成（必須セクション）

リライト記事は以下の見出し構成を**必ず**この順序で記載する：

1. **## 要約** - 記事の要約を2-3文で記載、対象読者と検証環境も含める
2. **## この記事を読むことで得られるメリット** - 箇条書きで主要なポイントを列挙
3. **## この記事を読むのにかかる時間** - 読了時間を明記
4. **## 環境**（あれば） - 動作確認環境
5. **## 本題の見出し** - H2レベルから本題開始

**重要:** この順序は厳守すること。特に「要約」「メリット」「読むのにかかる時間」「環境」の順序を間違えないこと。

**テンプレート構成:**
```
## 要約

[記事の要約を2-3文で]

**対象読者:** [対象者]

**検証環境:** [バージョン情報]（YYYY年MM月時点）

## この記事を読むことで得られるメリット

この記事を読むことで以下のことが分かる:
- [ポイント1]
- [ポイント2]
- [ポイント3]

## この記事を読むのにかかる時間

約[X]分

## 環境

- MacOS Apple M4 Max Sequoia 15.1
- [その他の環境情報]

## [本題の最初のH2見出し]
```

#### 出力例（コードブロックなし）:

Python でprint文を使って日本語を出力すると文字化けが発生することがある。本記事では、Windows・Mac環境別の対処法を5つ紹介し、根本原因から解決方法まで徹底解説する。

## 要約

Pythonのprint文で日本語を出力する際、Windows環境では文字化けが発生することが多い。これは標準出力とターミナルのエンコーディング不一致が原因である。本記事では、環境別の対処法を5つ紹介し、根本原因から恒久的な解決策まで徹底解説する。

**対象読者:** Python初心者〜中級者

**検証環境:** Python 3.10 〜 3.12（2024年10月時点）

## この記事を読むことで得られるメリット

この記事を読むことで以下のことが分かる:
- print文で文字化けが起こる原因
- 環境別の5つの対処法（コード例付き）
- 恒久的な解決策の設定方法

## この記事を読むのにかかる時間

約8分

## 環境

- MacOS Apple M4 Max Sequoia 15.1
- Python 3.10 〜 3.12

## 文字化けが発生する原因

Python のprint文で文字化けが起こる主な原因は、**標準出力のエンコーディング**と**ターミナルのエンコーディング**の不一致である。

### 発生しやすい環境

| 環境 | デフォルトエンコーディング | 文字化けリスク |
|------|----------------------------|----------------|
| Windows | CP932（Shift-JIS系） | 高い |
| Mac/Linux | UTF-8 | 低い |

### 文字化けの例

```python
print("こんにちは、世界！")
# Windowsでの出力例: ���������A���E���I
```

**根本原因:**
- Windows のコマンドプロンプトはデフォルトで CP932
- Python 3 の内部文字列は UTF-8
- エンコーディング不一致により文字化けが発生

## 対処法1: 標準出力のエンコーディング指定

最も確実な方法は、プログラムの冒頭で標準出力を UTF-8 に設定することです。

### コード例

```python
import io
import sys

# 標準出力をUTF-8に設定
sys.stdout = io.TextIOWrapper(sys.stdout.buffer, encoding='utf-8')
print("こんにちは、世界！")
```

### メリット・デメリット

| メリット | デメリット |
|---------|-----------|
| ✅ 確実に動作する | ❌ 毎回コードに記述が必要 |
| ✅ 環境に依存しない | ❌ コードが冗長になる |

<!-- 以降同様 -->

### 4. 構造化データ

```json
{
  "@context": "https://schema.org",
  "@type": "TechArticle",
  ...
}
```

### 5. 改善提案リスト

```markdown
## さらなる改善提案

### 高優先度
- [ ] 記事内に実際の動作デモを埋め込む
- [ ] 図解を3-5枚追加する

### 中優先度
- [ ] 関連記事「カスタムフックの作り方」へ内部リンク追加
- [ ] トラブルシューティングセクション追加

### 低優先度
- [ ] 動画チュートリアル検討
- [ ] 読者コメント欄の設置
```

## ベストプラクティス

### 1. 自然な文章を優先

SEOを意識しすぎて、不自然なキーワードの詰め込みは避けます:

❌ **悪い例:**
```
React HooksはReactの機能です。React Hooksを使うと
Reactのコンポーネントで状態管理ができます。React Hooksは便利です。
```

✅ **良い例:**
```
React Hooksは、関数コンポーネントで状態管理や副作用を扱える機能です。
従来のクラスコンポーネントよりもシンプルで読みやすいコードが書けます。
```

### 2. ユーザーファーストの視点

検索エンジンよりも、読者にとって価値のある内容を優先します:

- 実践的なコード例を豊富に
- よくある疑問に先回りして答える
- 段階的な説明（初心者→中級者）
- トラブルシューティング情報

### 3. E-E-A-T の強化

Googleが重視するE-E-A-T（経験、専門性、権威性、信頼性）を意識:

- 著者の経験・実績を明記
- 正確な技術情報、公式ドキュメントへの参照
- 最終更新日を明記
- 読者からのフィードバックを反映

### 4. 継続的な更新

SEOは一度で完結せず、継続的な改善が重要:

- 3-6ヶ月ごとに情報を更新
- 検索順位・アクセス数をモニタリング
- 競合記事の分析と差別化
- 読者からの質問をFAQに追加

## リファレンスファイルの詳細

### FORMS.md

リライト作業時にユーザーから必要な情報を収集するためのフォーム定義:
- 記事の特定方法
- Google Search Console データの取得方法
- リライト方針の確認フロー
- タスク管理ファイルの更新手順
- 対話フローの具体例

**使用タイミング**: リライト作業開始時の情報収集、GSCデータの提供方法確認

### references/seo-checklist.md

テックブログのSEO監査用チェックリスト:
- オンページSEO項目
- テクニカルSEO項目
- コンテンツ品質項目
- ユーザーエクスペリエンス項目

**使用タイミング:** リライト前の現状分析、リライト後の品質チェック

### references/title-optimization.md

SEOタイトルの最適化ガイド:
- 効果的なタイトルの要素
- 文字数とキーワード配置
- クリック率を高めるテクニック
- テックブログ向けタイトルパターン集

**使用タイミング:** タイトルの改善・作成時

### references/meta-optimization.md

メタディスクリプション最適化ガイド:
- 文字数とキーワード戦略
- CTAの効果的な使い方
- OGPタグの設定
- テックブログ向けテンプレート

**使用タイミング:** メタ情報の作成・改善時

### references/content-optimization.md

本文コンテンツのSEO最適化ガイド:
- 見出し構造のベストプラクティス
- キーワード配置戦略
- 読みやすさの改善テクニック
- コードブロックの最適化

**使用タイミング:** 本文のリライト時

### references/content-expansion.md

コンテンツ拡充のアイデアとテンプレート:
- FAQセクションの作成
- 実践例の追加方法
- 比較表・図解の活用
- 関連トピックの提案

**使用タイミング:** コンテンツの充実化が必要な場合

### references/content-update.md

技術記事の更新ガイド:
- 最新バージョン情報の確認方法
- 非推奨APIの代替案
- ベストプラクティスの更新
- セキュリティ情報の反映

**使用タイミング:** 古い記事の更新時

### references/structured-data.md

構造化データ（JSON-LD）のテンプレート集:
- Article / TechArticle
- HowTo
- FAQPage
- BreadcrumbList
- 実装例とテストツール

**使用タイミング:** 構造化データの追加時

### references/internal-linking.md

内部リンク戦略ガイド:
- 効果的なアンカーテキスト
- リンク配置のベストプラクティス
- 関連記事セクションのデザイン
- サイト構造との関連

**使用タイミング:** 内部リンクの最適化時

### references/rewrite-planning-guide.md

テックブログのリライト計画ガイド:
- Google Search Console を活用した現状把握
- 優先度の高いリライト対象記事の選定方法
- カバレッジ・CTR・モバイルユーザビリティのチェック
- リライト後の効果測定方法
- 優先順位マトリックス

**使用タイミング:** リライト対象記事の選定時、SEO戦略の立案時

## 補足

### SEOツールの活用

作成したコンテンツは以下のツールで検証できます:

- **Google Search Console**: 検索パフォーマンスの確認
- **PageSpeed Insights**: ページ速度の測定
- **構造化データテスト**: Schema.orgの検証
- **モバイルフレンドリーテスト**: モバイル対応確認

### キーワードリサーチ

効果的なSEOには適切なキーワード選定が必須:

- Google キーワードプランナー
- ラッコキーワード
- Ubersuggest
- 競合記事の分析

### 測定と改善

リライト後は効果測定と継続的改善が重要:

```markdown
## 効果測定指標

- 検索順位（目標: 1-3位）
- オーガニック流入数（目標: 前月比150%）
- 平均セッション時間（目標: 3分以上）
- 直帰率（目標: 60%以下）
- コンバージョン率（目標: 2%以上）
```
