---
name: tech-blog-seo-rewriter
description: テックブログ記事をSEOに最適化してリライトするスキル。タイトル最適化、メタディスクリプション生成、本文のキーワード配置、コンテンツ拡充提案、古い表現の更新、構造化データ提案など、包括的なSEOライティングを実施。「SEOリライトして」「検索順位を上げたい」「記事を最適化」などのリクエストで利用。
---

# Tech Blog SEO Rewriter

テックブログ記事をSEOに強いコンテンツへリライトするスキル。

## 使用するタイミング

- 「この記事をSEO最適化してリライトして」
- 「検索順位を上げるために記事を改善したい」
- 「古いテックブログ記事を最新情報に更新して」
- 「メタディスクリプションとタイトルを最適化して」
- 「コンテンツをもっと充実させたい」

## クイックスタート

1. `FORMS.md` を参照してユーザーからGSCデータを収集
2. `REFERENCE.md` の実施手順に従ってリライト実施
3. 標準記事構成（導入文 → 要約 → 対象読者・環境 → 本題）を適用
4. `references/seo-checklist.md` で品質チェック
5. `tech-blog/output/` に最適化済みファイルを出力

## ファイル構成

- **REFERENCE.md** - 詳細な機能説明、実施手順、ベストプラクティス
- **FORMS.md** - 情報収集フォーム、対話フロー
- **references/** - 個別の最適化ガイドライン
  - `seo-checklist.md` - SEO監査チェックリスト
  - `title-optimization.md` - タイトル最適化ガイド
  - `meta-optimization.md` - メタディスクリプション最適化
  - `content-optimization.md` - 本文のSEO最適化
  - `content-expansion.md` - コンテンツ拡充提案
  - `content-update.md` - 古い情報の更新
  - `structured-data.md` - 構造化データ提案
  - `internal-linking.md` - 内部リンク戦略
  - `rewrite-planning-guide.md` - リライト計画ガイド
