# テックブログリライト計画ガイド

## 概要

このガイドでは、Google Search Console（GSC）のデータを活用して、テックブログのリライト対象記事を選定し、効果的に改善する戦略を解説する。

## 前提条件

- Google Search Console にサイトが登録されている
- 最低でも3ヶ月以上のデータが蓄積されている
- 記事数が10本以上ある

## リライト計画の5ステップ

### 1. 現状把握：検索パフォーマンスの分析

**目的**: サイト全体の検索パフォーマンスを把握し、改善の余地がある記事を見つける

**手順**:

1. Google Search Console にアクセス
2. 左メニューから「検索パフォーマンス」を選択
3. 以下の指標を確認:
   - **クリック数**: 実際にクリックされた回数
   - **表示回数**: 検索結果に表示された回数
   - **CTR (クリック率)**: クリック数 ÷ 表示回数
   - **平均掲載順位**: 検索結果での平均順位

**確認ポイント**:

- ✅ どんなキーワードでアクセスされているか
- ✅ 意図していなかったキーワードでの流入はないか
- ✅ 書いた記事と実際の検索意図にズレがないか
- ✅ 季節性やトレンドによる変動はあるか

**データ期間の設定**:
- 比較期間: 過去3ヶ月 vs 前期3ヶ月
- 長期トレンド: 過去12ヶ月

**エクスポート**:
- データをCSVでエクスポートし、スプレッドシートで分析すると効率的

### 2. 優先度付け：低順位で表示回数が多い記事に注目

**目的**: 改善効果が高い「惜しい記事」を特定する

**優先対象**:

| 条件 | 理由 | 優先度 |
|------|------|--------|
| 掲載順位 11〜30位 + 表示回数が多い | 少しの改善で1ページ目に上がる可能性 | 🔥 最高 |
| 掲載順位 4〜10位 | さらに上位を狙える | 🔥 高 |
| 表示回数は多いがCTRが低い | タイトル改善で即効性あり | 🔥 高 |
| 掲載順位 31〜50位 + 表示回数が少ない | 長期的な改善対象 | 中 |
| 掲載順位 51位以下 | 大幅なリライトまたは削除を検討 | 低 |

**具体的な選定方法**:

```
1. 「ページ」タブで全記事のパフォーマンスを確認
2. 「平均掲載順位」で降順ソート
3. 掲載順位 11〜30位 の記事をピックアップ
4. その中で「表示回数」が多い順に並び替え
5. 上位10記事をリライト候補とする
```

**テックブログ特有のポイント**:

- **技術記事は鮮度が重要**: 古いバージョン情報が含まれている場合、優先的に更新
- **コード例の充実度**: コード例が少ない記事は、実装例を追加すると順位が上がりやすい
- **最新情報の追加**: 新しいバージョン、新機能、ベストプラクティスの変化を反映

### 3. カバレッジ（インデックス登録）のチェック

**目的**: 記事が正しくGoogleにインデックスされているか確認し、技術的な問題を解消する

**手順**:

1. 左メニューから「インデックス」→「ページ」を選択
2. 以下の項目をチェック:
   - **インデックス登録済み**: 問題なくインデックスされている
   - **エラー**: クロール不可、サーバーエラー、リダイレクトエラーなど
   - **警告**: noindexタグ、canonicalの問題など
   - **除外**: Googleが意図的にインデックスしていないページ

**よくあるエラーと対処法**:

| エラー | 原因 | 対処法 |
|--------|------|--------|
| 404エラー | ページが存在しない | 修正 or 301リダイレクト設定 |
| サーバーエラー (5xx) | サーバーの一時的な障害 | サーバー設定を確認、再クロールをリクエスト |
| noindex タグが設定されている | メタタグまたはrobots.txtで除外 | 意図的でなければタグを削除 |
| クロール済み - インデックス未登録 | コンテンツの品質が低い | コンテンツを拡充、E-E-A-Tを強化 |
| 重複しています | 同じ内容のページが複数存在 | canonical タグで正規URLを指定 |

**新しい記事のインデックス確認**:

```
1. 記事を公開後、数日待つ
2. GSCの「URL検査」ツールで記事URLを入力
3. 「インデックス登録をリクエスト」をクリック
4. 1週間後に再度確認
```

### 4. CTRが低いページを改善

**目的**: 表示されているのにクリックされない記事のタイトルとメタディスクリプションを改善する

**CTR改善の基準**:

| 掲載順位 | 平均CTR | 改善対象の基準 |
|----------|---------|---------------|
| 1位 | 30-40% | 25%以下なら改善の余地あり |
| 2-3位 | 15-25% | 10%以下なら改善の余地あり |
| 4-10位 | 5-15% | 3%以下なら改善の余地あり |
| 11-20位 | 2-5% | 1%以下なら改善の余地あり |

**改善方法**:

#### タイトルの改善

**Before（クリックされにくい）:**
```
Pythonについて
Reactのhooksの使い方
Dockerの基本
```

**After（クリックされやすい）:**
```
【2025年版】Python入門ガイド｜環境構築から実践まで完全解説
React Hooks完全ガイド｜useState/useEffect の使い方と実践例7選
【図解】Docker入門｜コンテナの基本から実務での使い方まで
```

**タイトル改善のポイント**:
- ✅ 具体的な数字を含める（「7選」「5つの方法」）
- ✅ 年号を入れて鮮度をアピール（「2025年版」）
- ✅ 対象読者を明示（「初心者向け」「実務で使える」）
- ✅ ベネフィットを明確に（「完全ガイド」「徹底解説」）
- ✅ 記号を活用して目立たせる（【】｜など）

#### メタディスクリプションの改善

**改善ポイント**:
- 120-160文字以内
- ターゲットキーワードを含める
- 記事の価値とベネフィットを明確に
- 行動を促す表現（「〜を学べます」「〜が分かります」）

**例:**
```html
<meta name="description" content="React Hooksの基礎から実践まで徹底解説。useState、useEffect、カスタムフックの使い方を実例7つで学べます。初心者から中級者まで必見のガイド。">
```

### 5. モバイルユーザビリティの確認

**目的**: モバイル対応の問題を解消し、モバイルユーザーの離脱を防ぐ

**手順**:

1. 左メニューから「エクスペリエンス」→「ページエクスペリエンス」を選択
2. 「モバイル」タブでエラーをチェック
3. 「Core Web Vitals」の指標を確認

**よくある問題と対処法**:

| 問題 | 原因 | 対処法 |
|------|------|--------|
| テキストが小さすぎて読めない | フォントサイズが12px未満 | 16px以上に設定 |
| クリック可能な要素同士が近すぎる | タッチターゲットが小さい | 最低48x48pxの領域を確保 |
| コンテンツの幅が画面の幅を超えている | viewport設定がない | `<meta name="viewport" content="width=device-width, initial-scale=1">` を追加 |
| 画像の読み込みが遅い | 画像が最適化されていない | WebP形式に変換、遅延読み込み実装 |

**テックブログ特有の注意点**:

- **コードブロックの横スクロール**: モバイルで見やすいようにコードの折り返しを検討
- **表組みの対応**: 幅が広い表は横スクロール可能にするか、カード形式に変更
- **図解・スクリーンショット**: モバイルでも見やすいサイズに調整

## リライト実施の優先順位マトリックス

実際のリライト作業では、以下のマトリックスで優先順位を決定する。

| 優先度 | 条件 | アクション |
|--------|------|-----------|
| 🔥🔥🔥 最優先 | 掲載順位 11〜30位 + 表示回数 100以上/月 | 今週中にリライト実施 |
| 🔥🔥 高優先 | CTR < 平均の半分 + 表示回数 50以上/月 | 今月中にタイトル・メタディスクリプション改善 |
| 🔥 中優先 | 技術情報が古い（1年以上更新なし） | 最新情報に更新、コード例を追加 |
| 💡 低優先 | 掲載順位 31〜50位 + 表示回数 < 50/月 | コンテンツ拡充を検討（時間があれば） |
| 🗑️ 削除検討 | 掲載順位 51位以下 + 表示回数 < 10/月 | 削除または大幅リライト |

## リライト後の効果測定

リライト実施後は、以下の指標を継続的にモニタリングする。

### 測定期間

- **短期**: リライト後 2週間〜1ヶ月
- **中期**: リライト後 1〜3ヶ月
- **長期**: リライト後 3〜6ヶ月

### 測定指標

| 指標 | 目標 | 確認方法 |
|------|------|----------|
| 掲載順位 | 5-10位の改善 | GSC 検索パフォーマンス |
| クリック数 | 前期比 150% | GSC 検索パフォーマンス |
| CTR | 前期比 120% | GSC 検索パフォーマンス |
| 平均セッション時間 | 前期比 110% | Google Analytics |
| 直帰率 | 前期比 -10% | Google Analytics |

### 記録テンプレート

```markdown
## リライト記録

### 記事情報
- 記事URL:
- リライト日: YYYY-MM-DD
- ターゲットキーワード:

### リライト前
- 掲載順位: 〇位
- クリック数: 〇回/月
- CTR: 〇%
- 表示回数: 〇回/月

### 実施内容
- [ ] タイトル最適化
- [ ] メタディスクリプション改善
- [ ] 見出し構造の改善
- [ ] コンテンツ拡充（〇〇セクション追加）
- [ ] コード例の追加
- [ ] 最新情報への更新

### リライト後（1ヶ月後）
- 掲載順位: 〇位（改善: +/-〇位）
- クリック数: 〇回/月（改善: +/-〇%）
- CTR: 〇%（改善: +/-〇%）
- 表示回数: 〇回/月（改善: +/-〇%）

### 考察
- 改善できた点:
- 更なる改善余地:
```

## よくある質問

### Q1: リライトの頻度はどのくらいが適切？

**A**: テックブログの場合、以下を推奨する。

- **技術記事**: 半年〜1年に1回、最新情報を確認して更新
- **入門記事**: 1年に1回、初心者に分かりやすいか見直し
- **トレンド記事**: 四半期に1回、最新トレンドを追加
- **ツール紹介**: ツールの大型アップデート時に更新

### Q2: リライトと新規記事、どちらを優先すべき？

**A**: 以下のバランスを推奨する。

- **既存記事が50本未満**: 新規記事を優先（週2本）
- **既存記事が50-100本**: 新規記事 60% + リライト 40%
- **既存記事が100本以上**: 新規記事 40% + リライト 60%

ただし、「惜しい記事」（掲載順位11-30位）が多い場合は、リライトを優先。

### Q3: どのくらいの改善幅を目指すべき？

**A**: 以下を現実的な目標とする。

- **掲載順位**: 5-10位の改善（例: 15位 → 5-10位）
- **クリック数**: 前期比 150%（例: 100回/月 → 150回/月）
- **CTR**: 前期比 120%（例: 5% → 6%）

ただし、競合の強さやキーワードの難易度によって変動する。

### Q4: リライトしても順位が上がらない場合は？

**A**: 以下を確認する。

1. **競合分析**: 上位記事と比較して、何が足りないか確認
2. **検索意図の確認**: ユーザーが本当に求めている情報か見直す
3. **E-E-A-T**: 専門性、権威性、信頼性を強化
4. **被リンク**: 質の高い外部サイトからのリンクを獲得
5. **サイト全体の評価**: ドメインパワーが弱い場合は時間がかかる

それでも改善しない場合は、キーワード自体を見直すか、別の角度からの記事作成を検討。

## まとめ

テックブログのリライト計画は、以下の5ステップで実施する。

1. **現状把握**: Google Search Console で検索パフォーマンスを分析
2. **優先度付け**: 掲載順位 11-30位 + 表示回数が多い「惜しい記事」に注目
3. **技術的問題の解消**: カバレッジで404エラーやインデックス問題を修正
4. **CTR改善**: タイトルとメタディスクリプションを魅力的に
5. **モバイル対応**: モバイルユーザビリティの問題を解消

リライト後は、2週間〜1ヶ月で効果を測定し、継続的に改善を繰り返すことが重要である。
