# SEOチェックリスト

テックブログ記事のSEO品質を評価するための包括的なチェックリストです。

## 1. オンページSEO

### タイトルタグ (Title Tag)

- [ ] ページにユニークなタイトルが設定されている
- [ ] タイトルは30-35文字以内（検索結果で切れない）
- [ ] 主要キーワードがタイトルに含まれている
- [ ] キーワードは可能な限り前方に配置されている
- [ ] タイトルに数字や具体性がある（例: 「7つの方法」「2024年版」）
- [ ] クリックを促す要素がある（ガイド、完全版、実践など）

**例:**
```html
✅ <title>React Hooks完全ガイド｜useState/useEffect の使い方と実践例7選</title>
❌ <title>React Hooksについて</title>
```

### メタディスクリプション (Meta Description)

- [ ] ページに独自のディスクリプションが設定されている
- [ ] 文字数は120-160文字（モバイル・PC両対応）
- [ ] 主要キーワードが含まれている
- [ ] 記事の価値とベネフィットが明確
- [ ] 行動を促す表現（CTA）が含まれている

**例:**
```html
✅ <meta name="description" content="React Hooksの基礎から実践まで徹底解説。useState、useEffect、カスタムフックの使い方を実例7つで学べます。初心者から中級者まで必見のガイド。">
❌ <meta name="description" content="React Hooksについての記事です。">
```

### 見出し構造 (Heading Structure)

- [ ] H1タグがページに1つだけ存在する
- [ ] H1にはページの主題とキーワードが含まれている
- [ ] H2-H6が論理的な階層構造になっている（H2→H3→H4、飛ばさない）
- [ ] 各見出しが内容を的確に表している
- [ ] 主要な見出しにキーワードまたは関連語が含まれている
- [ ] 見出しだけで記事の構造が理解できる

**例:**
```markdown
✅
# React Hooks完全ガイド（H1）
## React Hooksとは？（H2）
### useStateの基本（H3）
#### 実装例：カウンター（H4）
### useEffectの基本（H3）
## 実践的な使い方（H2）

❌
# React Hooks（H1）
### useState（H3） ← H2を飛ばしている
## useEffect（H2） ← H3の後にH2
```

### URL構造 (URL Structure)

- [ ] URLが短く、わかりやすい
- [ ] キーワードがURLに含まれている
- [ ] ハイフンで単語を区切っている（アンダースコアではなく）
- [ ] 小文字のみを使用している
- [ ] 不要なパラメータがない

**例:**
```
✅ https://example.com/blog/react-hooks-guide
❌ https://example.com/blog/article?id=12345&category=react
```

### キーワード最適化

- [ ] 主要キーワードの密度が1-3%程度（自然な範囲）
- [ ] キーワードが導入部分（最初の100単語以内）に含まれている
- [ ] 共起語（LSIキーワード）が適切に含まれている
- [ ] キーワードのバリエーション（同義語、関連語）を使用
- [ ] キーワードの詰め込み（keyword stuffing）を避けている

**例:**
```
✅ 主要キーワード「React Hooks」の自然な使用:
「React Hooksは、関数コンポーネントで状態管理を行える機能です。
従来のクラスコンポーネントと比べて、Hooksを使うことでコードが
シンプルになります。」

❌ キーワード詰め込み:
「React HooksはReactの機能です。React Hooksを使えば
React Hooksで状態管理ができます。React Hooksは便利です。」
```

### 画像の最適化

- [ ] すべての画像にalt属性が設定されている
- [ ] alt属性に説明的なテキストとキーワードが含まれている
- [ ] 画像のファイル名が内容を表している
- [ ] 画像が適切なサイズに圧縮されている
- [ ] 画像フォーマットが適切（WebP推奨）

**例:**
```html
✅ <img src="react-hooks-useState-example.webp"
     alt="React HooksのuseStateを使ったカウンター実装例">
❌ <img src="image1.jpg" alt="画像">
```

### 内部リンク

- [ ] 関連する他の記事への内部リンクがある（3-5個推奨）
- [ ] アンカーテキストが説明的でキーワードを含む
- [ ] リンクが自然な文脈に配置されている
- [ ] 「こちら」「クリック」などの曖昧なアンカーテキストを避けている
- [ ] リンク切れがない

**例:**
```markdown
✅ さらに詳しくは[React カスタムフックの実践的な使い方](./custom-hooks)
   をご覧ください。
❌ 詳しくは[こちら](./custom-hooks)をクリックしてください。
```

### 外部リンク

- [ ] 信頼できる参照元への外部リンクがある
- [ ] 公式ドキュメントや権威あるサイトへのリンク
- [ ] 外部リンクに `rel="noopener noreferrer"` が設定されている
- [ ] リンク切れがない

**例:**
```markdown
✅ [React公式ドキュメント](https://react.dev/reference/react)によると...
```

## 2. テクニカルSEO

### ページ速度

- [ ] ページの読み込み時間が3秒以内
- [ ] First Contentful Paint (FCP) が2秒以内
- [ ] Largest Contentful Paint (LCP) が2.5秒以内
- [ ] Cumulative Layout Shift (CLS) が0.1以下
- [ ] 画像の遅延読み込み（lazy loading）を実装
- [ ] 不要なJavaScript/CSSを削減

**測定ツール:** PageSpeed Insights、Lighthouse

### モバイル対応

- [ ] レスポンシブデザインを実装
- [ ] モバイルフレンドリーテストに合格
- [ ] タップ可能な要素が適切なサイズ（最低48x48px）
- [ ] フォントサイズが読みやすい（最低16px）
- [ ] ビューポートが適切に設定されている

**例:**
```html
<meta name="viewport" content="width=device-width, initial-scale=1.0">
```

### HTTPS

- [ ] サイト全体がHTTPSで配信されている
- [ ] 混在コンテンツ（mixed content）がない
- [ ] SSL証明書が有効

### 構造化データ

- [ ] JSON-LD形式の構造化データを実装
- [ ] 記事（Article/TechArticle）スキーマを設定
- [ ] 構造化データテストツールでエラーがない
- [ ] 著者、公開日、更新日を含む

**例:**
```json
{
  "@context": "https://schema.org",
  "@type": "TechArticle",
  "headline": "React Hooks完全ガイド",
  "datePublished": "2024-01-15",
  "dateModified": "2025-10-20"
}
```

### XMLサイトマップ

- [ ] XMLサイトマップが存在する
- [ ] サイトマップがGoogle Search Consoleに送信されている
- [ ] すべての重要ページがサイトマップに含まれている

### Robots.txt

- [ ] robots.txtが適切に設定されている
- [ ] クロールさせたくないページを除外
- [ ] サイトマップへのリンクを記載

## 3. コンテンツ品質

### コンテンツの長さ

- [ ] テックブログ記事として十分な長さ（最低1,500文字推奨）
- [ ] トピックを網羅的にカバーしている
- [ ] 無駄な文章で長さを稼いでいない

### コンテンツの独自性

- [ ] オリジナルのコンテンツである（コピーコンテンツではない）
- [ ] 独自の視点や実践例がある
- [ ] 他の記事との差別化ポイントが明確

### 情報の正確性と最新性

- [ ] 技術情報が正確である
- [ ] 最新のバージョン情報を使用
- [ ] 非推奨のAPIや古い手法を避けている
- [ ] 公開日・最終更新日を明記

**例:**
```markdown
最終更新: 2025年10月20日
※本記事はReact 18.2を基に執筆しています
```

### 読みやすさ

- [ ] 1段落が3-5文程度で適度な長さ
- [ ] 専門用語には説明がある
- [ ] 箇条書きや表を活用して情報を整理（**重要: noteでは表は使用不可、箇条書きで代替**）
- [ ] 適切な改行と空白がある
- [ ] コードブロックがシンタックスハイライト付き

**例:**
```markdown
✅ React Hooksは、React 16.8で導入された新機能です。

従来のクラスコンポーネントでしか使えなかった状態管理や
ライフサイクル機能を、関数コンポーネントでも使えるように
なりました。

主なHooksには以下があります:
- useState: 状態管理
- useEffect: 副作用の処理
- useContext: コンテキストの利用

❌ React Hooksは、React 16.8で導入された新機能です。従来のクラスコンポーネントでしか使えなかった状態管理やライフサイクル機能を、関数コンポーネントでも使えるようになりました。主なHooksにはuseStateやuseEffect、useContextなどがあり...
```

### 検索意図の充足

- [ ] ユーザーの検索意図（情報、学習、問題解決）を満たしている
- [ ] 「何」「なぜ」「どうやって」に答えている
- [ ] よくある質問に先回りして答えている
- [ ] 実践的な例やコードサンプルがある

### コンテンツの網羅性

- [ ] トピックを段階的に説明（基礎→応用）
- [ ] 実装例が豊富（最低3-5個）
- [ ] トラブルシューティング情報がある
- [ ] FAQ または「よくある質問」セクションがある

## 4. ユーザーエクスペリエンス

### 目次

- [ ] 目次（Table of Contents）がある
- [ ] 目次から各セクションへジャンプできる
- [ ] 記事の構造が一目でわかる

**例:**
```markdown
## 目次
1. [React Hooksとは？](#what-is-react-hooks)
2. [useStateの使い方](#usestate)
3. [useEffectの使い方](#useeffect)
```

### 可読性

- [ ] フォントサイズが適切（本文16px以上）
- [ ] 行間が適切（line-height: 1.6-1.8推奨）
- [ ] 行の長さが適切（50-75文字/行）
- [ ] コントラスト比が十分（WCAG AAレベル以上）

### ナビゲーション

- [ ] パンくずリスト（breadcrumb）がある
- [ ] 関連記事セクションがある
- [ ] 前後の記事へのリンクがある
- [ ] SNSシェアボタンがある

**例:**
```markdown
ホーム > ブログ > React > React Hooks完全ガイド
```

### エンゲージメント

- [ ] コメント欄またはフィードバック機能がある
- [ ] SNSシェアボタンが設置されている
- [ ] ニュースレター登録などCTAがある
- [ ] 著者プロフィールがある

## 5. E-E-A-T（経験、専門性、権威性、信頼性）

### 経験 (Experience)

- [ ] 著者の実務経験が示されている
- [ ] 実際に試した結果や知見が含まれている
- [ ] 独自の視点やベストプラクティスがある

### 専門性 (Expertise)

- [ ] 技術的に正確な情報である
- [ ] 深い知識に基づいた説明がある
- [ ] 公式ドキュメントや権威ある情報源を参照

### 権威性 (Authoritativeness)

- [ ] 著者のプロフィールと実績を明記
- [ ] 他の専門家や公式情報源からの引用
- [ ] 業界で認められた情報源へのリンク

### 信頼性 (Trustworthiness)

- [ ] 連絡先情報が明記されている
- [ ] プライバシーポリシーが設置されている
- [ ] 誤情報の訂正プロセスがある
- [ ] 最終更新日が明記されている

## SEOスコア計算

各カテゴリの達成率を計算し、総合スコアを算出します:

```
オンページSEO: __% (__ / __ 項目)
テクニカルSEO: __% (__ / __ 項目)
コンテンツ品質: __% (__ / __ 項目)
ユーザーエクスペリエンス: __% (__ / __ 項目)
E-E-A-T: __% (__ / __ 項目)

総合SEOスコア: __/100
```

### スコアの評価基準

- **90-100点**: 優秀 - SEOベストプラクティスに完全準拠
- **75-89点**: 良好 - 高い品質だが改善の余地あり
- **60-74点**: 平均的 - 基本は押さえているが要改善
- **45-59点**: 要改善 - 重要な要素が欠けている
- **0-44点**: 不十分 - 大幅な見直しが必要

## 優先順位付け

すべての項目を一度に改善するのは困難です。以下の優先順位で取り組みましょう:

### 高優先度（即座に対応）

1. タイトルタグとメタディスクリプション
2. 見出し構造（H1-H6）
3. ページ速度
4. モバイル対応
5. HTTPS

### 中優先度（数週間以内）

6. キーワード最適化
7. コンテンツの質と長さ
8. 画像の最適化
9. 内部リンク
10. 構造化データ

### 低優先度（継続的に改善）

11. 外部リンクの充実
12. エンゲージメント機能
13. E-E-A-Tの強化
14. 細かなUX改善
