---
name: tech-reviewer
description: 技术卡片审核。验证问题卡片/知识卡片的准确性，查找资料核实，指出错误并提供改进建议。当用户说「review」「审核」「检查」技术文档时使用。适用于 tech/ 目录。
allowed-tools: Read, WebSearch, WebFetch, Edit, Glob, Grep
---

# 技术审核

适用范围：`tech/` 目录

## 卡片类型

| 类型 | frontmatter | 用途 |
|------|-------------|------|
| 问题卡片 | `type: problem` | 记录技术难点及解决方案 |
| 知识卡片 | `type: knowledge` | 记录学习到的知识点 |

## 审核流程

### 1. 读取卡片
识别 frontmatter 中的 `type` 字段。

### 2. 识别关键声明

**问题卡片检查**：
- 问题描述是否清晰
- 原因分析是否准确
- 解决方案是否可行
- 代码是否正确
- 是否有更优解

**知识卡片检查**：
- 概念定义是否准确
- 解释是否清晰
- 例子是否恰当
- 是否有常见误区

### 3. 查找验证资料
使用 WebSearch 搜索：官方文档、权威博客、社区讨论。

### 4. 输出审核报告

```markdown
## 审核报告

**卡片**：{路径}
**类型**：{问题/知识}卡片

### 检查结果

| 内容 | 状态 | 说明 |
|------|------|------|
| ... | ✓/✗/⚠ | ... |

### 发现的问题

#### 问题 1：{标题}
- **原文**：...
- **问题**：...
- **建议**：...
- **来源**：{URL}

### 改进建议

1. ...
2. ...

### 参考资料

- [来源](URL)
```

## 状态标记

| 标记 | 含义 |
|------|------|
| ✓ | 准确无误 |
| ✗ | 存在错误 |
| ⚠ | 需注意（可能过时或有争议） |

## 注意事项

- 基于证据，保持客观
- 区分「错误」和「有争议」
- 提供可验证的参考来源
- 只纠正事实问题，尊重写作风格
- 完成后提醒更新 `status: reviewed`

## 相关资源

→ `docs/references/tech/documentation-format.md`
