---
name: tech-video-metadata
description: 技術解説系YouTube動画のメタデータ(タイトル・概要欄・ハッシュタグ)を生成するスキル。プロスペクト理論を活かした損失回避の心理を使ったタイトル生成、見やすい概要欄(目次、タイムテーブル、SNSリンク含む)、体系的なハッシュタグ選定を実施。「YouTube用のタイトルを作成」「動画の概要欄を生成」などのリクエストで利用。
---

# Seriously Tech Video Metadata Creator

## 概要

このスキルは、技術解説系YouTube動画のメタデータ（タイトル・概要欄・ハッシュタグ）を生成します。プロスペクト理論に基づいた損失回避の心理を活用したタイトル、目次やタイムテーブル、SNSリンクを含む見やすい概要欄、そして体系的に選定されたハッシュタグを作成します。

## 使い方

このスキルはプラグインとして提供されており、特定のディレクトリ構造に依存しません。任意のプロジェクトで使用できます。

### 使用するタイミング

以下のようなリクエストがあった場合、このスキルを使用します:

- 「YouTube動画のタイトルを考えて」
- 「動画の概要欄を作成して」
- 「この記事をYouTube用にタイトルと概要欄を生成して」
- 「プロンプト改善についての動画タイトルが欲しい」
- 「記事URLからYouTube用のコンテンツを作成」

## クイックスタート

### 基本的な作成フロー

1. **コンテンツ分析**: プロンプトまたは記事URLから主要テーマとキーポイントを抽出
2. **タイトル生成**: プロスペクト理論を活用した複数のタイトル候補を作成
3. **概要欄作成**: 目次、タイムテーブル、SNSリンクを含む見やすい概要欄を生成
4. **ハッシュタグ生成**: 3つのカテゴリ（汎用系・トピック系・視聴者属性系）から10-15個を選定
5. **出力**: テキスト形式で出力

## 主な機能

### 1. タイトル生成

プロスペクト理論の損失回避の心理を活かしたタイトルを生成します。

**生成ポイント:**
- 損失回避フレーズの活用(「9割が知らない」「知らないと損する」など)
- 数字の活用(具体性の向上)
- ターゲット層の明確化
- ベネフィットの明示

**詳細:** `references/title-strategy.md` を参照

### 2. 概要欄生成

見やすく整理された概要欄を生成します。

**必須要素:**
- **目次(タイムテーブル)**: 各セクションの時間と内容
- **動画の説明**: 簡潔で魅力的な説明文
- **SNSリンク**: X.com、技術ブログなど
- **自己紹介**: 簡単なプロフィール

**詳細:** `references/description-template.md` を参照

### 3. ハッシュタグ生成

動画の検索性を高めるためのハッシュタグを体系的に生成します。

**ハッシュタグの分類:**
- **汎用系**: #エンジニア #プログラミング #IT業界
- **トピック系**: #ChatGPT #Claude #React など
- **視聴者属性系**: #駆け出しエンジニアと繋がりたい

**詳細:** `references/hashtag-strategy.md` を参照

### 4. 想定コメント・返信生成

動画公開後のエンゲージメント向上のため、視聴者からありそうなコメント5つと、それぞれに対する返信を生成します。

**詳細:** `references/comment-strategy.md` を参照

## 出力形式

### タイトル候補

6-8個のタイトル候補をリスト形式で出力

### 概要欄

完全な概要欄をテキスト形式で出力

### ハッシュタグ一覧

3つのカテゴリに分類してハッシュタグを提示（コピペ用一覧も含む）

### 想定コメント・返信

5つのコメントパターンと返信を生成

## リファレンスファイル

- `references/title-strategy.md`: タイトル生成戦略
- `references/description-template.md`: 概要欄テンプレート
- `references/content-analysis.md`: コンテンツ分析ガイド
- `references/hashtag-strategy.md`: ハッシュタグ戦略
- `references/comment-strategy.md`: コメント・返信戦略

## 補足

- タイトル推奨長さ: 50-60文字
- 概要欄推奨長さ: 500-1000文字
- ハッシュタグ: 10-15個
