# コンテンツ分析ガイド

## 概要

プロンプトや記事URLから、YouTube動画のタイトルと概要欄を生成するために必要な情報を抽出・分析するガイドです。

## 分析の目的

1. **メインテーマの特定**: 動画の核となるトピック
2. **サブトピックの抽出**: 具体的な内容、ポイント
3. **ターゲット視聴者の特定**: 誰に向けた動画か
4. **ベネフィットの言語化**: 視聴者が得られる価値
5. **キーワードの抽出**: SEO対策用

## 分析プロセス

### ステップ1: 入力内容の確認

#### 入力タイプの判別

1. **プロンプト(テキスト)**
   - ユーザーが直接記述したテーマや内容

2. **記事URL**
   - ブログ記事やWebページのURL
   - 記事内容を読み込んで分析

3. **マークダウンファイル**
   - ローカルのマークダウンファイル
   - 記事本文を読み込んで分析

### ステップ2: メインテーマの抽出

#### メインテーマのフォーマット

- **具体的**: 「プログラミング」→「React開発」
- **技術名**: 具体的なツール名・技術名
- **動詞形**: 「〜する方法」「〜のコツ」

### ステップ3: サブトピックの整理

#### 抽出基準

1. **数値化できるもの**
   - 「8つのコツ」「10のテクニック」

2. **段階的なもの**
   - 「初級→中級→上級」
   - 「基礎→応用→実践」

3. **カテゴリ分けできるもの**
   - 「設定→実装→最適化」

### ステップ4: ターゲット視聴者の特定

#### 視聴者レベルの判定

**初心者向け:**
- キーワード: 「初めて」「入門」「基礎」「ゼロから」

**中級者向け:**
- キーワード: 「効率化」「実践」「応用」「現場」

**上級者向け:**
- キーワード: 「最適化」「高度な」「アーキテクチャ」

### ステップ5: ベネフィットの言語化

#### ベネフィットの種類

1. **スキル向上系**: 「〜ができるようになる」
2. **効率化系**: 「作業時間が〇〇短縮」
3. **差別化系**: 「周りに差をつける」
4. **問題解決系**: 「〜の悩みが解決」
5. **知識獲得系**: 「〜がわかる」

### ステップ6: キーワードの抽出

#### キーワードの種類

1. **主要キーワード** (1-2個): メインテーマに直結
2. **関連キーワード** (3-5個): サブトピックに関連
3. **ロングテールキーワード** (2-3個): 具体的なフレーズ

## 分析結果のまとめ方

### フォーマット

```markdown
## コンテンツ分析結果

### メインテーマ
[抽出したメインテーマ]

### サブトピック(数)
1. [サブトピック1]
2. [サブトピック2]
...

### ターゲット視聴者
- レベル: [初心者/中級者/上級者]
- 職種: [エンジニア/データサイエンティスト等]

### 主要ベネフィット
1. [ベネフィット1]
2. [ベネフィット2]
3. [ベネフィット3]

### キーワード
- 主要: [キーワード1], [キーワード2]
- 関連: [キーワード3], [キーワード4], [キーワード5]
- ロングテール: [フレーズ1], [フレーズ2]
```

## 分析チェックリスト

### 必須項目

- [ ] メインテーマが特定できたか
- [ ] サブトピックの数がわかるか
- [ ] ターゲット視聴者が明確か
- [ ] ベネフィットが3つ以上あるか
- [ ] 主要キーワードが抽出できたか

### 推奨項目

- [ ] 具体的なツール名・技術名があるか
- [ ] 数値化できる要素があるか
- [ ] 実践的な内容が含まれるか
- [ ] 競合動画との差別化ポイントがあるか
