# 概要欄テンプレート

## 基本構成

YouTube動画の概要欄は以下の順序で構成します:

```
1. 冒頭の引き込み文 (2-3行)
2. この動画で学べること (箇条書き)
3. 目次(タイムテーブル)
4. 自己紹介・SNSリンク
5. ハッシュタグ(オプション)
```

## 1. 冒頭の引き込み文

### 重要性

概要欄の最初の2-3行は、検索結果やサムネイル下に表示されるため、視聴者を引き込む最重要部分です。

### テンプレート

```
[テーマ]について[具体的な内容]を[数字]つ紹介!
[ツール名/技術名]を使いこなすための[ベネフィット]を
[特徴]で徹底解説します。
```

## 2. この動画で学べること

### フォーマット

```
📌 この動画で学べること
・[ポイント1]
・[ポイント2]
・[ポイント3]
・[ポイント4]
・[ポイント5]
```

### ポイント

- **箇条書き**: 「・」または「-」を使用
- **数**: 3-6項目程度
- **具体性**: 抽象的ではなく具体的に
- **ベネフィット**: 「〜を学べる」「〜ができるようになる」

## 3. 目次(タイムテーブル)

### フォーマット

```
⏱️ 目次(タイムテーブル)
00:00 [セクション名]
02:15 [セクション名]
05:30 [セクション名]
...
```

### ポイント

- **タイムスタンプ**: `mm:ss` または `hh:mm:ss` 形式
- **間隔**: 2-5分ごとが目安
- **セクション数**: 5-15個程度
- **命名**: 簡潔で内容がわかりやすい

## 4. 自己紹介・SNSリンク

### 固定フォーマット

```
👨🏻‍💻 masayan.dev1126
大阪でシニアエンジニアしています。

🌏 SNS
X.com: x.com/masayanishigaki?s=21&t=2LPYmlHxHYyad2B5DY1j9Q

📓 技術ブログ
https://maasaablog.com/
```

## 5. ハッシュタグ(オプション)

### フォーマット

```
#プロンプトエンジニアリング #ChatGPT #AI活用 #エンジニア #プログラミング
```

## 完全な概要欄の例

```
AI時代に取り残されないためのプロンプト改善術を8つ紹介!
ChatGPT・Claude・Geminiを使いこなすための必須テクニックを
実践例付きで徹底解説します。

📌 この動画で学べること
・プロンプトエンジニアリングの基礎知識
・AI活用で周りに差をつける8つのコツ
・実践的なプロンプト改善テクニック
・作業効率を10倍にする活用術
・ChatGPT・Claude・Geminiの使い分け

⏱️ 目次(タイムテーブル)
00:00 イントロダクション
02:15 プロンプト改善が必要な理由
05:30 コツ1: 具体性を高める
08:45 コツ2: コンテキストを与える
12:20 コツ3: 役割を明確にする
15:10 コツ4: 出力形式を指定する
18:30 コツ5: ステップバイステップで指示
21:45 コツ6: 例を示す
25:00 コツ7: 制約条件を明示
28:15 コツ8: 反復改善のテクニック
31:30 実践例: ChatGPTでのデモ
35:00 まとめと次のステップ

👨🏻‍💻 masayan.dev1126
大阪でシニアエンジニアしています。

🌏 SNS
X.com: x.com/masayanishigaki?s=21&t=2LPYmlHxHYyad2B5DY1j9Q

📓 技術ブログ
https://maasaablog.com/

#プロンプトエンジニアリング #ChatGPT #AI活用 #生産性向上
```

## 絵文字の使い方

### 推奨絵文字

- **📌** : 重要ポイント、学べること
- **⏱️** : 目次、タイムテーブル
- **👨🏻‍💻** : 自己紹介
- **🌏** : SNS
- **📓** : ブログ、技術記事
- **🔗** : リンク
- **✅** : チェックリスト、完了
- **📚** : 参考資料、リソース

## 概要欄の長さ

### 推奨

- **最小**: 300文字以上
- **理想**: 500-1000文字
- **最大**: 5000文字(YouTubeの上限)

## ベストプラクティス

### DO ✅

- 最初の2-3行に最も重要な情報を配置
- タイムスタンプを正確に記載
- 関連リンクは信頼できるものだけ
- 読みやすい改行と箇条書き

### DON'T ❌

- 誇大広告や虚偽の情報
- スパム的なキーワード羅列
- 過度な絵文字使用
- 長すぎる説明(読まれない)
