# ハッシュタグ戦略

YouTube動画の検索性を高めるためのハッシュタグ選定戦略をまとめたリファレンスです。

## ハッシュタグの役割

- **検索性向上**: 動画が検索結果に表示されやすくなる
- **関連動画表示**: 類似コンテンツと関連付けられる
- **視聴者ターゲティング**: 特定の視聴者層にリーチできる
- **トレンド対応**: 話題のトピックに乗ることができる

## ハッシュタグの分類

### 1. 汎用系（必須）

どの動画にも適用できる基本的なハッシュタグ。必ず3個程度含めること。

**推奨ハッシュタグ:**
- #エンジニア
- #プログラミング
- #IT業界
- #技術解説
- #テック系YouTuber

### 2. トピック系（動画内容に応じて）

動画の具体的なテーマに関連するハッシュタグ。5-8個選定すること。

#### AI関連
- #chatgpt
- #openai
- #claude
- #gemini
- #生成ai
- #llm
- #機械学習
- #プロンプトエンジニアリング
- #ai開発

#### プログラミング言語・フレームワーク
- #javascript
- #typescript
- #python
- #react
- #nextjs

#### ツール・プラットフォーム
- #github
- #google
- #microsoft
- #vscode
- #docker
- #mcp

### 3. 視聴者属性系

ターゲット視聴者層を明確にするハッシュタグ。2-4個選定すること。

**推奨ハッシュタグ:**
- #駆け出しエンジニアと繋がりたい
- #エンジニアと繋がりたい
- #フルスタックエンジニア
- #フロントエンドエンジニア
- #シニアエンジニア

## ハッシュタグ選定ルール

### 数の最適化

- **合計**: 10-15個
- **配分**: 汎用3個 + トピック5-8個 + 視聴者属性2-4個

### 表記ルール

- **小文字使用**: 全てのハッシュタグは小文字で表記すること
- **理由**: YouTubeでは小文字のハッシュタグが推奨される

### 優先順位

1. **関連性**: 動画内容に最も関連性の高いものを優先
2. **検索性**: よく検索されるキーワードを選ぶ
3. **競合**: 適度な競合があるキーワード
4. **トレンド**: 時事的なトピックは関連ハッシュタグを追加

## NG例とOK例

### ❌ NG例

**問題点: ハッシュタグが多すぎる（20個以上）**

**問題点: 関連性が低い**
```
#エンジニア #料理 #旅行 #ファッション #美容
```

### ✅ OK例

**例1: プロンプトエンジニアリング動画**
```
#エンジニア #プログラミング #it業界 #chatgpt #claude #gemini #プロンプトエンジニアリング #生成ai #ai開発 #駆け出しエンジニアと繋がりたい #エンジニアと繋がりたい
```
- 合計: 11個
- 配分: 汎用3個 + トピック6個 + 視聴者属性2個
- 全て小文字で統一

## 出力フォーマット

### カテゴリ別表示

```
## 🏷️ ハッシュタグ

**汎用系:**
#エンジニア #プログラミング #it業界

**トピック系:**
#chatgpt #claude #gemini #プロンプトエンジニアリング #生成ai #ai開発

**視聴者属性系:**
#駆け出しエンジニアと繋がりたい #エンジニアと繋がりたい
```

### コピペ用一覧

```
**推奨ハッシュタグ（コピペ用）:**
#エンジニア #プログラミング #it業界 #chatgpt #claude #gemini #プロンプトエンジニアリング #生成ai #ai開発 #駆け出しエンジニアと繋がりたい #エンジニアと繋がりたい
```

## まとめ

効果的なハッシュタグ戦略のチェックリスト:

- [ ] 合計10-15個
- [ ] 汎用系3個 + トピック系5-8個 + 視聴者属性系2-4個
- [ ] **全て小文字で表記**
- [ ] 動画内容と完全に一致
- [ ] 検索されやすいキーワードを選定
- [ ] スパム的な印象を与えない
- [ ] 概要欄の最後に配置
- [ ] コピペしやすい形式で提供
