# タイトル生成戦略

## プロスペクト理論の活用

プロスペクト理論は、人間が利益を得ることよりも損失を避けることを重視する心理を説明する理論です。YouTube動画タイトルにこの理論を活用することで、クリック率を向上させることができます。

## 損失回避フレーズ集

### 高効果フレーズ(適度なバランス)

1. **知識の欠落を指摘**
   - 「9割が知らない〇〇」
   - 「意外と知らない△△」
   - 「みんな知らない〇〇の真実」

2. **取り残される不安**
   - 「もう遅れをとるな」
   - 「知らないと取り残される」
   - 「周りに差をつける」
   - 「時代に乗り遅れない」

3. **損失の明示**
   - 「知らないと損する」
   - 「もったいない使い方してない?」
   - 「見逃すと後悔する」

4. **差別化の強調**
   - 「同じツールなのに結果が違う理由」
   - 「なぜあの人は〇〇が上手い?」
   - 「差がつく△△のコツ」

### NG フレーズ(露骨すぎる)

❌ 避けるべき表現:
- 「絶対に見ないと後悔します!!!」
- 「これを知らないとヤバい」
- 「人生が変わる〇〇」(誇張しすぎ)
- 「【超重要】【必見】【緊急】」(装飾過多)

## 効果的なタイトルパターン

### パターン1: 損失回避 + 具体的数字 + ベネフィット

```
テンプレート:
「[損失回避フレーズ]！[テーマ]で差がつく[数字]つの[コツ/方法]｜[ベネフィット]」

例:
「もう遅れをとるな！AI時代で差がつく8つのコツ｜周りに差をつける最新テクニック」
```

### パターン2: 問いかけ + 理由の提示 + 解決策

```
テンプレート:
「なぜ[疑問]？[理由/原因]｜[解決策・ベネフィット]」

例:
「なぜあの人のAI活用は上手い？プロンプト改善8つの秘訣｜遅れをとらないための必須スキル」
```

### パターン3: 状況の対比 + 改善方法

```
テンプレート:
「[現状の問題]｜[改善方法]で[ベネフィット]」

例:
「AI使いこなせてる？プロンプト8つの改善術で周りに差をつける｜知らないと損するテクニック集」
```

### パターン4: ツール名明示 + 実用性強調

```
テンプレート:
「[具体的ツール名]｜使い方で差がつく[数字]つの[テクニック/コツ]｜[ベネフィット]」

例:
「ChatGPT・Claude・Gemini｜使い方で差がつく8つのプロンプトテクニック｜今すぐ実践できる改善術」
```

## タイトル要素の組み合わせ

### 必須要素

1. **損失回避フレーズ** (1つ)
2. **具体的数字** (1-2個)
3. **メインテーマ** (明確に)

### 推奨要素

4. **ベネフィット** (1-2個)
5. **ターゲット明示** (必要に応じて)
6. **具体性** (ツール名など)

## タイトル長さのガイドライン

### 理想的な長さ

- **推奨**: 50-60文字
- **最大**: 100文字(それ以上は「...」で省略される)
- **モバイル**: 約40文字まで表示

## 数字の使い方

### 効果的な数字

1. **小さめの数字 (3-10)**: 「8つのコツ」「5つの方法」
2. **倍数表現**: 「10倍アップ」「3倍速く」
3. **割合**: 「9割が知らない」「80%が間違える」

### 避けるべき数字

❌ 大きすぎる数字: 「100個のテクニック」
❌ 中途半端な数字: 「17個のコツ」

## 絵文字の使用

### 効果的な絵文字

✅ 推奨:
- 「｜」セパレーター: タイトルの区切りに使用
- 「【】」: 重要ポイントの強調(1箇所のみ)

❌ 避ける:
- 複数の絵文字を連続使用
- 派手すぎる装飾

## タイトル生成のチェックリスト

### 必須チェック項目

- [ ] 損失回避フレーズが含まれているか
- [ ] 具体的な数字が入っているか
- [ ] メインテーマが明確か
- [ ] 50-60文字程度に収まっているか
- [ ] ベネフィットが伝わるか

### 品質チェック項目

- [ ] 露骨すぎる煽り表現になっていないか
- [ ] ターゲット視聴者が明確か
- [ ] 他の動画と差別化できているか
- [ ] クリックしたくなる魅力があるか
- [ ] 内容と乖離していないか

## タイトル候補の出力数

**推奨: 6-8個**

理由:
- 複数の選択肢から選べる
- 異なるアプローチを提示できる
- ユーザーの好みに合わせられる
