# Meta Tag Guidelines

## Meta Title

### Formula
`[Primary Keyword] | [Brand] - [Benefit/Location]`

### Rules
- Length: 50-60 characters (Google truncates at ~60)
- Include primary keyword near the beginning
- Include brand name
- Make it compelling/clickable

### Examples

**Good:**
- `Webdesign Zürich | Local Studios - Ab CHF 100/mo`
- `Preise | Local Studios - Transparente Webdesign Kosten`
- `Beauty Salon Zürich | Glow Studio - Termine Online`

**Bad:**
- `Home` (no keyword, no brand)
- `Willkommen auf unserer Website | Firma GmbH | Beste Qualität | Günstig` (too long)

## Meta Description

### Formula
`[What you offer] + [Unique value] + [CTA]`

### Rules
- Length: 150-160 characters
- Include primary keyword naturally
- Include a call-to-action
- Make it compelling - this is your ad copy

### Examples

**Good:**
- `Professionelles Webdesign in Zürich ab CHF 100/mo. Handcodierte, blitzschnelle Websites. Jetzt unverbindlich anfragen.` (147 chars)
- `Entspannen Sie bei Glow Studio in Zürich. Facials, Massagen & Beauty-Treatments. Termin online buchen.` (102 chars)

**Bad:**
- `Wir sind eine Webdesign Agentur.` (too short, no CTA)
- Description over 160 characters (gets truncated)

## H1 Tag

### Rules
- Exactly ONE H1 per page
- Contains primary keyword
- Different from meta title (but related)
- Describes the page content

### Examples

| Page | Meta Title | H1 |
|------|------------|-----|
| Homepage | Webdesign Zürich \| Local Studios | Professionelle Websites für KMUs in Zürich |
| Pricing | Preise \| Local Studios | Transparente Webdesign Preise |
| Contact | Kontakt \| Local Studios | Lassen Sie uns sprechen |

## Checklist Per Page

- [ ] Meta title: 50-60 chars, keyword + brand
- [ ] Meta description: 150-160 chars, keyword + CTA
- [ ] H1: One per page, contains keyword
- [ ] H2s: Section headings, semantic structure
- [ ] Image alt texts: Descriptive, include keywords where natural
- [ ] Internal links: Link to related pages
- [ ] Canonical URL: Set if needed
