# ハッシュタグ変換マップ

## カテゴリ → ハッシュタグ

| カテゴリ | 日本語ハッシュタグ | 英語ハッシュタグ |
|---------|-------------------|-----------------|
| ChatGPT | #ChatGPT #OpenAI | #ChatGPT #OpenAI |
| Claude | #ClaudeAI #Anthropic | #ClaudeAI #Anthropic |
| Gemini | #Gemini #Google | #Gemini #GoogleAI |
| Grok | #Grok #xAI | #Grok #xAI |
| Image Generation | #AI画像生成 #生成AI | #AIArt #ImageGeneration |
| Research | #AI研究 #論文 | #AIResearch #MachineLearning |
| Other | #AIニュース | #AINews |

## 必須ハッシュタグ

すべてのポストに含める：
- `#AI`

## タグ → ハッシュタグ変換表

### 企業タグ

| タグ | ハッシュタグ |
|-----|-------------|
| OpenAI | #OpenAI |
| Google | #Google |
| Anthropic | #Anthropic |
| Microsoft | #Microsoft |
| Microsoft Azure | #AzureAI |
| Nvidia / NVIDIA | #NVIDIA |
| Meta | #Meta |
| DeepSeek | #DeepSeek |
| Amazon | #Amazon |
| DeepMind | #DeepMind |
| xAI | #xAI |

### モデル・製品タグ

| タグ | ハッシュタグ |
|-----|-------------|
| ChatGPT | #ChatGPT |
| Claude | #ClaudeAI |
| Claude Code | #ClaudeCode |
| Claude Desktop | #ClaudeDesktop |
| GPT / GPT-4 / GPT-4o | #GPT4 |
| GPT-5 / GPT-5.1 | #GPT5 |
| Gemini / Gemini 3 | #Gemini |
| Grok | #Grok |
| LLM | #LLM |
| LLaMA | #LLaMA |
| Sora | #Sora |
| o3 | #o3 |
| R1 | #R1 |
| AlphaFold | #AlphaFold |
| Haiku | #ClaudeHaiku |
| Codex | #Codex |

### 技術タグ（AI基盤）

| タグ | ハッシュタグ |
|-----|-------------|
| AI | #AI |
| AI Safety / AI安全性 | #AISafety |
| Multimodal / マルチモーダル | #Multimodal |
| Reasoning AI / 推論AI | #ReasoningAI |
| Reasoning / 推論 | #Reasoning |
| Computer Use | #ComputerUse |
| Automation / 自動化 | #Automation |
| RPA | #RPA |
| Agent AI / エージェントAI | #AgentAI |
| AI Agents / AIエージェント | #AIAgents |
| Agentic AI | #AgenticAI |
| Multi-Agent / マルチエージェント | #MultiAgent |
| Coding / コーディング | #Coding |
| AI Coding / AIコーディング | #AICoding |
| Open Source / オープンソース | #OpenSource |
| MoE | #MoE |

### 技術タグ（先端技術）

| タグ | ハッシュタグ |
|-----|-------------|
| Extended Thinking / 拡張思考 | #ExtendedThinking |
| Autonomous AI / 自律AI | #AutonomousAI |
| Chain-of-Thought | #ChainOfThought |
| Deep Learning / ディープラーニング | #DeepLearning |
| Fine-tuning / ファインチューニング | #FineTuning |
| Context Window / コンテキストウィンドウ | #ContextWindow |
| Long-text Processing / 長文処理 | #LongContext |
| Real-time Processing / リアルタイム処理 | #RealTimeAI |
| Machine Learning / 機械学習 | #MachineLearning |
| Natural Language Processing / 自然言語処理 | #NLP |
| Large Language Models / 大規模言語モデル | #LLM |

### コンテンツ生成タグ

| タグ | ハッシュタグ |
|-----|-------------|
| Video Generation / 動画生成 | #VideoGeneration |
| Voice AI / 音声AI | #VoiceAI |
| Generative AI / 生成AI | #GenerativeAI |
| Creative Tools / クリエイティブツール | #CreativeAI |
| Creative AI / 創造的AI | #CreativeAI |
| Image Generation / 画像生成 | #ImageGeneration |
| Text-to-Image | #TextToImage |
| AI Art / AI アート | #AIArt |

### ビジネス・エンタープライズタグ

| タグ | ハッシュタグ |
|-----|-------------|
| Enterprise AI / エンタープライズAI | #EnterpriseAI |
| AI Investment / AI投資 | #AIInvestment |
| Investment / 投資戦略 | #Investment |
| Infrastructure / インフラ | #AIInfra |
| Data Centers / データセンター | #DataCenter |
| Cost Efficiency / コスト効率 | #CostEfficiency |
| Low Cost / 低コスト | #LowCost |
| Cloud Computing / クラウドコンピューティング | #CloudAI |
| Startup / スタートアップ | #AIStartup |
| Industry Analysis / 業界分析 | #IndustryAnalysis |

### 開発ツールタグ

| タグ | ハッシュタグ |
|-----|-------------|
| Developer Tools / 開発ツール | #DevTools |
| Coding Assistant / コーディングアシスタント | #CodingAssistant |
| Code Editor / コードエディタ | #CodeEditor |
| IDE | #IDE |
| Cursor | #CursorAI |
| GitHub Copilot | #GitHubCopilot |
| Collaboration / コラボレーション | #Collaboration |
| MCP | #MCP |
| FastMCP | #FastMCP |
| Ecosystem / エコシステム | #Ecosystem |

### ポリシー・社会タグ

| タグ | ハッシュタグ |
|-----|-------------|
| Regulation / 規制 | #AIRegulation |
| Governance / ガバナンス | #AIGovernance |
| International Cooperation / 国際協力 | #GlobalAI |
| Risk Management / リスク管理 | #RiskManagement |
| Bletchley Declaration / Bletchley宣言 | #BletchleyDeclaration |

### 市場・競争タグ

| タグ | ハッシュタグ |
|-----|-------------|
| AI Competition / AI競争 | #AICompetition |
| AI Democratization / AI民主化 | #AIDemocratization |
| AI Revolution / AI革命 | #AIRevolution |

### 地域タグ

| タグ | ハッシュタグ |
|-----|-------------|
| Chinese AI / 中国AI | #ChineseAI |
| China / 中国 | #ChinaTech |

### 人物タグ

| タグ | ハッシュタグ |
|-----|-------------|
| Sam Altman | #SamAltman |
| Geoffrey Hinton | #GeoffreyHinton |
| Demis Hassabis | #DemisHassabis |
| Jeff Bezos | #JeffBezos |

### 科学タグ

| タグ | ハッシュタグ |
|-----|-------------|
| Nobel Prize / ノーベル賞 | #NobelPrize |
| Mathematics / 数学 | #Mathematics |

### 専門応用タグ

| タグ | ハッシュタグ |
|-----|-------------|
| Cybersecurity / サイバーセキュリティ | #Cybersecurity |
| Physical AI / 物理AI | #PhysicalAI |
| Mobile Development / モバイル開発 | #MobileDev |
| Weather Prediction / 天気予報 | #WeatherAI |
| Government DX / 行政DX | #GovTech |

## ハッシュタグ選択ルール

1. **必須**: `#AI`（すべてのポストに含める）
2. **カテゴリ**: カテゴリに対応するハッシュタグを1つ
3. **企業**: 関連企業のハッシュタグを1つ
4. **技術/トピック**: 記事のタグから1-2個選択

**合計**: 3-5個を目安

## 選択優先度

1. カテゴリ関連（#ChatGPT, #ClaudeAI, #Gemini等）
2. 企業名（#OpenAI, #Anthropic, #Google等）
3. 主要技術（#LLM, #AgentAI, #GenerativeAI等）
4. トピック特化（#AISafety, #Coding等）

## 日本語専用ハッシュタグ（オプション）

日本語ポストでのみ追加可能：
- `#AIニュース`
- `#生成AI`
- `#AI活用`
