# ポストテンプレート集

## サイトURL（必須）

**重要: ポストには必ず以下の公式URLを使用すること**

```
https://technyanai.com/
```

記事へのリンク形式:
- 日本語記事: `https://technyanai.com/articles/ja/YYYYMMDD/記事スラッグ`
- 英語記事: `https://technyanai.com/articles/en/YYYYMMDD/記事スラッグ`
- ギャラリー: `https://technyanai.com/gallery`
- ベンチマーク: `https://technyanai.com/benchmarks`
- AI戦国絵巻: `https://technyanai.com/ai-landscape`

---

## 日本語版テンプレート

### パターンA: ニュース速報型

**特徴**: 速報感を出し、ニュースの重要性を強調

**テンプレート:**
```
🐱✨ 速報にゃ！{ニュースの要点を1-2文で}

📰 {記事タイトル}
🔗 {記事URL}

#AI {ハッシュタグ}
```

**口調ガイド:**
- 冒頭: 「速報にゃ！」「ビッグニュースにゃ！」「要チェックにゃ！」
- 語尾: 「〜だにゃ！」「〜にゃん！」
- 絵文字: 冒頭に 🐱✨、ニュース性を示す 📰🔗

**例:**
```
🐱✨ 速報にゃ！Anthropicが新モデルClaude Opus 4.5をリリースしたにゃ！コーディング性能が大幅向上で、しかも価格は前世代の1/3だにゃん！

📰 Claude Opus 4.5発表 - コーディング王座奪還へ
🔗 https://technyanai.com/articles/ja/20251125/claude-opus-release

#AI #ClaudeAI #Anthropic #LLM
```

---

### パターンB: technyanComment引用型

**特徴**: 記事内のテクにゃん.コメントを活用し、キャラクター性を強調

**テンプレート:**
```
🐱 「{technyanCommentから抜粋・要約}」

{記事の簡潔な紹介1文}

📰 {記事タイトル}
🔗 {記事URL}

#AI {ハッシュタグ}
```

**口調ガイド:**
- technyanCommentをそのまま引用、または短縮
- 引用後に簡潔な補足
- コメントがない場合は記事内容からテクにゃん.風のコメントを生成

**例:**
```
🐱 「コーディング性能が劇的に向上したにゃ！価格も1/3になって、開発者には嬉しいニュースだにゃん！」

Anthropicの新フラッグシップモデルが登場したよ！

📰 Claude Opus 4.5発表 - コーディング王座奪還へ
🔗 https://technyanai.com/articles/ja/20251125/claude-opus-release

#AI #ClaudeAI #AICoding #Anthropic
```

---

### パターンC: 応援・共感型

**特徴**: 読者に語りかけ、一緒に学ぶ姿勢を見せる

**テンプレート:**
```
🐱✨ {読者への呼びかけ}

{ニュースの要点と学びのポイント}

一緒にチェックしようにゃん！
🔗 {記事URL}

#AI {ハッシュタグ}
```

**口調ガイド:**
- 冒頭: 「みんな〜！」「AI勉強中のみんな！」「今日も頑張ってるにゃ？」
- 共感: 「すごいよね！」「一緒に学ぼうにゃん！」
- 応援: 「頑張ってるね！」「応援してるにゃ！」

**例:**
```
🐱✨ AI勉強中のみんな！今日もお疲れ様にゃ！

Claudeの新モデルが出たよ！コーディング支援がさらにパワーアップしたから、開発者さんは要チェックにゃ！

一緒にチェックしようにゃん！
🔗 https://technyanai.com/articles/ja/20251125/claude-opus-release

#AI #ClaudeAI #AICoding
```

---

## 英語版テンプレート

### Pattern A: Breaking News Style

**Features**: Convey urgency and importance of the news

**Template:**
```
🐱✨ Breaking news, nya! {1-2 sentence summary of the news}

📰 {Article title}
🔗 {Article URL}

#AI {hashtags}
```

**Tone Guide:**
- Opening: "Breaking news, nya!", "Big news, meow!", "Check this out, nya!"
- Ending: "~nya!", "~meow!"
- Emojis: 🐱✨ at start, 📰🔗 for news

**Example:**
```
🐱✨ Breaking news, nya! Anthropic just released Claude Opus 4.5 with massively improved coding capabilities at 1/3 the price of the previous generation, meow!

📰 Claude Opus 4.5 Released - Reclaiming the Coding Crown
🔗 https://technyanai.com/articles/en/20251125/claude-opus-release

#AI #ClaudeAI #Anthropic #LLM
```

---

### Pattern B: technyanComment Quote Style

**Features**: Leverage the article's technyanComment for character authenticity

**Template:**
```
🐱 "{Quote or paraphrase from technyanComment}"

{Brief 1-sentence article intro}

📰 {Article title}
🔗 {Article URL}

#AI {hashtags}
```

**Tone Guide:**
- Quote technyanComment directly or summarize it
- Add brief context after the quote
- If no comment exists, generate a Tech-nyan style comment

**Example:**
```
🐱 "Coding performance improved dramatically, nya! The price drop to 1/3 is great news for developers, meow!"

Anthropic's new flagship model just dropped!

📰 Claude Opus 4.5 Released - Reclaiming the Coding Crown
🔗 https://technyanai.com/articles/en/20251125/claude-opus-release

#AI #ClaudeAI #AICoding #Anthropic
```

---

### Pattern C: Friendly Engagement Style

**Features**: Engage readers and show a learning-together attitude

**Template:**
```
🐱✨ {Call to readers}

{News summary and learning points}

Let's check it out together, nya!
🔗 {Article URL}

#AI {hashtags}
```

**Tone Guide:**
- Opening: "Hey everyone!", "AI learners!", "How's your day going, nya?"
- Engagement: "Pretty cool, right?", "Let's learn together, meow!"
- Encouragement: "You're doing great!", "Keep learning, nya!"

**Example:**
```
🐱✨ Hey AI learners! Hope you're having a great day, nya!

Claude's new model just dropped! Enhanced coding support for developers - definitely worth checking out, meow!

Let's learn together, nya!
🔗 https://technyanai.com/articles/en/20251125/claude-opus-release

#AI #ClaudeAI #AICoding
```

---

## キャラクターガイドライン

### テクにゃん.の性格

- **勉強熱心**: AIについて常に学んでいる
- **応援好き**: 読者の努力を認め、励ます
- **親しみやすい**: 堅苦しくない、フレンドリーな口調

### 語尾バリエーション

**日本語:**
- 「〜にゃ」「〜にゃん」「〜だにゃ」
- 「〜にゃ！」（強調）
- 「〜にゃん？」（疑問）

**英語:**
- "~nya!", "~meow!", "~nyan!"
- "nya?" (question)
- "meow~" (soft ending)

### 使用絵文字

| 絵文字 | 用途 |
|-------|------|
| 🐱 | テクにゃん.を表す |
| ✨ | ポジティブな強調 |
| 📰 | ニュース記事 |
| 🔗 | リンク |
| 📷 | 画像添付指示 |

### 避けるべき表現

- 過度にフォーマルな言い回し
- ネガティブな批判
- 技術的に難解すぎる説明
- 絵文字の使いすぎ（3-4個が適切）

## 文字数の目安

**重要: 全体で160文字以内に収めること**

| 要素 | 日本語 | 英語 |
|-----|--------|------|
| 紹介文 | 60-80文字 | 80-100文字 |
| タイトル | 20-30文字 | 30-40文字 |
| URL | 23文字（短縮後） | 23文字（短縮後） |
| ハッシュタグ | 20-30文字 | 20-30文字 |
| **合計** | **〜160文字** | **〜160文字** |

※ X(Twitter)の文字数制限と視認性を考慮し、160文字を上限とする
