# X Post Generator ワークフロー

## 実行手順

### Step 1: 記事ファイルの読み込み

指定されたパスから記事を読み込み、ペアとなる言語ファイルも取得する。

```
入力: src/content/articles/20251125/article-slug/ja.md
↓
読み込み:
  - ja.md（日本語版）
  - en.md（英語版）
```

### Step 2: Frontmatterの抽出

以下のフィールドを抽出：

| フィールド | 用途 |
|-----------|------|
| `title` | ポストのタイトル部分 |
| `description` | 紹介文の参考 |
| `date` | URL構築（YYYYMMDD形式） |
| `category` | カテゴリハッシュタグ |
| `tags` | ハッシュタグ変換 |
| `technyanComment` | パターンBで引用 |

### Step 3: ハッシュタグ変換

1. カテゴリからメインハッシュタグを決定
2. タグ配列から3-4個を選択（[HASHTAG_MAP.md](./HASHTAG_MAP.md)参照）
3. 必須タグ `#AI` を追加

**優先順位:**
1. カテゴリ関連タグ（#ChatGPT, #ClaudeAI, #Gemini等）
2. 会社タグ（#OpenAI, #Anthropic, #Google等）
3. 技術タグ（#LLM, #AgentAI等）

### Step 4: 記事URLの構築

```
日本語版: https://technyanai.com/articles/ja/{date}/{slug}
英語版:   https://technyanai.com/articles/en/{date}/{slug}
```

**例:**
- `src/content/articles/20251125/claude-opus-release/ja.md`
- → `https://technyanai.com/articles/ja/20251125/claude-opus-release`

### Step 5: OGP画像パスの提示

```
OGP画像URL: https://technyanai.com/api/og?title={encoded_title}&type=article
```

※ 実際の投稿時にはブラウザでページを開いてスクリーンショットを撮るか、OGP画像を直接ダウンロードして添付

### Step 6: ポスト案の生成

[TEMPLATES.md](./TEMPLATES.md)を参照し、以下の3パターンを生成：

**日本語版:**
- パターンA: ニュース速報型
- パターンB: technyanComment引用型
- パターンC: 応援・共感型

**英語版:**
- Pattern A: Breaking News style
- Pattern B: technyanComment quote style
- Pattern C: Friendly engagement style

### Step 7: 文字数チェック

各ポストが以下の制限内か確認：

| 項目 | 制限 |
|-----|-----|
| 総文字数 | 280文字以内 |
| 紹介文（日本語） | 100-120文字 |
| 紹介文（英語） | 150-200文字 |
| ハッシュタグ | 3-5個 |

### Step 8: 出力フォーマット

```markdown
## 日本語版ポスト案

### パターンA（ニュース速報型）
[ポスト本文]

📷 添付: OGP画像
文字数: XXX文字

### パターンB（technyanComment引用型）
[ポスト本文]

📷 添付: OGP画像
文字数: XXX文字

### パターンC（応援・共感型）
[ポスト本文]

📷 添付: OGP画像
文字数: XXX文字

---

## English Post Drafts

### Pattern A (Breaking News)
[Post content]

📷 Attachment: OGP image
Characters: XXX

### Pattern B (technyanComment Quote)
[Post content]

📷 Attachment: OGP image
Characters: XXX

### Pattern C (Friendly Engagement)
[Post content]

📷 Attachment: OGP image
Characters: XXX
```

## 注意事項

- `technyanComment`がない場合、パターンBは説明文を元に生成
- 日本語の文字数カウントは全角1文字=2としてカウント
- URLはXにより約23文字に短縮されるため、実質的な余裕あり
