---
name: template-miner
description: 過去資料からテンプレ・スタイルガイド・チェックリストを抽出して資産化する。テンプレが無い、文書品質がバラつく、過去資料を活用したいときに使う。
---

## 目的

テンプレ未整備を"1回で終わらせる"ためのスキル。
過去資料を教師データにして、再利用可能なテンプレと品質チェックを生成する。

## トリガー語

- 「テンプレを作りたい」
- 「過去資料からテンプレ抽出」
- 「スタイルガイドを作成」
- 「チェックリストを作成」

---

## 入力で最初に聞くこと

| # | 質問 | 目的 |
|---|------|------|
| 1 | **過去資料**を3〜10件提供してください | 教師データとして使用 |
| 2 | **対象の文書種別**は？（提案書/稟議/議事録等） | テンプレの命名・構成決定 |
| 3 | **主な読者**は？（役員/部長/現場） | トーン・詳細度を調整 |

---

## 手順（6ステップ）

### Step 1: 章立ての抽出
- 各資料の章立てを抽出し、共通パターンを特定
- 一覧表でマッピング

### Step 2: 各章の役割定義
- 各章が提供する情報の目的を定義
- 「この章がないと何が困るか」を明確化

### Step 3: 定型文スニペットの抽出
- 冒頭文、結論文、注意書きを抽出
- よく使う言い回しをリスト化

### Step 4: 禁止・注意表現の抽出
- 曖昧語、過度な断定、根拠なき数値を特定
- 社外秘情報の露出パターンを確認

### Step 5: DoDチェックリスト作成
- 完成判定基準を作成
- 各章ごとのチェック項目を定義

### Step 6: 成果物の生成・保存

---

## 成果物

| ファイル名 | 目的 |
|------------|------|
| `STYLE_GUIDE.md` | 文体・トーン・表現の標準 |
| `TEMPLATE_<doc-type>.md` | 章立てテンプレート |
| `CHECKLIST_<doc-type>.md` | 完了判定チェックリスト |

**保存先**:
- `.agent/templates/docs/` （汎用）
- `workspace/{ProjectName}/docs/templates/` （プロジェクト固有）

---

## 検証（完了条件）

- [ ] テンプレに従えば同品質の文書が再現できる
- [ ] チェックリストが"抜け漏れ"を検出できる
- [ ] 3つの成果物が保存されている
- [ ] 読者に適したトーンになっている

---

## 参照

- Workflow: `.agent/workflows/05_meta_bootstrap_template_library.md`
- 関連Skill: `doc-from-examples`（生成したテンプレを使って文書作成）
