---
name: test-creator
description: テストコードを作成する際に使用します。ユニットテスト、統合テスト、エンドツーエンドテストなど、あらゆる種類のテストコードを生成するためにこのスキルを利用してください。
---

# テストコード作成スキル

このスキルは、テストコードを生成するためのガイドラインと手順を提供します。

## テストの実装方針

### 基本原則

- カバレッジだけを追い求めず、開発者が認知・管理できる範囲に留める
- 正常系を中心にテストを実装
- 異常系は必要最低限のものに限定
- 1人開発のため、過度な品質は追求しない
- 外部API中心でほぼモックになるテストは価値が見合わないため実装しない
- **APIを経由したデータ作成**: テストデータの作成は原則としてAPIエンドポイントを使用する（直接データベースに挿入しない）
  - 取引: `create_transaction` フィクスチャを使用
  - 配当: `create_dividend` フィクスチャを使用
  - これにより実際のビジネスロジック（保有株の自動更新など）が正しく動作することを保証
- **共通フィクスチャの活用**: `conftest.py` に定義された共通フィクスチャを積極的に利用する
- **新規フィクスチャの追加**: 複数のテストで再利用可能なセットアップロジックは `conftest.py` に追加する

### データベースとトランザクション

- 各テストは独立したPostgreSQLデータベースで実行される（testcontainers使用）
- `db_session` フィクスチャはトランザクション内で動作し、テスト終了後に自動ロールバック
- テンプレートデータベース方式により初期化を高速化
- 認証トークン取得時は独立したセッションでユーザーを作成・コミット（他のセッションから参照可能にするため）

### 認証

- 一般ユーザー: `auth_token` フィクスチャ（username: "testuser"）
- 管理者ユーザー: `auth_admin_token` フィクスチャ（username: "adminuser"）
- APIリクエストには `headers={"Authorization": f"Bearer {auth_token}"}` を指定

### 外部APIのモック

- `mock_external_apis` フィクスチャが全テストに自動適用（autouse=True）
- モック対象:
  - AlphaVantage API（米国株情報、為替レート）
  - J-Quants API（日本株情報）
  - Yahoo Finance（株価取得）
- **株価の挙動**: 初回と2回目以降で異なる値を返す
  - 日本株: 1回目 3000.0円、2回目以降 3100.0円
  - 米国株: 1回目 36000.0円、2回目以降 37500.0円（円換算済み）
- 外部APIを実際に呼び出すテストは不要（モック化されているため）

### テストデータのセットアップ

- **日本株**: `setup_japanese_stock_data` フィクスチャ（8058を100株、3000円で買付）
- **米国株**: `setup_us_stock_data` フィクスチャ（AAPLを10株、36054円で買付）
- **配当**: `setup_dividend_data` フィクスチャ（日本株・米国株の配当データ）
- **ポートフォリオ**: `setup_portfolio_test_data` フィクスチャ（日本株・米国株・配当の全データ）
- これらのフィクスチャを組み合わせて、テストに必要な初期状態を構築する

### HTTPクライアント

- 非同期テスト: `client` フィクスチャ（AsyncClient）
- 同期テスト: `sync_client` フィクスチャ（TestClient）
- データベース接続は自動的にテスト用にオーバーライドされる

## Instructions

1. **テスト実装方針を確認する**
   - 上記の「テストの実装方針」セクションを読み、プロジェクト固有のルールを理解する
   - 外部APIは自動的にモック化されているため、実際の呼び出しは不要

2. **テスト計画を立てる**
   - 何をテストするか明確にする
   - 既存のフィクスチャ（`auth_token`、`create_transaction`、`create_dividend`、`setup_japanese_stock_data` など）を活用できるか確認

3. **テストを実装する**
   - テストデータはAPIを経由して作成（`create_transaction`、`create_dividend` フィクスチャを使用）
   - 認証が必要なエンドポイントは適切なトークンをヘッダーに含める（`headers={"Authorization": f"Bearer {auth_token}"}`）
   - 新しい共通セットアップが必要なら `conftest.py` に追加する

4. **テストを実行して検証する**
   - 作成したテストコード単体を `uv run pytest <test_file>` で実行
   - テストが正しく動作することを確認する
