---
name: Capital Pillar (Premium)
description: Resources and freedom engine - Money, business, wealth, and financial independence
version: 1.0.0
tier: premium
pillar: capital
price: $67
includes: [30-day program, AI coaching, business systems]
---

# PILLAR 5: CAPITAL - Premium Mastery System

*"Money is fuel for freedom, not a scorecard. The goal isn't maximum revenue—it's sufficient capital to create without compromise. Build the engine, then protect your time."*

## What's Included

- The Creator's Revenue Stack
- Business Model Design System
- Wealth Building Framework
- 30-Day Capital Acceleration Program
- AI Coaching Prompt Library
- Freedom Number Calculator
- Asset Creation Strategies

---

## The Capital Architecture

```
                    FREEDOM
                        ▲
                        │
    ┌───────────────────┼───────────────────┐
    │                   │                   │
  REVENUE           BUSINESS            WEALTH
    │                   │                   │
Income streams     Systems              Assets
Client work        Operations           Investments
Products          Leverage              Net worth
    │                   │                   │
    └───────────────────┴───────────────────┘
                        │
                   FOUNDATION
```

---

## Three Guides Methodology

### The TEACHER (What You Need to KNOW)

**Core Principles:**

1. **Revenue vs. Wealth (Different Games)**
   - Revenue: What you earn this year
   - Wealth: What you keep and grow over time
   - High revenue doesn't guarantee wealth
   - Wealth buys freedom; revenue buys lifestyle

2. **The Creator's Revenue Stack**
   - Trading time for money (1:1, low leverage)
   - Productized services (1:few, medium leverage)
   - Digital products (1:many, high leverage)
   - Assets and investments (0:∞, passive)

3. **The Freedom Number**
   - What monthly income covers your needs?
   - What covers needs + wants?
   - What covers needs + wants + investment?
   - Target the third number

**Essential Frameworks:**

```
CREATOR REVENUE STACK:
├── Services (high $ per, low leverage)
│   ├── 1:1 consulting/coaching
│   ├── Done-for-you work
│   └── High-touch delivery
│
├── Productized Services (medium)
│   ├── Group coaching
│   ├── Retainers
│   └── Templated delivery
│
├── Digital Products (high leverage)
│   ├── Courses
│   ├── Templates
│   ├── Communities
│   └── Subscriptions
│
└── Assets (passive)
    ├── Investments
    ├── Royalties
    └── Equity

FREEDOM NUMBER CALCULATION:
├── Needs: [essential monthly expenses]
├── Wants: [desired lifestyle additions]
├── Investment: [wealth building allocation]
├── Buffer: [20% for unexpected]
└── Freedom Number: Sum of above

PRICING PRINCIPLES:
├── Value > Time (charge for outcomes)
├── Premium > Discount (attract quality)
├── Recurring > One-time (predict revenue)
├── Ownership > Rental (build assets)
└── Leverage > Labor (multiply impact)
```

### The VISIONARY (What You Need to SEE)

**Vision Questions:**

1. What does financial freedom look like for you specifically?
2. What would you create if money wasn't a concern?
3. How do you want money to serve your life purpose?

**Future State:**

```
ENVISION YOUR FINANCIAL FREEDOM:

REVENUE REALITY:
├── Monthly income exceeds needs
├── Multiple revenue streams active
├── Income predictable
├── Not dependent on any one source
└── Capacity to say no to wrong fit

BUSINESS HEALTH:
├── Systems run without you daily
├── Margins are healthy (40%+)
├── Growth is intentional
├── Team handles operations
└── Your time is protected

WEALTH BUILDING:
├── Saving/investing monthly
├── Assets growing
├── Net worth trajectory up
├── Runway for risk-taking
└── Generational wealth possible
```

### The DEVELOPER (What You Need to BUILD)

**Implementation Systems:**

```
REVENUE SYSTEM:

MONTHLY REVENUE REVIEW:
├── Total revenue this month: $_____
├── By stream:
│   ├── Services: $_____
│   ├── Products: $_____
│   └── Passive: $_____
├── Expenses: $_____
├── Profit: $_____
├── Profit margin: ____%
└── Trend: Up / Down / Flat

PRICING FRAMEWORK:
├── Calculate true cost (time + overhead)
├── Research market rates
├── Assess value delivered
├── Set premium position
├── Test and adjust

SALES SYSTEM:
├── Lead generation (how they find you)
├── Nurture sequence (how they trust you)
├── Conversion (how they buy)
├── Delivery (how you serve)
├── Retention (how they stay)

BUSINESS OPERATIONS:

TIME AUDIT:
├── Revenue-generating activities: ___%
├── Necessary operations: ___%
├── Should delegate: ___%
├── Should eliminate: ___%
└── Protected creation time: ___%

LEVERAGE OPPORTUNITIES:
├── What can be automated?
├── What can be delegated?
├── What can be eliminated?
├── What can be productized?
└── What can become an asset?

WEALTH BUILDING:

MONTHLY ALLOCATION:
├── Taxes: 25-30% set aside
├── Emergency fund: Until 6 months
├── Investing: 20%+ of profit
├── Business reinvestment: Variable
└── Personal spending: What's left
```

---

## AI Coaching Prompts

### Revenue Assessment
```
"I'm using the Capital Pillar skill for revenue analysis.

Current revenue streams:
- Stream 1: [describe] → $___/month
- Stream 2: [describe] → $___/month
- Stream 3: [describe] → $___/month

Monthly expenses: $_____
Freedom number: $_____
Gap: $_____

Help me:
1. Assess my revenue health
2. Identify highest leverage opportunity
3. Suggest next revenue stream to build
4. Create 90-day revenue goal"
```

### Pricing Strategy
```
"I'm using the Capital Pillar skill for pricing work.

Offer: [describe what you sell]
Current price: $_____
Time invested per unit: [hours]
Perceived value to client: [describe]
Market comparison: [what competitors charge]

Please:
1. Assess if I'm underpricing
2. Suggest positioning strategy
3. Calculate value-based price
4. Recommend pricing test approach"
```

### Business Model Design
```
"I'm using the Capital Pillar skill for business design.

What I do: [describe]
Current model: [how you deliver/charge]
Problems with current: [describe]
Ideal work week: [describe]

Help me:
1. Diagnose model constraints
2. Suggest alternative models
3. Map transition path
4. Identify risks and mitigations"
```

---

## 30-Day Capital Acceleration

```
WEEK 1: ASSESSMENT
├── Day 1-2: Revenue audit
├── Day 3-4: Expense analysis
├── Day 5-6: Freedom number calculation
└── Day 7: Gap assessment

WEEK 2: OPTIMIZATION
├── Day 8-10: Pricing review
├── Day 11-14: Revenue stream analysis
└── Identify quick wins

WEEK 3: BUILDING
├── Day 15-17: New stream design
├── Day 18-21: Implementation start
└── Early results tracking

WEEK 4: SYSTEMS
├── Day 22-25: Sales system review
├── Day 26-28: Automation opportunities
├── Day 29-30: 90-day plan creation
└── Review and celebrate
```

---

## Integration with Other Pillars

**Capital → Energy:**
- Financial stress drains energy
- Security enables rest
- Wealth buys health access

**Capital → Craft:**
- Revenue enables time for craft
- Craft creates value for revenue
- Assets fund creative risk-taking

**Capital → Circle:**
- Generosity strengthens relationships
- Wealth enables contribution
- Financial stress strains relationships

**Capital → Legacy:**
- Wealth enables impact
- Assets fund mission
- Financial independence enables purpose

---

## Related Premium Skills
- `craft` - Creating value to exchange
- `circle` - Relationships for opportunity
- `legacy` - Long-term wealth purpose
