---
name: Energy Pillar (Premium)
description: Physical foundation that powers everything else - Health, vitality, and sustainable energy
version: 1.0.0
tier: premium
pillar: energy
price: $67
includes: [30-day program, AI coaching, tracking system]
---

# PILLAR 1: ENERGY - Premium Mastery System

*"Energy is your creative currency. Every piece of content, every strategy session, every creative breakthrough draws from your energy reserves. Protect the source."*

## What's Included

- Advanced Energy Framework (4 Pillars)
- 30-Day Energy Transformation Program
- AI Coaching Prompt Library (Teacher, Visionary, Developer)
- Progress Tracking System
- Weekly Review Templates
- Habit Installation Protocols
- Emergency Recovery Protocols

---

## The Energy Architecture

```
                    PEAK ENERGY
                        ▲
                        │
    ┌───────────────────┼───────────────────┐
    │                   │                   │
 RECOVERY          MOVEMENT            NUTRITION
    │                   │                   │
    │   ┌───────────────┼───────────────────┐
    │   │               │                   │
  Sleep │           Training            Fuel
  Stress│           Cardio           Hydration
  Rest  │          Mobility          Supplements
        │               │                   │
        └───────────────┴───────────────────┘
                        │
                    BASELINE
```

---

## Three Guides Methodology

### The TEACHER (What You Need to KNOW)

**Core Principles:**

1. **Energy is Currency**
   - Every decision, task, and interaction spends energy
   - You cannot create more hours, but you can create more energy per hour
   - Protect your energy like you protect your income

2. **The Four Energy Systems**
   - Physical: Body health, movement, sleep
   - Emotional: Regulation, stress management
   - Mental: Focus, cognitive capacity
   - Spiritual: Purpose, meaning, motivation

3. **Minimum Effective Dose**
   - 80% of health results come from 20% of habits
   - Sleep > Exercise > Nutrition (priority order)
   - Consistency beats intensity every time

**Essential Frameworks:**

```
THE ENERGY AUDIT:
├── Sleep: 7-8 hours (non-negotiable)
├── Movement: 30 min daily (some intensity)
├── Nutrition: Protein at every meal
├── Hydration: Half bodyweight in oz
└── Stress: One regulation practice daily

THE CREATOR'S MINIMUM:
├── Protect sleep above all else
├── Morning movement (even 10 min)
├── Protein-first meals
├── No phone first/last hour of day
└── One weekly full-rest day
```

### The VISIONARY (What You Need to SEE)

**Vision Questions:**

1. What would your life look like with unlimited energy?
2. How would you show up differently if you felt vital every day?
3. What becomes possible when your body is an asset, not an obstacle?

**Future State:**

```
ENVISION YOUR IDEAL:

MORNING:
├── Wake before alarm, refreshed
├── Energy for morning creation
├── No stimulant dependency
└── Ready to move

MID-DAY:
├── Sustained focus (no crash)
├── Post-lunch clarity
├── Energy for people
└── No afternoon slump

EVENING:
├── Energy for family/friends
├── Creative capacity remains
├── Wind-down without collapse
└── Quality sleep easily

WEEKLY:
├── Training you enjoy
├── Active weekends
├── Recovery without guilt
└── Consistent energy baseline
```

**Goal Hierarchy:**

```
90-DAY ENERGY GOALS:
├── Health metric: [specific target]
├── Performance: [output increase]
├── Feeling: [daily energy 8+/10]
└── Habit: [non-negotiable installed]

30-DAY MILESTONE:
├── Sleep: [hours, quality target]
├── Movement: [sessions/week]
├── Nutrition: [protein target]
└── Recovery: [practice installed]
```

### The DEVELOPER (What You Need to BUILD)

**Implementation Systems:**

```
DAILY ENERGY SYSTEM:

MORNING PROTOCOL:
├── Wake time: _____ (consistent ±30 min)
├── Light exposure: 10 min within first hour
├── Movement: Even 5-10 min counts
├── Hydration: 16oz before caffeine
└── No phone for 30 min

DAYTIME ENERGY:
├── Meal timing: Protein every 3-4 hours
├── Movement snacks: Every 60-90 min
├── Focus blocks: 90 min max
├── Stress breaks: 5 min between blocks
└── Caffeine cutoff: 6+ hours before bed

EVENING PROTOCOL:
├── Dinner: 3+ hours before bed
├── Screen cutoff: 60 min before bed
├── Wind-down ritual: 30-60 min
├── Environment: Dark, cool, quiet
└── Consistent bedtime: ±30 min
```

**Habit Installation:**

```
WEEK 1: Sleep Foundation
├── Set non-negotiable bedtime
├── Create wind-down ritual
├── Optimize sleep environment
└── Track sleep quality

WEEK 2: Morning Activation
├── Consistent wake time
├── Light exposure protocol
├── Morning movement habit
└── Hydration before caffeine

WEEK 3: Fuel Optimization
├── Protein at every meal
├── Pre-workout nutrition
├── Hydration tracking
└── Energy food identification

WEEK 4: Integration
├── Full day energy system
├── Weekly recovery day
├── Troubleshooting weak points
└── Sustainability planning
```

---

## AI Coaching Prompts

### Daily Check-In
```
"I'm using the Energy Pillar skill. Today:
- Sleep quality (1-10): [X]
- Energy level (1-10): [X]
- Training: [Yes/No, what]
- Nutrition adherence (1-10): [X]
- Stress level (1-10): [X]

Give me:
1. Brief assessment of today
2. One specific recommendation
3. Focus for tomorrow"
```

### Weekly Review
```
"I'm using the Energy Pillar skill for weekly review.

This week:
- Training sessions completed: [X] of [target]
- Average sleep: [X] hours
- Average energy: [X]/10
- Nutrition wins: [describe]
- Nutrition challenges: [describe]
- Recovery quality: [X]/10

Please:
1. Analyze my week
2. Identify top 2 wins
3. Identify top 2 areas for improvement
4. Give me 3 specific focuses for next week"
```

### Course Correction
```
"I'm using the Energy Pillar skill and need help.

Issue: [describe the challenge]
Duration: [how long has this been happening]
Attempted solutions: [what you've tried]
Current context: [stress, life circumstances]

Please:
1. Diagnose the root cause
2. Give me the minimum viable action to restart
3. Suggest a modified approach for my situation"
```

---

## Emergency Protocols

### Energy Crash Recovery
```
IMMEDIATE (Next 24 hours):
1. Early bedtime tonight (extra 1-2 hours)
2. Protein + complex carbs meal now
3. Light walk (10-15 min)
4. Caffeine cutoff immediately
5. Skip tonight's training

NEXT 48 HOURS:
1. Reduce training volume 50%
2. Focus on sleep quantity
3. High-protein meals
4. Limit stimulants
5. Avoid unnecessary stressors
```

---

## Integration with Other Pillars

**Energy → Mind:**
- Sleep affects cognitive capacity
- Exercise regulates emotions
- Nutrition impacts focus

**Energy → Craft:**
- Energy enables sustained output
- Vitality feeds creativity
- Recovery allows deep work

**Energy → Legacy:**
- Can't serve others when depleted
- Longevity for long-term impact
- Modeling health for influence

---

## Related Premium Skills
- `mind` - Mental and emotional optimization
- `craft` - Creative output systems
- `legacy` - Long-term health for impact
