---
name: thought-leader-content
description: Frameworks, templates, and best practices for creating thought leadership content. Use when generating LinkedIn posts, Twitter threads, articles, newsletters, or any content meant to establish expertise and authority.
---

# Thought Leader Content Skill

Create content that establishes expertise, builds audience, and drives engagement across platforms.

## Core Principles

### The 4 Pillars of Thought Leadership Content

1. **Unique Perspective** - Say something others aren't saying
2. **Practical Value** - Give readers something they can use
3. **Authentic Voice** - Sound like yourself, not generic AI
4. **Strategic Timing** - Post when your audience is receptive

### Content That Builds Authority

**DO:**
- Share specific experiences with concrete details
- Admit mistakes and what you learned
- Take positions (even controversial ones)
- Teach frameworks others can apply
- Connect ideas in unexpected ways

**DON'T:**
- State the obvious as insight
- Use generic advice everyone's heard
- Hide behind safe, consensus opinions
- Write in corporate-speak
- Pad content with filler

## Content Frameworks

### The Hook-Story-Insight-CTA Framework (HSIC)

```
HOOK: Attention-grabbing opening (1-2 lines)
STORY: Specific experience or observation (3-5 lines)
INSIGHT: The lesson or framework (2-3 lines)
CTA: What reader should do next (1 line)
```

### The Problem-Agitate-Solve Framework (PAS)

```
PROBLEM: Name the pain your audience feels
AGITATE: Make them feel it more deeply
SOLVE: Present your solution/insight
```

### The Contrarian Take Framework

```
1. State the common belief
2. Explain why you disagree
3. Present your alternative view
4. Back it up with evidence/experience
5. Acknowledge valid counterpoints
```

### The Framework Framework

```
1. Name your framework (make it memorable)
2. Explain what it solves
3. Break it into 3-5 steps/components
4. Show example of application
5. Give reader homework
```

## Platform-Specific Guidelines

### LinkedIn

**Optimal Format:**
- 200-300 words (sweet spot)
- Single idea per post
- Use line breaks liberally
- Start with hook that stops scrolling
- End with question or CTA

**What Works:**
- Personal stories with professional lessons
- Contrarian takes on industry topics
- Behind-the-scenes insights
- Career/leadership lessons
- Framework posts

**Structure:**
```
[Hook line - standalone impact]

[Context/story - 2-3 short paragraphs]

[Insight/lesson - clear takeaway]

[CTA or question to prompt engagement]
```

### Twitter/X

**Optimal Format:**
- Threads: 5-10 tweets
- First tweet must stand alone
- One idea per tweet
- Include visual if possible

**What Works:**
- Numbered lists/frameworks
- Rapid-fire tips
- Hot takes on news
- Breakdown of complex topics
- Personal wins/fails

**Thread Structure:**
```
Tweet 1: Hook + promise ("Here's how I...")
Tweet 2-N: Deliver the content
Final Tweet: Summary + CTA (follow, repost, etc.)
```

### Articles/Blog Posts

**Optimal Format:**
- 800-1500 words
- Clear structure with headers
- Scannable but deep
- Include 1-2 concrete examples

**Structure:**
```
Title: Clear, specific, searchable
Intro: Hook + what reader will learn
Body: 3-5 sections with headers
Conclusion: Summary + next steps
```

### Newsletter

**Optimal Format:**
- 500-800 words
- Personal, conversational tone
- Value delivered immediately
- Consistent format/sections

**Structure:**
```
Personal opener (what's on your mind)
Main insight/story
Practical takeaway
Quick links/resources (optional)
Sign-off
```

## Voice Profile Integration

Before generating any content:

1. **Load voice profile** from memory
2. **Apply voice constraints:**
   - Use their vocabulary
   - Match their sentence patterns
   - Follow their structural preferences
   - Maintain their tone

3. **Verify voice match:**
   - Does this sound like them?
   - Would they actually say this?
   - Are there any "avoid" words present?

## Hook Types & Examples

### The Surprising Stat
"87% of startups fail at exactly the same thing."

### The Contrarian Opener
"Stop networking. It doesn't work."

### The Story Tease
"I lost $50,000 in one decision. Here's what it taught me."

### The Question
"Why do senior engineers get stuck at their level?"

### The Direct Statement
"Your morning routine is killing your productivity."

### The List Promise
"5 things I'd tell my 25-year-old self about building wealth."

### The Pattern Interrupt
"Everyone's talking about AI wrong."

### The Confession
"I used to think hustle culture was the answer. I was wrong."

## Content Quality Checklist

Before publishing any content, verify:

- [ ] Hook would stop YOUR scrolling
- [ ] Core insight is actually valuable
- [ ] Examples are specific, not generic
- [ ] Voice matches profile (no robot-speak)
- [ ] No clichés or overused phrases
- [ ] CTA is clear and natural
- [ ] Length is right for platform
- [ ] Would you engage with this post?

## Memory Integration

### Store Successful Content
After content performs well:
```
Category: ["content-patterns", "high-performing"]
Content: "[Platform] post about [topic] performed well.
Hook style: [type]. Key elements: [what worked].
Engagement: [metrics if available]."
```

### Recall Before Writing
Before generating content:
```
Query: "voice profile [platform] content patterns"
```

## Common Content Mistakes

1. **Burying the lead** - Put the good stuff first
2. **Generic advice** - Be specific or don't post
3. **No point of view** - Take a stance
4. **All theory** - Include real examples
5. **Corporate voice** - Write like a human
6. **Weak hooks** - First line must earn the second
7. **Missing CTA** - Tell them what to do
8. **Wrong platform fit** - Match content to medium
