# Article/Blog Post Templates

## Template 1: The Problem-Solution Article

```markdown
# [Title: Clear, Specific, Searchable]

## Introduction (100-150 words)
- Hook: Surprising stat, question, or bold claim
- Problem statement: What pain does the reader have?
- Promise: What will they learn?
- Credibility: Why should they listen to you?

## The Problem in Depth (200-300 words)
- Why this problem exists
- Common approaches that don't work
- Cost of not solving it

## The Solution (400-600 words)
### Step/Component 1
- What it is
- How to do it
- Example

### Step/Component 2
- What it is
- How to do it
- Example

### Step/Component 3
- What it is
- How to do it
- Example

## Real-World Application (150-200 words)
- Case study or personal example
- Before and after
- Results achieved

## Conclusion (100-150 words)
- Recap key points
- Restate transformation
- Clear next step/CTA
```

---

## Template 2: The Framework Article

```markdown
# The [Framework Name]: [What It Achieves]

## Why You Need This Framework
- The problem it solves
- Why existing approaches fall short
- What makes this different

## The [Framework Name] Explained

### Overview
[Visual or diagram description]
[High-level explanation]

### Component 1: [Name]
- Definition
- Why it matters
- How to apply
- Example

### Component 2: [Name]
[Same structure]

### Component 3: [Name]
[Same structure]

## Putting It All Together
- Example walkthrough
- Common pitfalls
- Tips for success

## Take Action
- Start here
- Resources
- CTA
```

---

## Template 3: The Lessons Learned Article

```markdown
# [Number] Lessons from [Experience/Time Period/Project]

## Introduction
- Context setting
- Why these lessons matter
- Who should read this

## Lesson 1: [Lesson Title]
### What Happened
[Story/experience]

### What I Learned
[The insight]

### How You Can Apply This
[Actionable advice]

## Lesson 2: [Lesson Title]
[Same structure]

## Lesson 3: [Lesson Title]
[Same structure]

[Continue for remaining lessons]

## The Bigger Picture
- Connecting theme
- What these lessons mean together
- Final thoughts

## Your Turn
- CTA
- Question for engagement
```

---

## Template 4: The Contrarian/Opinion Article

```markdown
# [Contrarian Take as Title]

## The Conventional Wisdom
- What most people believe
- Where this advice comes from
- Why it seems logical

## Why I Disagree
- My experience/evidence
- The flaw in conventional thinking
- What's actually happening

## The Alternative Approach
- What I recommend instead
- How it works
- Evidence it works

## Addressing Objections
- "But what about..."
- Fair counterpoints
- When conventional wisdom does apply

## Conclusion
- Restate position
- Call to rethink
- CTA
```

---

## Template 5: The How-To Guide

```markdown
# How to [Achieve Specific Outcome]: A Complete Guide

## Overview
- What you'll learn
- What you'll need
- Expected timeframe/results

## Prerequisites
- Required knowledge
- Tools needed
- Preparation steps

## Step 1: [Action]
### What to Do
[Detailed instructions]

### Why This Matters
[Context]

### Pro Tips
[Advanced advice]

### Common Mistakes
[What to avoid]

## Step 2: [Action]
[Same structure]

## Step 3: [Action]
[Same structure]

## Troubleshooting
- Problem 1: Solution
- Problem 2: Solution

## Next Steps
- What to do after completing this
- Related resources
- CTA
```

---

## Article Writing Guidelines

### Headlines That Work
- Include the benefit
- Be specific (numbers help)
- Create curiosity or urgency
- Match search intent

**Formula:** [Number/How] + [Desirable Outcome] + [Timeframe/Method]

**Examples:**
- "7 Ways to Double Your Writing Speed This Month"
- "How I Built a $1M Business in 18 Months"
- "The Complete Guide to [Topic] for [Audience]"

### Introduction Patterns

**The Story Open:**
"Last March, I faced a decision that would change my career..."

**The Problem Open:**
"If you're like most [audience], you've struggled with [problem]..."

**The Stat Open:**
"73% of [group] fail at [thing]. Here's why..."

**The Question Open:**
"What if everything you knew about [topic] was wrong?"

**The Bold Claim:**
"[Common practice] is dead. Here's what's replacing it."

### Section Flow
1. Tell them what you'll tell them
2. Tell them
3. Tell them what you told them

### Conclusion Patterns
- Summary + Action
- Story callback + Lesson
- Question + Challenge
- Resource + Next step
