# Carousel/Slide Content Templates

For LinkedIn carousels, Instagram slides, or presentation-style content.

## Template 1: The List Carousel

```
Slide 1 (Cover):
[Number] [Things] About [Topic]
[Subtitle or your handle]

Slides 2-N (Content):
#[Number]
[Point Title]

[1-2 sentence explanation]

Final Slide (CTA):
Found this useful?
• Save for later
• Follow @handle for more
• Share with someone who needs this
```

**Example:**
```
Slide 1:
7 Habits That Destroy Your Productivity
(And what to do instead)

Slide 2:
#1 Checking email first thing

Your brain is freshest in the morning.
Don't waste it on other people's priorities.

[Continue...]

Slide 8:
Save this carousel for your Monday morning.

Follow @adamknight for more productivity tips.
```

---

## Template 2: The Framework Carousel

```
Slide 1 (Cover):
The [Framework Name]
A simple system for [outcome]

Slide 2 (Overview):
What is it?
[Brief explanation of the framework]

Slides 3-N (Components):
Step/Part [N]: [Name]
[Visual representation]
[Brief explanation]

Second-to-Last Slide (Example):
In Practice:
[Real example of framework application]

Final Slide (CTA):
[CTA]
```

---

## Template 3: The Before/After Carousel

```
Slide 1 (Cover):
[Topic]: Before vs After
What I wish I knew [X years] ago

Slide 2:
BEFORE: [Old belief/behavior]
[Brief context]

Slide 3:
AFTER: [New belief/behavior]
[Why it's better]

[Repeat Before/After pairs]

Final Slide:
The shift?
[Summary insight]

Save + follow for more.
```

---

## Template 4: The Breakdown Carousel

```
Slide 1 (Cover):
How [Person/Company] [Achieved Thing]
Broken down simply

Slides 2-N:
[Component/Strategy #N]
[Explanation]
[Why it works]

Final Slide:
Key takeaways:
• [Point 1]
• [Point 2]
• [Point 3]

[CTA]
```

---

## Template 5: The Mistake Carousel

```
Slide 1 (Cover):
[N] Mistakes Killing Your [Goal]
(And how to fix them)

Slides 2-N:
Mistake #[N]:
[The mistake]

Instead:
[The fix]

Final Slide:
Summary:
❌ Don't: [list mistakes]
✅ Do: [list fixes]

[CTA]
```

---

## Carousel Design Principles

### Visual Guidelines
- Consistent color scheme throughout
- Large, readable text (think mobile-first)
- One core idea per slide
- White space is your friend
- Brand elements on each slide

### Text Guidelines
- Max 30-40 words per slide
- Headlines: 5-7 words
- Use bullet points over paragraphs
- Strong verbs, active voice
- Numbers and stats pop

### Structure Guidelines
- Cover slide must hook
- Logical flow between slides
- Build tension/value through sequence
- Strong CTA on final slide
- Sweet spot: 7-10 slides

### Engagement Optimization
- End with question or CTA
- Include save-worthy content
- Make sharing easy
- Preview value on cover slide

---

## Cover Slide Formulas

**The List:**
"[N] [Things] That [Outcome]"

**The How-To:**
"How to [Achieve] in [Timeframe]"

**The Secret:**
"The [Adjective] [Thing] [Experts/Successful People] Use"

**The Mistake:**
"Stop [Doing X] If You Want [Outcome]"

**The Framework:**
"The [Name] Method for [Outcome]"

**The Comparison:**
"[Thing A] vs [Thing B]: Which Is Better?"

---

## Final Slide CTA Options

**For Engagement:**
"Which tip will you try first?
Comment below 👇"

**For Saves:**
"Save this carousel for next time you [need this]"

**For Follows:**
"Follow @handle for more [topic] tips"

**For Shares:**
"Know someone who needs this?
Tag them or share to your story"

**For Action:**
"Ready to [outcome]?
Link in bio to get started"
