# Twitter/X Thread Templates

## Template 1: The Listicle Thread

```
Tweet 1 (Hook):
[Number] [things/lessons/mistakes] about [topic]:

(This changed how I think about [subject])

Tweet 2-N (Content):
[Number]. [Lesson/Point]

[Brief explanation]

Final Tweet:
If you found this useful:
• Follow me @handle for more
• Repost the first tweet to share

[Optional: Link to related content]
```

**Example:**
```
7 things nobody tells you about starting a company:

(After 3 failed startups and 1 success)

🧵

---

1. Your first idea is probably wrong

The startup I succeeded with?
Third pivot.

Don't marry your idea.
Marry the problem.

---

2. Fundraising is a full-time job

Thought I could do it on the side.
Took 3x longer than expected.

Either commit fully or don't start.

---

[Continue for remaining points...]

---

If this thread resonated:
• Follow me @handle for more startup lessons
• Repost tweet 1 so others can learn too
```

---

## Template 2: The How-To Thread

```
Tweet 1 (Hook):
How to [achieve specific outcome]:

A step-by-step guide

🧵

Tweet 2 (Setup):
[Why this matters / context]

Tweet 3-N (Steps):
Step [N]: [Action]

[How to do it]
[Why it matters]

Final Tweet:
TL;DR:
• Step 1
• Step 2
• Step 3
• Step 4

Follow @handle for more guides like this.
```

---

## Template 3: The Breakdown Thread

```
Tweet 1 (Hook):
I studied [thing/person/company] for [time].

Here's what I learned:

🧵

Tweet 2-N (Insights):
[Insight number]

[Explanation with specific example]

Final Tweet:
Key takeaways:
• [Takeaway 1]
• [Takeaway 2]
• [Takeaway 3]

[CTA]
```

---

## Template 4: The Contrarian Thread

```
Tweet 1 (Hook):
[Common belief] is wrong.

Here's what actually works:

🧵

Tweet 2:
Everyone says: [common advice]

But I've found: [opposite/alternative]

Tweet 3-N:
Here's why:

[Evidence/reasoning]

Final Tweet:
The truth?

[Reframe of the topic]

[CTA]
```

---

## Template 5: The Story Thread

```
Tweet 1 (Hook):
[Year/Time], [dramatic moment].

Here's what happened:

🧵

Tweet 2-N:
[Story told in chunks]
[One scene/moment per tweet]
[Build tension]

Final Tweet:
The lesson?

[What you learned]

[CTA]
```

---

## Thread Writing Rules

### First Tweet Rules
- Must work as standalone tweet
- Create curiosity to read more
- Include thread indicator (🧵 or "A thread:")
- Promise specific value

### Middle Tweet Rules
- One idea per tweet
- Use numbers/bullets for scannability
- Add visual interest (emojis sparingly)
- End some tweets with hooks to next

### Final Tweet Rules
- Summarize key points
- Clear call to action
- Make sharing easy
- Optional: link to related content

---

## Hook Bank for Twitter

**Number Hooks:**
- "[N] mistakes I made [doing X]:"
- "[N] lessons from [experience]:"
- "[N] things that [changed/improved] my [X]:"

**Story Hooks:**
- "In [year], I [dramatic thing]."
- "[Person/Company] taught me everything about [X]."
- "I spent [time] doing [thing]. Here's what I learned:"

**Contrarian Hooks:**
- "[Common belief] is a myth."
- "Hot take: [contrarian view]"
- "Stop [common advice]. Do this instead:"

**How-To Hooks:**
- "How to [outcome] (step by step):"
- "The exact process I use to [achieve thing]:"
- "A simple guide to [complex topic]:"

---

## Tweet Formatting Tips

- Use line breaks between ideas
- Numbers and bullets aid scanning
- Emojis: max 1-2 per tweet
- Keep sentences short
- One tweet = one complete thought
- End with periods (feels more confident)
