# Hashtag Library

Curated hashtags for Tomáš Vince's LinkedIn posts. Always use **exactly 6 hashtags** per post.

## Formula

```
[1-2 Broad Professional] + [2-3 Specific Technology] + [1-2 Value/Benefit] + [Optional Trend]
```

## By Topic Category

### Cloud Architecture

**Broad:**
- #CloudArchitecture
- #CloudComputing
- #CloudEngineering
- #CloudStrategy

**Specific:**
- #AWS
- #Azure
- #GCP
- #MultiCloud
- #HybridCloud
- #CloudNative
- #CloudMigration
- #CloudSecurity

**Related:**
- #Infrastructure
- #IaC (Infrastructure as Code)
- #Terraform
- #Kubernetes
- #Docker
- #DevOps
- #SRE

**Example Sets:**
```
#CloudArchitecture #AWS #MultiCloud #CostOptimization #DevOps #Innovation
#CloudEngineering #Azure #Kubernetes #Performance #Infrastructure #TechLeadership
```

### IoT & Edge Computing

**Broad:**
- #IoT
- #InternetOfThings
- #EdgeComputing
- #IIoT (Industrial IoT)

**Specific:**
- #SmartDevices
- #EdgeAI
- #IoTSecurity
- #IoTPlatform
- #ConnectedDevices
- #SensorData
- #IoTAnalytics

**Related:**
- #Industry40
- #SmartManufacturing
- #DigitalTwin
- #5G
- #Embedded Systems

**Example Sets:**
```
#IoT #EdgeComputing #SmartDevices #Industry40 #Innovation #TechTrends
#IIoT #EdgeAI #CloudArchitecture #Automation #Manufacturing #DigitalTransformation
```

### AI & Machine Learning

**Broad:**
- #ArtificialIntelligence
- #AI
- #MachineLearning
- #ML

**Specific:**
- #AIAgents
- #GenAI (Generative AI)
- #LLM (Large Language Models)
- #ChatGPT
- #NLP
- #ComputerVision
- #AIAutomation
- #MLOps

**Related:**
- #DeepLearning
- #DataScience
- #AIEthics
- #ResponsibleAI

**Example Sets:**
```
#ArtificialIntelligence #AIAgents #Automation #Productivity #Innovation #FutureOfWork
#AI #GenAI #MachineLearning #TechLeadership #AIAutomation #DigitalTransformation
```

### Automation & No-Code

**Broad:**
- #Automation
- #NoCode
- #LowCode
- #WorkflowAutomation

**Specific:**
- #n8n
- #Zapier
- #MakeAutomation
- #RPA
- #ProcessAutomation
- #AIAutomation

**Related:**
- #Productivity
- #Efficiency
- #ProcessOptimization
- #DigitalTransformation

**Example Sets:**
```
#Automation #NoCode #Productivity #AIAgents #Efficiency #Innovation
#WorkflowAutomation #LowCode #AI #ProcessOptimization #TechTools #FutureOfWork
```

### DevOps & Engineering

**Broad:**
- #DevOps
- #SRE
- #Platform Engineering
- #SoftwareEngineering

**Specific:**
- #CI/CD
- #GitOps
- #Kubernetes
- #Docker
- #Terraform
- #Monitoring
- #Observability

**Related:**
- #Agile
- #ContinuousDeployment
- #Infrastructure
- #CloudNative

**Example Sets:**
```
#DevOps #Kubernetes #CloudArchitecture #Automation #Infrastructure #TechLeadership
#SRE #Observability #CloudEngineering #Performance #Reliability #Innovation
```

### Leadership & Career

**Broad:**
- #TechLeadership
- #Leadership
- #CareerDevelopment
- #ProfessionalGrowth

**Specific:**
- #TeamBuilding
- #Mentorship
- #TechCareers
- #EngineeringLeadership

**Related:**
- #LessonsLearned
- #CareerAdvice
- #TechIndustry
- #ProfessionalDevelopment

**Example Sets:**
```
#TechLeadership #CloudArchitecture #TeamBuilding #CareerDevelopment #Innovation #Mentorship
#Leadership #EngineeringManagement #TechCareers #ProfessionalGrowth #LessonsLearned #Tech Industry
```

### Industry & Trends

**Broad:**
- #DigitalTransformation
- #Innovation
- #TechTrends
- #FutureOfWork

**Specific:**
- #Industry40
- #SmartCity
- #TechInnovation
- #EmergingTech

**Related:**
- #DigitalStrategy
- #TechAdoption
- #ChangeManagement
- #BusinessTransformation

**Example Sets:**
```
#DigitalTransformation #AI #CloudComputing #Innovation #TechTrends #FutureOfWork
#Innovation #TechIndustry #EmergingTech #DigitalStrategy #TechLeadership #FutureReady
```

## By Post Type

### Article Commentary
```
[Main topic hashtag] + [2 tech hashtags from article] + [1 industry hashtag] + [2 value hashtags]

Example:
#ArtificialIntelligence #CloudArchitecture #EdgeComputing #Innovation #TechLeadership #FutureOfWork
```

### Personal Experience
```
[Your role hashtag] + [Tech used hashtag] + [Lesson theme hashtag] + [2 industry hashtags] + [1 value hashtag]

Example:
#CloudArchitecture #AWS #LessonsLearned #TechLeadership #RealStories #Innovation
```

### Technical Insight
```
[Tech category] + [2 specific tech hashtags] + [Practice hashtag] + [2 benefit hashtags]

Example:
#CloudArchitecture #Kubernetes #Terraform #BestPractices #CostOptimization #Performance
```

### Industry Trend
```
[Trend hashtag] + [Technology hashtag] + [Industry hashtag] + [2 perspective hashtags] + [1 future hashtag]

Example:
#AI #CloudComputing #TechIndustry #Innovation #TechTrends #FutureOfWork
```

## Pre-Made Sets by Topic

### Cloud Cost Optimization
```
#CloudArchitecture #AWS #CostOptimization #CloudEngineering #FinOps #TechLeadership
```

### AI Implementation
```
#ArtificialIntelligence #AIAgents #CloudArchitecture #Innovation #Automation #TechLeadership
```

### IoT Projects
```
#IoT #EdgeComputing #CloudArchitecture #SmartDevices #Innovation #Industry40
```

### DevOps Practices
```
#DevOps #Kubernetes #CI/CD #CloudArchitecture #Automation #BestPractices
```

### Team Leadership
```
#TechLeadership #CloudArchitecture #TeamBuilding #EngineeringManagement #CareerDevelopment #Mentorship
```

### Digital Transformation
```
#DigitalTransformation #CloudArchitecture #AI #Innovation #TechLeadership #BusinessStrategy
```

### Automation Stories
```
#Automation #AIAgents #NoCode #Productivity #Efficiency #Innovation
```

## Slovak vs English Posts

### Slovak Posts - Use English Hashtags
LinkedIn is global, so **always use English hashtags** even for Slovak posts.

```
Slovak post:
"Minulý týždeň som implementoval AI agenta..."

Hashtags (English):
#ArtificialIntelligence #AIAgents #CloudArchitecture #Automation #Innovation #TechLeadership
```

## Hashtag Best Practices

### Do:
✅ Always exactly 6 hashtags
✅ Mix broad and specific
✅ Include at least 1 technology-specific tag
✅ Use standard capitalization (#CloudArchitecture not #cloudarchitecture)
✅ Match hashtags to actual content
✅ Put hashtags at the end of post

### Don't:
❌ Never more than 6 (looks spammy)
❌ Never less than 6 (missed reach)
❌ Don't use trending but irrelevant hashtags
❌ Don't create custom hashtags (#TomiquesThoughts ❌)
❌ Don't use all broad or all specific
❌ Don't repeat same hashtags every post

## Checking Hashtag Relevance

**Ask yourself:**
1. Would someone following this hashtag want to see my post?
2. Does my post add value to this hashtag community?
3. Is this hashtag too broad (>1M followers) or too narrow (<1K)?

**Ideal Range:**
- 1-2 hashtags with 100K-1M followers (broad reach)
- 3-4 hashtags with 10K-100K followers (targeted)
- 0-1 hashtags with 1K-10K followers (niche)

## When In Doubt

**Default Safe Set for General Tech Posts:**
```
#CloudArchitecture #ArtificialIntelligence #Automation #Innovation #TechLeadership #DigitalTransformation
```

**For Specific Tech Deep Dive:**
```
#CloudArchitecture #AWS #Kubernetes #DevOps #TechTips #Engineering
```

**For Career/Leadership Posts:**
```
#TechLeadership #CloudArchitecture #CareerDevelopment #Mentorship #TechIndustry #ProfessionalGrowth
```

## Pro Tip: Hashtag Rotation

Don't use the exact same 6 hashtags repeatedly. Rotate to reach different audiences while staying relevant.

**Post 1:**
`#CloudArchitecture #AWS #DevOps #Automation #TechLeadership #Innovation`

**Post 2 (similar topic):**
`#CloudEngineering #Azure #Kubernetes #CI/CD #Infrastructure #BestPractices`

**Post 3 (similar topic):**
`#CloudComputing #MultiCloud #SRE #Monitoring #Performance #TechTips`

---

**Remember:** Hashtags are discovery tools. Make them work for you by being strategic, relevant, and consistent (but not repetitive).
