<overview>

The four primary traits (A, B, C, D) are the main drivers of behavior. The relationship BETWEEN dots is often more important than individual positions. All interpretations are relative to the red arrow (population mean).

</overview>

<trait name="A" color="maroon" label="Autonomy">

Measures **mental initiative** (think and start on their own) and **inner self-confidence** (belief in self that they will win regardless of circumstance).

<high_a side="right">

**Characteristics:**
- Self-confident, self-starter, self-motivated, self-driven, self-reliant
- Assertive, aggressive, ruthlessly competitive
- Future-focused and strategic - sees the full 360-degree lay of the land
- Prioritizes time based on ROI - trades in time and money
- Willing to confront - conflict is just a means to an end
- "Enough equals more" - always raises the bar, never satisfied
- Opinionated - typically thinks they're the smartest person in the room

**Challenges:**
- Single hardest trait to employ - they work for "me, Inc." first
- "You are only RENTING high A's" - need mutually beneficial partnership
- Kryptonite is people - people will consistently disappoint them
- May take matters into their own hands when others "move too slow"
- Can LEAD (vision, strategy) but struggle to MANAGE (routine operations)

**Best Fit Roles:** Leadership, sales, entrepreneurship, strategy

**Communicating with High A's:**
- Use bullet points focused on ROI - they won't read walls of text
- "Bake me a cake" approach: Give outcomes, not step-by-step instructions
- Get buy-in through questions, not statements - let them "own" the idea
- Prefer variable compensation (bonus, equity, commission) over fixed salary

**Who High A's Respect:**
- People ahead of them (mentors, more successful peers)
- People with inner confidence who aren't threatened by them
- NOT people who capitulate or seem "weak"

</high_a>

<low_a side="left">

**Characteristics:**
- Helpful, supportive, service-oriented, accommodating, peaceful
- Servant leadership orientation - "what do WE need to win"
- Tactical and present-focused (vs high A's strategic future-focus)
- Excel at execution once direction is clear
- Team-oriented - finds genuine satisfaction in supporting others' success
- Prefers direction before acting - doesn't initiate on their own

**Challenges:**
- Indecisive with NEW challenges - need frameworks, precedents, or direction
- Conflict averse - may agree to things they don't support to keep peace
- May be put in leadership roles they didn't seek (and will burn out)
- Can appear passive when waiting for direction

**Best Fit Roles:** Support roles, customer service, collaborative teams, execution

**Managing Low A's:**
- Provide specific praise, not general ("Great job on the Johnson proposal")
- Offer consistent, predictable compensation over variable bonuses
- Give clear frameworks for novel decisions
- Don't interpret conflict avoidance as agreement - probe for true concerns

</low_a>

<leadership_styles>

| Style | Trait | Mindset | Characteristics |
|-------|-------|---------|-----------------|
| ABL (Action Based Leadership) | High A | "What do I need to win?" | Self-directed, competitive, drives from front |
| WPL (Wolf Pack Leadership) | Low A | "What do WE need to win?" | Collaborative, consensus-building, servant leadership |

Neither is better - depends on context. High-growth/turnaround may need ABL. Stable/complex operations may benefit from WPL.

</leadership_styles>

</trait>

<trait name="B" color="yellow" label="Social Ability">

Measures need for social interaction and persuasion.

<high_b side="right">

**Characteristics:**
- Dual nature: Social competence (skill to connect) + need for acceptance (drive to connect)
- Verbal processors - "think out loud." First statement isn't final position.
- Relational equity required - must build relationship BEFORE discussing tasks
- Culture builders - create positive atmosphere, the "fun part of the zoo"
- Energized by people, drained by isolation
- Fear: rejection, exclusion, being disliked

**Managing High B's:**
- Words of affirmation are primary currency - verbal praise, public recognition
- Allow small talk - it's not wasted time, it's relationship investment
- Include them in group activities and social events
- Don't isolate them with solo work for extended periods
- Note: With Low C, they become "sprayers" - lots of fast talking

**Best Fit Roles:** Sales, PR, public speaking, management, team building

</high_b>

<low_b side="left">

**Characteristics:**
- "There for the work" - not for relationships. Socializing feels like a tax.
- Prefer solitary or small-group work environments
- Process internally before speaking - silence does not equal disengagement
- Analytical, reserved, focused - ideal for deep work
- Fear: being forced into social situations, public attention

**Managing Low B's:**
- Leave them alone - minimize unnecessary check-ins
- Email/async preferred over meetings - let them process in writing
- Private recognition - public praise is uncomfortable
- Thoughtful gifts > verbal praise (a useful book means more than "great job")
- Quality time: meaningful 1:1 > group settings
- Don't mistake quiet for disengagement or unhappiness

**Best Fit Roles:** Engineering, accounting, research, coding, analysis

</low_b>

</trait>

<trait name="C" color="blue" label="Pace/Patience">

Measures patience, urgency, and rate of motion. **Force multiplier** - intensifies or calms how other traits manifest.

**Analogy:** High C = scheduled surgeons (focused, present, deliberate). Low C = emergency room operators (spinning plates, time-sensitive, variety).

<high_c side="right">

**Characteristics:**
- Patient, steady, calm, consistent, resists sudden change
- Extended focus capability - can concentrate for long periods
- **28-minute recovery** from interruptions - protect their focus time
- Sequential, systematic processing - one thing at a time
- Checklist oriented - give structured approaches, they'll follow exactly
- Consistency preferred - same desk, schedule, tools
- Patient with complexity - will work through problems methodically

**Managing High C's:**
- Send meeting agendas in advance - no surprises
- One meeting, one topic - multi-topic meetings are stressful
- Protect them from frequent interruptions
- Provide predictable schedules and environments
- Give advance notice of changes

**Best Fit Roles:** Administrative work, long-term projects, routine tasks, operations

</high_c>

<low_c side="left">

**Characteristics:**
- Impatient, quick, fast, restless, multifocused, intense, urgent
- Zero to 60 immediately - instant attention ramp-up
- Short attention span - a bit of ADD tendency
- Change agents - open to change primarily because they get bored easily
- Struggle staying in the moment - constantly thinking "what's next?"
- If D is not high: procrastination ("if I wait to the last minute, it only takes a minute")
- Overextension/over-scheduling - overestimate how much they can accomplish

**Pluses:**
- Create urgency and drive results (GSD - get stuff done)
- Good with variety and pivots - pivot faster than high C
- Good under pressure/stress (even if they look animated/hair on fire)
- Firefighters - when attention turns to something, they're fully engaged

**Minuses:**
- Can spin up others unnecessarily - disruptive when situation doesn't warrant urgency
- Interrupt others ("Did you get that email? Did you get back to me?")
- Moving fast leads to errors (especially without high D to catch mistakes)
- Get bored easily - often over-promoted because "can I help?" is misread as ambition

**Low C Motivators:**
- Variety - keep them busy, load them up
- Evolving, changing environments - thrive in consistent pivots
- Movement (mental or physical) in their day
- Fires to fight - creative problems to solve
- **DEADLINES** - critical motivator. Put deadlines in email subject lines.

**Best Fit Roles:** Startups, emergency response, rapid-fire environments

</low_c>

<c_as_modifier>

C acts as a **force multiplier** for other traits:

**Low C (Intensifier):** Adds urgency and "violence" to other traits
- High B + Low C = Proactively social, "buzzing around," many shorter conversations
- High D + Low C = Mistakes get called out QUICKLY
- High A + Low C = Aggressive, impatient driver who demands results NOW

**High C (Sedative):** Calms and steadies other traits
- High B + High C = Better listener, deeper conversations
- High D + High C = Notices issues but approaches steadily, might fix it themselves quietly
- High A + High C = Strategic and determined, but willing to wait for the right moment

</c_as_modifier>

</trait>

<trait name="D" color="green" label="Conformity">

Measures attention to detail, rules, and structure. **Third confidence trait** - confidence rooted in knowledge and competency.

<high_d side="right">

**Characteristics:**
- Accurate, careful, detail-oriented, historical, specific, micro-organized
- **Need SOPs** - must lay "railroad tracks" for them to stay on track
- Won't feel comfortable doing anything until they've mastered it - "no" until "know"
- Look back to see what the measurement is before acting (historical mindset)
- High levels of self-discipline and self-management
- Their own worst critic - take themselves "behind the woodshed" when they make mistakes
- Long memories - remember nitpicky particulars, including who failed them in 2018
- Currency they trade in is knowledge - all the certifications

**Pluses:**
- Reliable, dependable, consistent quality
- Executors and finishers - sustain and maintain things, circle back around
- Highly accountable - will do what they say
- Risk mitigation experts - defenders of what's right, defenders of the truth
- Good delegation targets - when you delegate to them, certainty they'll do it well (if properly defined)
- Quality control, compliance, operational excellence backbone

**Minuses:**
- Lost without SOPs - struggle outside the box, inflexible, rigid
- Uncomfortable when asked to do something beyond normal role
- Don't naturally delegate - hard to trust others, becomes bottleneck
- Long memories can lead to grudge-holding
- Critical - find the flaw, focus on what's wrong (even when 9 of 10 things are right)
- Judgmental - "I give 110%, you should too"
- Thin-skinned and blame-avoidant when confronted personally

**High D Motivators:**
- Don't make it personal - frame as process improvement, not personal failure
- Training and learning opportunities - the currency is knowledge
- Structured, accountable environment
- Recognition for hard work - but ONLY if deserved
- Fair pay based on education, experience, market rates
- Trust - huge word for high Ds. Don't break it.

**Best Fit Roles:** Finance, compliance, quality control, legal, security, ops

</high_d>

<low_d side="left">

**Characteristics:**
- Non-conforming, out of the box, free-spirited, conceptual, casual, flexible
- Don't need historical context or proof of concept to experiment
- Every day is a new day - shorter recall, don't hold on to yesterday
- Really good at getting things 80% done, then need others for maintenance/finishing
- Unfiltered - don't always mind their p's and q's
- Rules are meant to be interpreted, bent, broken

**Pluses:**
- Willingness to delegate (opposite of high D)
- Flexible and resilient - don't see limitations
- Creative brainstorming partners - look at things in non-traditional ways
- Good with innovation and experimentation
- Shorter recall = resiliency (get kicked in the mouth today, blank slate tomorrow)

**Minuses:**
- Inconsistent follow-through - out of sight, out of mind
- Forgetful - need systems/automation to catch things
- Sloppy execution when disinterested
- Don't always stay in their lane - don't see lanes as much
- Won't circle back on finer details without systems

**Low D Motivators:**
- Creative problems to solve - give them something to figure out
- Room to run - freedom from too much structure and too many rules
- Options - don't box them in, offer choices
- Pick your battles - focus on the 3 things that financially move the needle

**Best Fit Roles:** Strategy, creative roles, R&D, visionary leadership

</low_d>

<key_relationship>

"The A starts, the D finishes."

- A initiates and drives; D executes and completes
- Building NEW processes: High A + High D = architects, scholars, technical experts
- Optimizing EXISTING processes: Low A + High D = specialists

**Independence Types:**
- High A independence: "I have a goal, I have a plan, I don't care if anyone follows me"
- Low D independence: "Don't control me. Don't tell me not to do something."
- Most independent people: High A + Low D
- Greatest risk takers: High A + Low D
- Most risk averse: Low A + High D

</key_relationship>

</trait>
