<required_reading>

**Read these reference files before coaching:**
1. `references/primary-traits.md` - A, B, C, D trait details and management approaches
2. `references/secondary-traits.md` - EU, L, I traits
3. `references/patterns-archetypes.md` - Pattern identification

</required_reading>

<purpose>

Help managers work more effectively with their direct reports by comparing Culture Index profiles and providing specific coaching recommendations. This workflow translates trait differences into actionable management adjustments.

</purpose>

<process>

**Step 1: Load Both Profiles**

Gather the manager and direct report's profiles:

```
Manager: [Name]
- Pattern: [Archetype]
- A: [position relative to arrow]
- B: [position relative to arrow]
- C: [position relative to arrow]
- D: [position relative to arrow]
- EU Survey/Job: [values]

Direct Report: [Name]
- Pattern: [Archetype]
- A: [position relative to arrow]
- B: [position relative to arrow]
- C: [position relative to arrow]
- D: [position relative to arrow]
- EU Survey/Job: [values]
```

**Step 2: Calculate Trait Gaps**

For each trait, calculate the gap between manager and direct report:

| Trait | Manager | Direct Report | Gap | Friction Risk |
|-------|---------|---------------|-----|---------------|
| A | [pos] | [pos] | [diff] | [Low/Med/High] |
| B | [pos] | [pos] | [diff] | [Low/Med/High] |
| C | [pos] | [pos] | [diff] | [Low/Med/High] |
| D | [pos] | [pos] | [diff] | [Low/Med/High] |

**Friction risk guide:**
- Same side of arrow, similar distance: Low friction
- Same side of arrow, different distance: Medium friction
- Opposite sides of arrow: High friction potential

**Step 3: Identify Primary Friction Points**

Flag the largest gaps (opposite sides of arrow or >3 centile difference):

| Gap | Manager Tendency | Direct Report Need | Friction Source |
|-----|------------------|-------------------|-----------------|
| [Trait] | [behavior] | [behavior] | [conflict] |

**Common friction patterns:**

| Manager | Direct Report | Friction |
|---------|---------------|----------|
| High A | Low A | Manager expects initiative; report waits for direction |
| Low A | High A | Manager collaborates; report acts independently |
| High B | Low B | Manager wants connection; report wants to work |
| Low B | High B | Manager skips rapport; report needs relationship first |
| High C | Low C | Manager methodical; report impatient |
| Low C | High C | Manager creates urgency; report resists rush |
| High D | Low D | Manager detail-focused; report big-picture |
| Low D | High D | Manager flexible; report needs structure |

**Step 4: Generate Communication Adjustments**

Based on direct report's traits, recommend specific adjustments:

**If direct report is High A:**
- Use bullet points focused on ROI, not paragraphs
- Give outcomes ("bake me a cake"), not step-by-step instructions
- Ask questions to get buy-in, don't dictate
- Allow autonomy - avoid micromanagement
- Be direct and confident - they don't respect hesitation

**If direct report is Low A:**
- Provide specific direction before expecting action
- Give frameworks for novel decisions
- Offer specific praise, not general ("Great job on X")
- Probe for concerns - silence doesn't mean agreement
- Don't misread helpfulness as ambition

**If direct report is High B:**
- Allow time for rapport before tasks
- Verbal praise and public recognition matter
- Include in social activities
- Don't isolate with extended solo work
- Remember: first statement isn't final position (verbal processor)

**If direct report is Low B:**
- Minimize unnecessary check-ins
- Use async communication (email) over meetings
- Private recognition, not public praise
- Thoughtful gestures over verbal affirmation
- Don't mistake quiet for disengagement

**If direct report is High C:**
- Send agendas in advance
- One topic per meeting
- Protect their focus time (28-min recovery from interruptions)
- Provide advance notice of changes
- Give structured, sequential instructions

**If direct report is Low C:**
- Put deadlines in subject lines
- Keep them busy with variety
- Expect them to interrupt - plan for it
- Use their urgency productively
- Don't be surprised by over-commitment

**If direct report is High D:**
- Frame feedback as process improvement, not personal criticism
- Provide training/learning opportunities
- Don't break trust - they have long memories
- Build SOPs for new responsibilities
- Recognize their attention to quality

**If direct report is Low D:**
- Give creative problems to solve
- Provide options, not mandates
- Build systems to catch their gaps
- Focus on the 3 things that matter most
- Accept 80% completion; assign finishers

**Step 5: Design 1:1 Structure**

Based on trait comparison, recommend 1:1 format:

**Frequency:**
- Low A direct report: More frequent (weekly)
- High A direct report: Less frequent (bi-weekly or as needed)
- High C direct report: Consistent schedule, same time/day
- Low C direct report: Flexible timing, short check-ins ok

**Duration:**
- High B direct report: Allow buffer for rapport
- Low B direct report: Keep focused and efficient
- High C direct report: Single-topic, predictable length
- Low C direct report: Can be shorter, faster-paced

**Format:**
- High D direct report: Structured agenda, action items
- Low D direct report: Flexible, allow tangents
- High B direct report: Start with personal connection
- Low B direct report: Start with business

**Sample 1:1 template for [Direct Report's Pattern]:**
```
1. [Opening based on B trait]
2. [Agenda item structure based on C/D traits]
3. [Feedback approach based on A trait]
4. [Closing/action items based on D trait]
```

**Step 6: Identify Motivators**

Based on direct report's profile, their primary motivators are:

| Trait Position | Motivator | Implementation |
|----------------|-----------|----------------|
| High A | Autonomy, ROI, winning | Give ownership, variable comp |
| Low A | Clear direction, team success | Specific praise, stable comp |
| High B | Acceptance, inclusion | Verbal praise, team activities |
| Low B | Privacy, focus time | Leave alone, private recognition |
| High C | Stability, predictability | Consistent routines, advance notice |
| Low C | Variety, deadlines | Keep busy, clear deadlines |
| High D | Knowledge, trust | Training, recognition for quality |
| Low D | Freedom, options | Creative problems, flexibility |

**Step 7: Flag Energy Concerns**

Check EU utilization:
- Survey EU: [value]
- Job EU: [value]
- Utilization: [Job/Survey × 100]%

| Utilization | Status | Action |
|-------------|--------|--------|
| 70-130% | Healthy | Maintain current approach |
| <70% | Frustration | Address mismatch - discuss role engagement |
| >130% | Stress | Direct report is overextending |

**Step 8: Compile Coaching Summary**

```markdown
## Manager Coaching Guide: [Manager] → [Direct Report]

**Date:** [Date]
**Manager Pattern:** [Archetype]
**Direct Report Pattern:** [Archetype]

### Key Trait Gaps
| Trait | Gap | Adjustment Needed |
|-------|-----|-------------------|
| [Trait] | [difference] | [specific adjustment] |

### Communication Style Adjustments
1. [Specific adjustment based on their traits]
2. [Specific adjustment based on their traits]
3. [Specific adjustment based on their traits]

### 1:1 Recommendations
- **Frequency:** [recommendation]
- **Duration:** [recommendation]
- **Format:** [recommendation]
- **Opening:** [how to start based on B trait]
- **Feedback:** [how to deliver based on A/D traits]

### Primary Motivators
1. [Motivator 1] - [how to implement]
2. [Motivator 2] - [how to implement]

### Watch Areas
- [Potential friction point 1]
- [Potential friction point 2]

### Energy Status
- EU Utilization: [percentage]
- Status: [Healthy/Watch/Concern/Stress]
- Action: [if any]

### Things to Avoid
- [Anti-pattern for this direct report]
- [Anti-pattern for this direct report]
```

</process>

<anti_patterns>

Avoid these coaching mistakes:

- **Expecting them to change**: Survey traits are hardwired - change the environment, not the person
- **Projecting your motivators**: What motivates you may demotivate them
- **One-size-fits-all 1:1s**: Adapt format to their profile
- **Ignoring EU signals**: Low utilization predicts disengagement and flight risk
- **Treating gaps as problems**: Different profiles bring complementary strengths
- **Forgetting your own biases**: Your profile affects how you perceive theirs

</anti_patterns>

<success_criteria>

Manager coaching is complete when:
- [ ] Both profiles loaded and compared
- [ ] All trait gaps calculated with friction risk
- [ ] Primary friction points identified
- [ ] Communication adjustments specified for each major trait
- [ ] 1:1 structure designed for their profile
- [ ] Motivators identified with implementation suggestions
- [ ] EU utilization checked and flagged if concerning
- [ ] Watch areas documented
- [ ] Anti-patterns for this pairing noted

</success_criteria>
