<required_reading>

**Read these reference files before comparing:**
1. `references/primary-traits.md` - Trait details
2. `references/secondary-traits.md` - L and I interpretation

</required_reading>

<process>

**Step 1: Load Both Profiles**

For each person, record:
- Name
- Pattern/Archetype
- Arrow position
- All trait distances from arrow (A, B, C, D)
- L and I absolute values
- EU values

**Step 2: Create Comparison Table**

| Trait | Person A Distance | Person B Distance | Difference | Notes |
|-------|-------------------|-------------------|------------|-------|
| A | +/- X from arrow | +/- X from arrow | | |
| B | +/- X from arrow | +/- X from arrow | | |
| C | +/- X from arrow | +/- X from arrow | | |
| D | +/- X from arrow | +/- X from arrow | | |
| L | [absolute] | [absolute] | | |
| I | [absolute] | [absolute] | | |

**Remember**: Compare DISTANCES from arrow, not absolute values (except L and I).

**Step 3: Identify Similar Traits**

Traits where both people fall on the same side of their arrow (both high or both low):

- [Trait]: Both high/low - [implication]

Similarity creates:
- Shared understanding
- Similar communication style
- Potential blind spots (both miss same things)

**Step 4: Identify Opposite Traits**

Traits where people fall on opposite sides of their arrows:

- [Trait]: Person A high, Person B low - [implication]

Opposites create:
- Potential friction
- Complementary strengths (if managed well)
- Need for intentional bridging

**Step 5: Assess Major Friction Points**

| Combination | Friction | Mitigation |
|-------------|----------|------------|
| High A vs Low A | Independence expectations clash | High A gives direction, respects Low A's collaborative needs |
| High B vs Low B | Social needs mismatch | High B allows Low B alone time; Low B tolerates some small talk |
| High C vs Low C | Pace mismatch | Low C respects High C's focus time; High C accepts some urgency |
| High D vs Low D | Detail orientation clash | High D accepts "good enough"; Low D follows through on commitments |

Document specific friction points for this pair.

**Step 6: Assess Communication Compatibility**

| Person A | Person B | Communication Challenge |
|----------|----------|-------------------------|
| High A | Low A | High A may steamroll; Low A may not push back |
| High B | Low B | High B needs verbal processing; Low B prefers written |
| High C | Low C | High C needs advance notice; Low C creates urgency |
| High D | Low D | High D wants specifics; Low D gives big picture |

**Step 7: Compare L (Logic) and I (Ingenuity)**

These use absolute values - direct comparison is valid.

**Logic comparison:**
| Person A Logic | Person B Logic | Dynamic |
|----------------|----------------|---------|
| Both High (8-10) | Both High (8-10) | Rational discussions, may seem cold to others |
| Both Low (0-2) | Both Low (0-2) | Emotional connection, may escalate together |
| One High, One Low | - | Potential misunderstanding; High L may dismiss Low L's concerns |

**Ingenuity comparison:**
| Person A Ingenuity | Person B Ingenuity | Dynamic |
|--------------------|-------------------|---------|
| Both High (7-10) | Both High (7-10) | Creative brainstorming, may lack grounding |
| Both Low (0-2) | Both Low (0-2) | Practical focus, may miss innovative solutions |
| One High, One Low | - | High I may frustrate Low I with abstract ideas |

**Step 8: Identify Complementary Strengths**

Where opposites create value:

- Person A brings [trait/strength], Person B brings [trait/strength]
- Together they cover [gap that neither would alone]

Example:
- High A (Person A) + High D (Person B) = "A starts, D finishes"
- High B (Person A) + Low B (Person B) = "One builds relationships, one does deep work"

**Step 9: Leadership/Collaboration Dynamics**

If one person leads the other:

| Leader Trait | Follower Trait | Dynamic |
|--------------|----------------|---------|
| High A leading Low A | Works well if High A provides direction |
| Low A leading High A | High A may not respect, may take over |
| High D leading Low D | Low D may feel micromanaged |
| Low D leading High D | High D may feel unsupported |

**Step 10: Compile Comparison Summary**

```
## Profile Comparison: [Person A] vs [Person B]

### Quick View
| | Person A | Person B |
|---|----------|----------|
| Pattern | [Archetype] | [Archetype] |
| Primary Driver | [Leading trait] | [Leading trait] |
| Logic | [X] | [X] |
| Ingenuity | [X] | [X] |

### Trait Comparison (Relative to Arrow)
| Trait | Person A | Person B | Alignment |
|-------|----------|----------|-----------|
| A | +/- X | +/- X | Same/Opposite |
| B | +/- X | +/- X | Same/Opposite |
| C | +/- X | +/- X | Same/Opposite |
| D | +/- X | +/- X | Same/Opposite |

### Similarities
- [Shared trait 1]: [Implication]
- [Shared trait 2]: [Implication]

### Differences
- [Opposite trait 1]: [Friction risk and opportunity]
- [Opposite trait 2]: [Friction risk and opportunity]

### Friction Points
1. [Specific friction]: [Mitigation strategy]
2. [Specific friction]: [Mitigation strategy]

### Complementary Strengths
1. [How they complement each other]
2. [What they cover together]

### Communication Recommendations
- Person A should: [Specific advice]
- Person B should: [Specific advice]

### Collaboration Forecast
[Overall assessment: Natural fit / Workable with effort / High friction / Complementary opposites]
```

</process>

<anti_patterns>

Avoid these comparison mistakes:

- **Comparing absolute values**: "Person A has a 7, Person B has a 4" is meaningless
- **Assuming same = better**: Opposite traits often create complementary value
- **Ignoring context**: Collaboration needs depend on the work being done
- **Overlooking L and I**: These ARE comparable directly and affect dynamics
- **Binary thinking**: It's not "compatible" or "incompatible" - it's about managing dynamics

</anti_patterns>

<success_criteria>

Profile comparison is complete when:
- [ ] Both profiles loaded with arrow positions
- [ ] All traits compared using relative distances
- [ ] Similarities identified with implications
- [ ] Differences identified with friction risks
- [ ] L and I compared directly
- [ ] Complementary strengths noted
- [ ] Communication recommendations provided
- [ ] Collaboration forecast given
- [ ] No absolute value comparisons used (except L and I)

</success_criteria>
