<required_reading>

**Read these reference files before planning onboarding:**
1. `references/primary-traits.md` - A, B, C, D trait details and communication styles
2. `references/team-composition.md` - Gas/Brake/Glue and conflict pairs
3. `references/patterns-archetypes.md` - Pattern identification

</required_reading>

<purpose>

Plan effective onboarding for a new hire using their Culture Index profile and the team's profiles. This workflow identifies likely allies, potential friction points, and provides specific recommendations for the first 90 days.

**Context:** This workflow is typically used after the new hire has signed their offer and completed the CI survey, but before their start date.

</purpose>

<process>

**Step 1: Load New Hire Profile**

```
New Hire: [Name]
Start Date: [Date]
Role: [Title]
Reports To: [Manager name]

Profile:
- Pattern: [Archetype]
- A: [position relative to arrow]
- B: [position relative to arrow]
- C: [position relative to arrow]
- D: [position relative to arrow]
- L: [absolute value]
- I: [absolute value]
- EU Survey: [value]
```

**If comparing to predicted profile (from interview):**
| Trait | Predicted | Actual | Delta |
|-------|-----------|--------|-------|
| A | [pred] | [actual] | [diff] |
| B | [pred] | [actual] | [diff] |
| C | [pred] | [actual] | [diff] |
| D | [pred] | [actual] | [diff] |

Note any significant differences for onboarding planning.

**Step 2: Load Team Profiles**

List immediate team members:

| Name | Pattern | A | B | C | D | Role |
|------|---------|---|---|---|---|------|
| [Manager] | [pattern] | [pos] | [pos] | [pos] | [pos] | Manager |
| [Peer 1] | [pattern] | [pos] | [pos] | [pos] | [pos] | [role] |
| [Peer 2] | [pattern] | [pos] | [pos] | [pos] | [pos] | [role] |

**Team Composition:**
- Gas (High A): [count] people
- Brake (High D): [count] people
- Glue (High B): [count] people

**Step 3: Identify Natural Allies**

Find team members with compatible profiles:

**High compatibility indicators:**
- Similar pattern/archetype
- Similar B position (social energy match)
- Similar C position (pace match)
- Complementary traits (their strength helps their gap)

| Team Member | Compatibility | Reason |
|-------------|---------------|--------|
| [Name] | High | [trait similarity or complement] |
| [Name] | Medium | [partial match] |

**Recommended buddy/mentor:**
- Primary: [Name] - [reason for pairing]
- Secondary: [Name] - [reason for backup]

**Step 4: Flag Potential Friction Points**

Find team members with opposite profiles:

| Team Member | Friction Risk | Source | Mitigation |
|-------------|---------------|--------|------------|
| [Name] | High | [opposite trait] | [suggestion] |
| [Name] | Medium | [gap] | [suggestion] |

**Common friction sources:**
- High A vs Low A: Independence vs collaboration expectations
- High B vs Low B: Social needs mismatch
- High C vs Low C: Pace/urgency mismatch
- High D vs Low D: Detail orientation mismatch

**Step 5: Manager Compatibility Assessment**

Compare new hire to their manager:

| Trait | Manager | New Hire | Gap | Adjustment Needed |
|-------|---------|----------|-----|-------------------|
| A | [pos] | [pos] | [diff] | [manager adjustment] |
| B | [pos] | [pos] | [diff] | [manager adjustment] |
| C | [pos] | [pos] | [diff] | [manager adjustment] |
| D | [pos] | [pos] | [diff] | [manager adjustment] |

**Manager coaching points:**
- [Specific adjustment for this new hire]
- [Specific adjustment for this new hire]

**Step 6: Design First 30 Days**

Based on new hire's profile:

**Week 1 - Orientation:**

| If New Hire Is... | Orientation Approach |
|-------------------|---------------------|
| High A | Give autonomy early, avoid over-managing, focus on outcomes |
| Low A | Provide clear direction, structured intro, defined expectations |
| High B | Introduce to team quickly, social activities, relationships first |
| Low B | Gradual introductions, 1:1 over group, respect alone time |
| High C | Predictable schedule, one thing at a time, advance notice |
| Low C | Variety early, multiple projects, don't over-structure |
| High D | Documented processes, clear SOPs, training materials |
| Low D | Big picture context, creative problems, flexibility |

**Your Week 1 approach:**
- [Specific recommendation based on their traits]
- [Specific recommendation based on their traits]
- [Specific recommendation based on their traits]

**Weeks 2-4 - Integration:**

| Priority | Action | Why (based on profile) |
|----------|--------|------------------------|
| 1 | [action] | [trait-based reason] |
| 2 | [action] | [trait-based reason] |
| 3 | [action] | [trait-based reason] |

**Step 7: Design 30-60 Days**

| Focus Area | Approach for This Profile |
|------------|---------------------------|
| Feedback style | [Based on A and D traits] |
| Meeting cadence | [Based on B and C traits] |
| Project type | [Based on I and pattern] |
| Independence level | [Based on A trait] |
| Check-in format | [Based on B and C traits] |

**Milestones to target:**
- Day 30: [milestone appropriate for their pattern]
- Day 45: [milestone appropriate for their pattern]
- Day 60: [milestone appropriate for their pattern]

**Step 8: Design 60-90 Days**

At this stage, focus on:

| If New Hire Is... | 60-90 Day Focus |
|-------------------|-----------------|
| High A | Expand scope, give ownership of projects |
| Low A | Establish regular collaboration patterns |
| High B | Integrate into team social fabric, culture building |
| Low B | Ensure solo time is protected, deep work established |
| High C | Consistent routines established, predictable workflow |
| Low C | Multiple concurrent projects, varied work |
| High D | Mastery of key processes, becoming the expert |
| Low D | Creative challenges, problem-solving opportunities |

**Success indicators by Day 90:**
- [ ] [Indicator appropriate for their pattern]
- [ ] [Indicator appropriate for their pattern]
- [ ] [Indicator appropriate for their pattern]

**Step 9: Prepare Manager Briefing**

Create a one-page briefing for the manager:

```markdown
## Onboarding Briefing: [New Hire Name]

**Start Date:** [Date]
**Pattern:** [Archetype]

### Key Traits to Understand
| Trait | Position | What It Means |
|-------|----------|---------------|
| [Leading trait] | [High/Low] | [one-line implication] |
| [Second trait] | [High/Low] | [one-line implication] |

### Communication Style
- **Prefer:** [based on traits]
- **Avoid:** [based on traits]
- **Feedback:** [how to deliver based on A/D]

### What Motivates Them
1. [Motivator based on profile]
2. [Motivator based on profile]

### Potential Friction Areas
- With [team member]: [friction source and mitigation]

### Recommended Buddy
[Name] - [reason for pairing]

### First Week Priorities
1. [Priority based on their traits]
2. [Priority based on their traits]
3. [Priority based on their traits]

### Red Flags to Watch
- [Signal that they're struggling, based on profile]
- [Signal that they're struggling, based on profile]
```

**Step 10: Compile Full Onboarding Plan**

```markdown
## Onboarding Plan: [New Hire Name]

**Prepared:** [Date]
**Start Date:** [Start Date]
**Role:** [Title]
**Manager:** [Manager Name]

### Profile Summary
- **Pattern:** [Archetype]
- **Key Traits:** [Top 2-3 trait positions]
- **EU:** [Survey value]

### Team Integration

**Natural Allies:**
- [Name] - [reason]

**Potential Friction:**
- [Name] - [source and mitigation]

**Recommended Buddy:** [Name]

### Manager Adjustments
1. [Adjustment based on trait gap]
2. [Adjustment based on trait gap]

### First 90 Days

**Week 1:**
- [Specific action]
- [Specific action]

**Days 8-30:**
- [Focus area]
- [Focus area]

**Days 30-60:**
- [Focus area]
- [Focus area]

**Days 60-90:**
- [Focus area]
- [Focus area]

### Success Indicators
- Day 30: [indicator]
- Day 60: [indicator]
- Day 90: [indicator]

### Communication Preferences
- **Style:** [based on traits]
- **Frequency:** [based on C and B]
- **Format:** [based on traits]

### Motivators
1. [Primary motivator]
2. [Secondary motivator]

### Watch Areas
- [Signal they're struggling]
- [Common challenge for this pattern]

### Notes
- [Any prediction vs actual differences]
- [Any special considerations]
```

</process>

<anti_patterns>

Avoid these onboarding mistakes:

- **One-size-fits-all onboarding**: Adjust approach based on their traits
- **Ignoring manager compatibility**: Manager adjustments are critical for retention
- **Assigning random buddies**: Match based on profile compatibility
- **Over-socializing Low B's**: Respect their need for alone time
- **Under-socializing High B's**: Include them quickly or they'll feel excluded
- **Rushing High C's**: Give them time to settle into routines
- **Boring Low C's**: Keep them engaged with variety
- **Surprising High D's**: Provide structure and documentation

</anti_patterns>

<success_criteria>

Onboarding plan is complete when:
- [ ] New hire profile loaded and analyzed
- [ ] Predicted vs actual comparison noted (if applicable)
- [ ] All team profiles loaded
- [ ] Natural allies identified with buddy recommendation
- [ ] Friction points flagged with mitigations
- [ ] Manager compatibility assessed with adjustments
- [ ] First 30 days designed based on traits
- [ ] 30-60 day plan created
- [ ] 60-90 day plan created
- [ ] Manager briefing prepared
- [ ] Success indicators defined
- [ ] Watch areas documented

</success_criteria>
