---
name: transaction-audit
description: Orchestrate V2 transaction documentation by tracking all endpoints and delegating analysis to /analyze-transaction
---

<introduction>
This skill is the **project manager** for V2 transaction documentation. It tracks all transaction endpoints from the Atlas API swagger and coordinates analysis work.

**Source of Truth**: https://atlas-api-preprod-507341199760.us-central1.run.app/swagger.json

**Worker Skill**: Use `/analyze-transaction` to process individual transactions.

**Tracking File**: `.claude/skills/transaction-audit/v2-transaction-tracker.json`
</introduction>

<workflow>
## When Invoked

1. **Sync with Swagger** (if requested or stale)
   - Fetch latest swagger.json from Atlas API
   - Compare endpoints to tracker
   - Add any new endpoints, flag any removed ones

2. **Display Status Dashboard**
   - Show summary: X analyzed, Y not-analyzed, Z verified
   - List transactions by system (global, instance, course, project)
   - Highlight path misalignments between swagger and existing files

3. **Identify Work Needed**
   - List transactions with `not-analyzed` status
   - List transactions with path misalignments (legacy files in wrong location)
   - Prioritize based on dependencies (e.g., access-token-mint before enrollments)

4. **Prompt for Action**
   - Offer to run `/analyze-transaction` for specific transactions
   - Offer to migrate legacy files to correct paths
   - Offer to mark transactions as verified after testing

## Commands

| Command | Description |
|---------|-------------|
| `/transaction-audit` | Show dashboard and status |
| `/transaction-audit sync` | Sync tracker with swagger.json |
| `/transaction-audit status` | Show summary counts only |
| `/transaction-audit next` | Suggest next transaction to analyze |
| `/transaction-audit analyze <id>` | Run /analyze-transaction for specific tx |
</workflow>

<statuses>
## Transaction Statuses

| Status | Meaning |
|--------|---------|
| `not-analyzed` | Known from swagger, no YAML/TS files created yet |
| `analyzed` | YAML + TS files created via /analyze-transaction |
| `verified` | Tested against live API, confirmed working |

## Status Transitions

```
not-analyzed → analyzed → verified
     ↑              ↓
     └──────────────┘ (if API changes)
```
</statuses>

<tracker-format>
## Tracker File Structure

```json
{
  "version": "1.0.0",
  "lastUpdated": "YYYY-MM-DD",
  "swaggerSource": "https://atlas-api-preprod-507341199760.us-central1.run.app/swagger.json",
  "totalTransactions": 17,
  "summary": {
    "analyzed": N,
    "not-analyzed": N,
    "verified": N
  },
  "transactions": [
    {
      "id": "system.role.action",
      "endpoint": "/v2/tx/...",
      "method": "POST",
      "system": "global|instance|course|project",
      "role": "general|owner|teacher|student|manager|contributor",
      "description": "...",
      "status": "not-analyzed|analyzed|verified",
      "lastAnalyzed": "YYYY-MM-DD" | null,
      "files": {
        "yaml": "path/to/file.yaml" | null,
        "ts": "path/to/file.ts" | null,
        "mdx": "path/to/file.mdx" | null
      },
      "legacyFiles": {  // Only if path mismatch exists
        "yaml": "old/path.yaml",
        "note": "Migration needed"
      },
      "notes": "..."
    }
  ]
}
```
</tracker-format>

<file-paths>
## Path Alignment Rules

File paths MUST match the API endpoint structure:

| API Endpoint | YAML Path | TS Path |
|--------------|-----------|---------|
| `/v2/tx/{system}/{role}/{action}` | `{system}/{role}/{action}.yaml` | `{system}/{role}/{action}.ts` |

### Examples:
- `/v2/tx/global/general/access-token/mint` → `global/general/access-token/mint.yaml`
- `/v2/tx/course/student/assignment/commit` → `course/student/assignment/commit.yaml`
- `/v2/tx/project/contributor/task/commit` → `project/contributor/task/commit.yaml`

### Base Paths:
- YAML: `public/yaml/transactions/v2/`
- TS: `packages/andamio-transactions/src/definitions/v2/`
- MDX: `content/docs/protocol/v2/transactions/`
</file-paths>

<dependencies>
## Transaction Dependencies

Some transactions must be analyzed in order:

### Tier 1: Entry Points (no dependencies)
- `global.general.access-token.mint` - Required for all other transactions

### Tier 2: Instance Creation (requires access token)
- `instance.owner.course.create`
- `instance.owner.project.create`

### Tier 3: Management (requires instance)
- Course: `course.owner.teachers.manage`, `course.teacher.modules.manage`
- Project: `project.owner.managers.manage`, `project.owner.contributor-blacklist.manage`, `project.manager.tasks.manage`

### Tier 4: Participation (requires course/project)
- Course: `course.student.enroll`, `course.student.assignment.action`, `course.teacher.assignments.assess`, `course.student.credential.claim`
- Project: `project.contributor.enroll`, `project.contributor.task.commit`, `project.contributor.task.action`, `project.manager.tasks.assess`, `project.contributor.credential.claim`
</dependencies>

<dashboard-format>
## Dashboard Output Format

```
═══════════════════════════════════════════════════════════════
                 V2 TRANSACTION AUDIT DASHBOARD
═══════════════════════════════════════════════════════════════

Last Updated: YYYY-MM-DD
Swagger Source: https://atlas-api-preprod-507341199760.us-central1.run.app/swagger.json

SUMMARY
───────────────────────────────────────────────────────────────
Total: 17 | Analyzed: 1 | Not Analyzed: 16 | Verified: 0

BY SYSTEM
───────────────────────────────────────────────────────────────
Global (1):     ████████████████████ 100% [1/1]
Instance (2):   ░░░░░░░░░░░░░░░░░░░░   0% [0/2]
Course (6):     ░░░░░░░░░░░░░░░░░░░░   0% [0/6]
Project (8):    ░░░░░░░░░░░░░░░░░░░░   0% [0/8]

TRANSACTIONS
───────────────────────────────────────────────────────────────
[✓] global.general.access-token.mint
[ ] instance.owner.course.create          ⚠️ Legacy path mismatch
[ ] instance.owner.project.create
[ ] course.owner.teachers.manage          ⚠️ Legacy path mismatch
...

NEXT RECOMMENDED
───────────────────────────────────────────────────────────────
→ instance.owner.course.create (Tier 2, has legacy file to migrate)

To analyze: /analyze-transaction <paste decoded CBOR>
═══════════════════════════════════════════════════════════════
```
</dashboard-format>

<notes>
## Important Notes

1. **Swagger is the source of truth** - The tracker should always reflect what's in swagger.json
2. **Path alignment is mandatory** - All new files must match API URL structure
3. **Legacy files need migration** - Some old files exist at wrong paths; migrate them when analyzing
4. **Update tracker after analysis** - When /analyze-transaction completes, update the tracker
5. **Verify after testing** - Only mark as "verified" after testing against live API

## Related Skills

- `/analyze-transaction` - Worker skill that processes individual transaction CBORs
- `/glossary-game` - Terminology validation (different domain)
</notes>
