## Transaction Examples for Audit

### Access Token

Github: https://github.com/Andamio-Platform/access-token

2 validators:

- **IndexRef**:
    - Spending: Reference data like fee and init observers
        - update/add init observer: `63d254136af35d693cb5550f89955fef036df42c178e53205ba33dae93f26432`
- **Index**:
    - Minting: Access token policy (CIP68) / linked list
        - `0b5fccdccccbdf2030d676ec53dab8dda4043b6bd770c11dd2db1c38a59eb62f`
    - Spending: Check either Minting or Withdraw
        - see Minting
    - Withdraw: unlock if cardano protocol parameter change
        - no preprod transaction available, only private testnet

### Global State

Github: https://github.com/Andamio-Platform/plumbline-global-state

3 validators:

- **global-state**:
    - 4 actions: MintLocalState/BurnLocalState/DeleteState/MoveState
        - mint local state (course): `311cf9f4725de473ffd6c53ab3dcd8609f1dfd1a681a248b9a9fd7cb05cfd1e9`
        - burn local state (course): `f9d6769b2a03dc07b2689eb6fcbeae25cb8c3316fa130d758f8b26bf1710e5de`
        - delete local state: `2aa87b0ed5f0bca67fe5113bacd1bbfa80f86395b64d14fbf53507b55f7feeef`
- **init global state observer**: either initialize new empty one or transfer from v1 global state
    - `0b5fccdccccbdf2030d676ec53dab8dda4043b6bd770c11dd2db1c38a59eb62f` -> new access token minted to global state v2 with an empty state
    - migrate: `115e256e0714382bbbc0da022ca14a137045cbf9aea11291e2f8804897f3540b` -> global state v1 user migrated to new global state v2 validator, same state different (hashed representation)
        
- **local state registration**:
    - Minting: local state registration / un-register
        - mint: `e4311e26b45cbcf2c8baba1e26a92ae670462a03ae40e8d19b9fb3514027ddb7`
        - burn: `edc9afd217d39fa810ab286436c92c01f16aae533689b6c93e99d1d3c7998687`
    - Spending: un-register
- example local state: not necessary to audit, not for production just to give an idea what a local state can look like
