# Andamio Platform Transaction Audit

**Purpose**: This audit catalogs all transactions implemented in the Andamio platform app. Use this document to verify that all necessary transaction documentation exists in the andamio-docs repository.

**Generated**: 2025-10-03
**Registry Source**: `src/components/cardano/tx/andamio-transaction-list.ts`
**Cost Registry**: `src/components/cardano/tx/tx-cost-registry.ts`

---

## Transaction Summary

**Total Transactions**: 29

### By Role:
- **General**: 2 transactions
- **Admin**: 7 transactions
- **Student**: 5 transactions
- **Contributor**: 11 transactions
- **Course Creator**: 3 transactions
- **Project Creator**: 5 transactions

---

## Transaction Registry

### General Transactions

#### 1. MINT_ACCESS_TOKEN
- **Registry Key**: `MINT_ACCESS_TOKEN`
- **Role**: `general`
- **Transaction Name**: `access-token-mint`
- **Component**: `src/components/cardano/tx/access-token/MintAccessToken.tsx`
- **Button Text**: "Mint Access Token"
- **Title**: "Mint your Andamio Access Token"
- **Docs Link**: `/docs/protocol/v1/transactions/general/access-token-mint`
- **Andamio Fee**: 5 ADA (5000000 lovelace)
- **Has Admin Wallet**: No
- **Description**: Digital passport for Andamio - records credentials and enables project participation

#### 2. PUBLISH_TX
- **Registry Key**: `PUBLISH_TX`
- **Role**: `general`
- **Transaction Name**: `publish-tx`
- **Component**: `src/components/cardano/tx/publish/PublishTransaction.tsx`
- **Button Text**: "Publish"
- **Title**: "Publish Course/Project"
- **Docs Link**: `/docs/protocol/v1/transactions/general/publish-tx`
- **Andamio Fee**: Dynamic (150 ADA for course/project only, 250 ADA for both)
- **Min UTxOs**: PublishTx UTXO
- **Has Admin Wallet**: No
- **Description**: Publishes course or project to blockchain

---

### Admin Transactions

#### 3. INIT_COURSE
- **Registry Key**: `INIT_COURSE`
- **Role**: `admin`
- **Transaction Name**: `init-course`
- **Component**: `src/components/cardano/tx/admin/init-course/InitCourse.tsx`
- **Button Text**: "Initialize Course"
- **Title**: "Initialize Course"
- **Docs Link**: `/docs/protocol/v1/transactions/admin/init-course`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: Yes
- **Description**: Creates a new course on Andamio platform

#### 4. ADD_COURSE_CREATORS
- **Registry Key**: `ADD_COURSE_CREATORS`
- **Role**: `admin`
- **Transaction Name**: `add-course-creators`
- **Component**: `src/components/cardano/tx/admin/add-course-creators/AddCourseCreators.tsx`
- **Button Text**: "Add Course Creators"
- **Title**: "Add Course Creators"
- **Docs Link**: `/docs/protocol/v1/transactions/admin/add-course-creators`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: Yes
- **Description**: Grants course creator access to manage content and approve assignments

#### 5. RM_COURSE_CREATORS
- **Registry Key**: `RM_COURSE_CREATORS`
- **Role**: `admin`
- **Transaction Name**: `rm-course-creators`
- **Component**: `src/components/cardano/tx/admin/rm-course-creators/RmCourseCreators.tsx`
- **Button Text**: "Remove Course Creators"
- **Title**: "Remove Course Creators"
- **Docs Link**: `/docs/protocol/v1/transactions/admin/rm-course-creators`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: Yes
- **Description**: Removes creator access for selected alias

#### 6. INIT_PROJECT_STEP_1
- **Registry Key**: `INIT_PROJECT_STEP_1`
- **Role**: `admin`
- **Transaction Name**: `init-project-step-1`
- **Component**: `src/components/cardano/tx/admin/init-project-step-1/InitProjectStep1.tsx`
- **Button Text**: "Initialize Project Step 1"
- **Title**: "Initialize Project Step 1"
- **Docs Link**: `/docs/protocol/v1/transactions/admin/init-project-step-1`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: Yes
- **Description**: Creates a Treasury with Treasury NFT Policy Id

#### 7. INIT_PROJECT_STEP_2
- **Registry Key**: `INIT_PROJECT_STEP_2`
- **Role**: `admin`
- **Transaction Name**: `init-project-step-2`
- **Component**: `src/components/cardano/tx/admin/init-project-step-2/InitProjectStep2.tsx`
- **Button Text**: "Initialize Project Step 2"
- **Title**: "Initialize Project Step 2"
- **Docs Link**: `/docs/protocol/v1/transactions/admin/init-project-step-2`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: Yes
- **Description**: Connects Treasury to Prerequisite and creates Contributor Policy Id

#### 8. ADD_PROJECT_CREATORS
- **Registry Key**: `ADD_PROJECT_CREATORS`
- **Role**: `admin`
- **Transaction Name**: `add-project-creators`
- **Component**: `src/components/cardano/tx/admin/add-project-creators/AddProjectCreators.tsx`
- **Button Text**: "Add Project Creators"
- **Title**: "Add Project Creators"
- **Docs Link**: `/docs/protocol/v1/transactions/admin/add-project-creators`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: Yes
- **Description**: Grants project creator access to manage tasks and approve/deny commitments

#### 9. RM_PROJECT_CREATORS
- **Registry Key**: `RM_PROJECT_CREATORS`
- **Role**: `admin`
- **Transaction Name**: `rm-project-creators`
- **Component**: `src/components/cardano/tx/admin/rm-project-creators/RmProjectCreators.tsx`
- **Button Text**: "Remove Project Creators"
- **Title**: "Remove Project Creators"
- **Docs Link**: `/docs/protocol/v1/transactions/admin/rm-project-creators`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: Yes
- **Description**: Removes creator access for selected alias

---

### Student Transactions

#### 10. MINT_LOCAL_STATE
- **Registry Key**: `MINT_LOCAL_STATE`
- **Role**: `student`
- **Transaction Name**: `mint-local-state`
- **Component**: `src/components/cardano/tx/student/mint-local-state/MintLocalState.tsx`
- **Button Text**: "Enroll"
- **Title**: "Enroll in this course"
- **Docs Link**: `/docs/protocol/v1/transactions/student/mint-local-state`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: No
- **Description**: Enrolls student in course to begin learning

#### 11. BURN_LOCAL_STATE
- **Registry Key**: `BURN_LOCAL_STATE`
- **Role**: `student`
- **Transaction Name**: `burn-local-state`
- **Component**: `src/components/cardano/tx/student/burn-local-state/BurnLocalState.tsx`
- **Button Text**: "Complete Course"
- **Title**: "Exit Course and Claim Credentials"
- **Docs Link**: `/docs/protocol/v1/transactions/student/burn-local-state`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: No
- **Description**: Issues credentials for completed modules, allows re-enrollment

#### 12. COMMIT_TO_ASSIGNMENT
- **Registry Key**: `COMMIT_TO_ASSIGNMENT`
- **Role**: `student`
- **Transaction Name**: `commit-to-assignment`
- **Component**: `src/components/cardano/tx/student/commit-to-assignment/CommitToAssignment.tsx`
- **Button Text**: "Submit Assignment"
- **Title**: "Submit Assignment"
- **Docs Link**: `/docs/protocol/v1/transactions/student/commit-to-assignment`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: No
- **Description**: Submits assignment evidence for review

#### 13. UPDATE_ASSIGNMENT
- **Registry Key**: `UPDATE_ASSIGNMENT`
- **Role**: `student`
- **Transaction Name**: `update-assignment`
- **Component**: `src/components/cardano/tx/student/update-assignment/UpdateAssignment.tsx`
- **Button Text**: "Update Submission"
- **Title**: "Update Your Assignment"
- **Docs Link**: `/docs/protocol/v1/transactions/student/update-assignment`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: No
- **Description**: Revises submission or adds new information

#### 14. LEAVE_ASSIGNMENT
- **Registry Key**: `LEAVE_ASSIGNMENT`
- **Role**: `student`
- **Transaction Name**: `leave-assignment`
- **Component**: `src/components/cardano/tx/student/leave-assignment/LeaveAssignment.tsx`
- **Button Text**: "Withdraw Submission"
- **Title**: "Withdraw from Assignment"
- **Docs Link**: `/docs/protocol/v1/transactions/student/leave-assignment`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: No
- **Description**: Removes commitment to assignment, can recommit later

---

### Contributor Transactions

#### 15. MINT_PROJECT_STATE
- **Registry Key**: `MINT_PROJECT_STATE`
- **Role**: `contributor`
- **Transaction Name**: `mint-project-state`
- **Component**: `src/components/cardano/tx/contributor/mint-project-state/MintProjectState.tsx`
- **Button Text**: "Join Project"
- **Title**: "Join this Project"
- **Docs Link**: `/docs/protocol/v1/transactions/contributor/mint-project-state`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: No
- **Description**: Joins project based on credentials, can complete tasks and earn rewards

#### 16. BURN_PROJECT_STATE
- **Registry Key**: `BURN_PROJECT_STATE`
- **Role**: `contributor`
- **Transaction Name**: `burn-project-state`
- **Component**: `src/components/cardano/tx/contributor/burn-contributor-state/BurnContributorState.tsx`
- **Button Text**: "Record Contributions"
- **Title**: "Exit Project and Claim Credential"
- **Docs Link**: `/docs/protocol/v1/transactions/contributor/burn-project-state`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: No
- **Description**: Records contributions on Access Token, allows rejoin later

#### 17. COMMIT_PROJECT
- **Registry Key**: `COMMIT_PROJECT`
- **Role**: `contributor`
- **Transaction Name**: `commit-project`
- **Component**: `src/components/cardano/tx/contributor/commit-project/CommitProject.tsx`
- **Button Text**: "Commit"
- **Title**: "Commit to this Task"
- **Docs Link**: `/docs/protocol/v1/transactions/contributor/commit-project`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: No
- **Description**: Makes public deposit to work on task

#### 18. SUBMIT_PROJECT
- **Registry Key**: `SUBMIT_PROJECT`
- **Role**: `contributor`
- **Transaction Name**: `submit-project`
- **Component**: N/A (uses commit-project component)
- **Button Text**: "Submit"
- **Title**: "Submit to this Task"
- **Docs Link**: `/docs/protocol/v1/transactions/contributor/submit-project`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: No
- **Description**: Signals to Project Manager that task is ready for review
- **Note**: No dedicated component found, may use COMMIT_PROJECT component

#### 19. ADD_INFO
- **Registry Key**: `ADD_INFO`
- **Role**: `contributor`
- **Transaction Name**: `add-info`
- **Component**: `src/components/cardano/tx/contributor/add-info/AddInfo.tsx`
- **Button Text**: "Update Evidence"
- **Title**: "Update Your Task Evidence"
- **Docs Link**: `/docs/protocol/v1/transactions/contributor/add-info`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: No
- **Description**: Updates public record of task progress

#### 20. ADD_INFO_REVIEW
- **Registry Key**: `ADD_INFO_REVIEW`
- **Role**: `contributor`
- **Transaction Name**: `add-info`
- **Component**: `src/components/cardano/tx/contributor/add-info/AddInfo.tsx`
- **Button Text**: "Submit Evidence for Review"
- **Title**: "Update Your Task Evidence"
- **Docs Link**: `/docs/protocol/v1/transactions/contributor/add-info`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: No
- **Description**: Same as ADD_INFO, different UI context
- **Note**: Uses same transaction name as ADD_INFO

#### 21. GET_REWARDS
- **Registry Key**: `GET_REWARDS`
- **Role**: `contributor`
- **Transaction Name**: `get-rewards`
- **Component**: `src/components/cardano/tx/contributor/get-rewards/GetRewards.tsx`
- **Button Text**: "Claim Rewards"
- **Title**: "Claim Your Task Rewards"
- **Docs Link**: `/docs/protocol/v1/transactions/contributor/get-rewards`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: No
- **Description**: Claims approved task reward and returns deposit

#### 22. UNLOCK_PROJECT
- **Registry Key**: `UNLOCK_PROJECT`
- **Role**: `contributor`
- **Transaction Name**: `unlock-project`
- **Component**: `src/components/cardano/tx/contributor/unlock-project/UnlockProject.tsx`
- **Button Text**: "Abandon Task"
- **Title**: "Unlock This Task for Others"
- **Docs Link**: `/docs/protocol/v1/transactions/contributor/unlock-project`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: No
- **Description**: Removes commitment, returns reward to Treasury

#### 23. ACCEPT_PROJECT
- **Registry Key**: `ACCEPT_PROJECT`
- **Role**: `contributor` (likely should be project-creator)
- **Transaction Name**: `accept-project`
- **Component**: `src/components/cardano/tx/project-creator/accept-project/AcceptProject.tsx`
- **Button Text**: "Accept"
- **Title**: "Accept Task Commitment"
- **Docs Link**: `/docs/protocol/v1/transactions/contributor/accept-project`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: No
- **Description**: Marks task complete, enables contributor to claim reward
- **Note**: Role mismatch - component in project-creator folder

#### 24. REFUSE_PROJECT
- **Registry Key**: `REFUSE_PROJECT`
- **Role**: `contributor` (likely should be project-creator)
- **Transaction Name**: `refuse-project`
- **Component**: `src/components/cardano/tx/project-creator/refuse-project/RefuseProject.tsx`
- **Button Text**: "Refuse"
- **Title**: "Refuse"
- **Docs Link**: `/docs/protocol/v1/transactions/contributor/refuse-project`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: No
- **Description**: Refuses task commitment if evidence doesn't meet criteria
- **Note**: Role mismatch - component in project-creator folder

#### 25. DENY_PROJECT
- **Registry Key**: `DENY_PROJECT`
- **Role**: `contributor` (likely should be project-creator)
- **Transaction Name**: `deny-project`
- **Component**: `src/components/cardano/tx/project-creator/deny-project/DenyProject.tsx`
- **Button Text**: "Deny"
- **Title**: "Deny Task Commitment"
- **Docs Link**: `/docs/protocol/v1/transactions/contributor/deny-project`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: No
- **Description**: Denies commitment if evidence doesn't meet criteria
- **Note**: Role mismatch - component in project-creator folder

---

### Course Creator Transactions

#### 26. MINT_MODULE_TOKENS
- **Registry Key**: `MINT_MODULE_TOKENS`
- **Role**: `course-creator`
- **Transaction Name**: `mint-module-tokens`
- **Component**: `src/components/cardano/tx/course-creator/mint-module-tokens/MintModuleTokens.tsx`
- **Button Text**: "Create New Credential"
- **Title**: "Create New Credential"
- **Docs Link**: `/docs/protocol/v1/transactions/course-creator/mint-module-tokens`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: No
- **Description**: Creates credential opportunity for learners with SLTs

#### 27. ACCEPT_ASSIGNMENT
- **Registry Key**: `ACCEPT_ASSIGNMENT`
- **Role**: `course-creator`
- **Transaction Name**: `accept-assignment`
- **Component**: `src/components/cardano/tx/course-creator/accept-assignment/AcceptAssignment.tsx`
- **Button Text**: "Accept Assignment"
- **Title**: "Accept Assignment"
- **Docs Link**: `/docs/protocol/v1/transactions/course-creator/accept-assignment`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: No
- **Description**: Issues credential to contributor, unlocks opportunities

#### 28. DENY_ASSIGNMENT
- **Registry Key**: `DENY_ASSIGNMENT`
- **Role**: `course-creator`
- **Transaction Name**: `deny-assignment`
- **Component**: `src/components/cardano/tx/course-creator/deny-assignment/DenyAssignment.tsx`
- **Button Text**: "Deny Assignment"
- **Title**: "Deny Assignment"
- **Docs Link**: `/docs/protocol/v1/transactions/course-creator/deny-assignment`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: No
- **Description**: Contributor remains committed, may continue submitting

#### 29. ADD_COURSE_MANAGERS
- **Registry Key**: `ADD_COURSE_MANAGERS`
- **Role**: `course-creator`
- **Transaction Name**: `add-course-managers`
- **Component**: N/A (uses publish tx workflow)
- **Button Text**: "Add Course Managers"
- **Title**: "Add Course Managers"
- **Docs Link**: `/docs/protocol/v1/transactions/course-creator/add-course-managers`
- **Andamio Fee**: Dynamic (10 ADA per manager)
- **Min UTxOs**: PublishTx UTXO
- **Has Admin Wallet**: No
- **Description**: Adds managers to oversee course and student assignments

---

### Project Creator Transactions

#### 30. MINT_TREASURY_TOKEN
- **Registry Key**: `MINT_TREASURY_TOKEN`
- **Role**: `project-creator`
- **Transaction Name**: `mint-treasury-token`
- **Component**: `src/components/cardano/tx/project-creator/mint-treasury-token/MintTreasuryToken.tsx`
- **Button Text**: "Create Treasury"
- **Title**: "Create Your Project Treasury"
- **Docs Link**: `/docs/protocol/v1/transactions/project-creator/mint-treasury-token`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: No
- **Description**: Funds project by locking ADA in Treasury smart contract

#### 31. MANAGE_TREASURY_TOKEN
- **Registry Key**: `MANAGE_TREASURY_TOKEN`
- **Role**: `project-creator`
- **Transaction Name**: `manage-treasury-token`
- **Component**: `src/components/cardano/tx/project-creator/manage-treasury-token/ManageTreasuryToken.tsx`
- **Button Text**: "Update Treasury"
- **Title**: "Update Tasks in Treasury"
- **Docs Link**: `/docs/protocol/v1/transactions/project-creator/manage-treasury-token`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: No
- **Description**: Updates Treasury with task changes, funds new approved tasks

#### 32. TREASURY_ADD_FUNDS
- **Registry Key**: `TREASURY_ADD_FUNDS`
- **Role**: `project-creator`
- **Transaction Name**: `treasury-add-funds`
- **Component**: `src/components/cardano/tx/treasury/add-funds/AddFunds.tsx`
- **Button Text**: "Add Funds"
- **Title**: "Fund Your Treasury"
- **Docs Link**: `/docs/protocol/v1/transactions/treasury/add-funds`
- **Andamio Fee**: undefined
- **Has Admin Wallet**: No
- **Description**: Locks ADA into Treasury for contributor rewards
- **Note**: Also categorized under "treasury" in folder structure

#### 33. ADD_PROJECT_MANAGERS
- **Registry Key**: `ADD_PROJECT_MANAGERS`
- **Role**: `project-creator`
- **Transaction Name**: `add-project-managers`
- **Component**: N/A (uses publish tx workflow)
- **Button Text**: "Add Project Managers"
- **Title**: "Add Project Managers"
- **Docs Link**: `/docs/protocol/v1/transactions/project-creator/add-project-managers`
- **Andamio Fee**: Dynamic (10 ADA per manager)
- **Min UTxOs**: PublishTx UTXO
- **Has Admin Wallet**: No
- **Description**: Adds managers to oversee contributions and treasury

---

## Issues and Notes

### ✅ RESOLVED: File Structure Issues

**All transaction YAML files are now properly organized and accessible via the expected-tx endpoint.**

#### Changes Made:
1. **Moved contributor transactions** from `admin/contributor/` to `contributor/` (6 files):
   - `mint-project-state.yaml`
   - `burn-project-state.yaml`
   - `commit-project.yaml`
   - `add-info.yaml`
   - `get-rewards.yaml`
   - `unlock-project.yaml`

2. **Created missing transaction files** (3 files):
   - `contributor/submit-project.yaml` - Signals task ready for review
   - `course-creator/add-course-managers.yaml` - Adds course managers (10 ADA/manager fee)
   - `project-creator/add-project-managers.yaml` - Adds project managers (10 ADA/manager fee)

### Component-to-Registry Notes

1. **ADD_INFO_REVIEW**: Uses same component and transaction name as ADD_INFO (intentional, different UI context)
2. **Role Classifications**:
   - `ACCEPT_PROJECT`, `REFUSE_PROJECT`, `DENY_PROJECT` - Listed as "contributor" role in registry but correctly belong to "project-creator" based on who performs the action
   - **Recommendation**: Update platform registry to use "project-creator" role for these three transactions

### FromPublishTx Variants
Several admin transactions have "FromPublishTx" component variants:
- `AddCourseCreatorsFromPublishTx.tsx`
- `AddProjectCreatorsFromPublishTx.tsx`
- `InitCourseFromPublishTx.tsx`
- `InitProjectStep1FromPublishTx.tsx`
- `InitProjectStep2FromPublishTx.tsx`

These variants are for admin operations initiated from the publish transaction flow.

---

## Documentation Status

### ✅ All Transaction YAML Files Present (29/29)

**Expected-TX Endpoint**: `/api/expected-tx/[role]/[transaction]?deployment=preprod&version=v1`

All transactions can now be queried via the expected-tx endpoint:

#### General (2/2)
- ✅ `GET /api/expected-tx/general/access-token-mint`
- ✅ `GET /api/expected-tx/general/publish-tx`

#### Admin (7/7)
- ✅ `GET /api/expected-tx/admin/init-course`
- ✅ `GET /api/expected-tx/admin/add-course-creators`
- ✅ `GET /api/expected-tx/admin/remove-course-creators` (registry uses rm-course-creators)
- ✅ `GET /api/expected-tx/admin/init-project-step-1`
- ✅ `GET /api/expected-tx/admin/init-project-step-2`
- ✅ `GET /api/expected-tx/admin/add-project-creators`
- ✅ `GET /api/expected-tx/admin/remove-project-creators` (registry uses rm-project-creators)

#### Student (5/5)
- ✅ `GET /api/expected-tx/student/mint-local-state`
- ✅ `GET /api/expected-tx/student/burn-local-state`
- ✅ `GET /api/expected-tx/student/commit-to-assignment`
- ✅ `GET /api/expected-tx/student/update-assignment`
- ✅ `GET /api/expected-tx/student/leave-assignment`

#### Contributor (11/11)
- ✅ `GET /api/expected-tx/contributor/mint-project-state`
- ✅ `GET /api/expected-tx/contributor/burn-project-state`
- ✅ `GET /api/expected-tx/contributor/commit-project`
- ✅ `GET /api/expected-tx/contributor/submit-project` *(newly created)*
- ✅ `GET /api/expected-tx/contributor/add-info`
- ✅ `GET /api/expected-tx/contributor/get-rewards`
- ✅ `GET /api/expected-tx/contributor/unlock-project`
- ✅ `GET /api/expected-tx/contributor/accept-project` *(uses project-creator YAML)*
- ✅ `GET /api/expected-tx/contributor/refuse-project` *(uses project-creator YAML)*
- ✅ `GET /api/expected-tx/contributor/deny-project` *(uses project-creator YAML)*
- Note: ADD_INFO_REVIEW uses same endpoint as add-info (different UI context only)

#### Course Creator (4/4)
- ✅ `GET /api/expected-tx/course-creator/mint-module-tokens`
- ✅ `GET /api/expected-tx/course-creator/accept-assignment`
- ✅ `GET /api/expected-tx/course-creator/deny-assignment`
- ✅ `GET /api/expected-tx/course-creator/add-course-managers` *(newly created)*

#### Project Creator (5/5)
- ✅ `GET /api/expected-tx/project-creator/mint-treasury-token`
- ✅ `GET /api/expected-tx/project-creator/manage-treasury-token`
- ✅ `GET /api/expected-tx/project-creator/treasury-add-funds`
- ✅ `GET /api/expected-tx/project-creator/accept-project`
- ✅ `GET /api/expected-tx/project-creator/refuse-project`
- ✅ `GET /api/expected-tx/project-creator/deny-project`
- ✅ `GET /api/expected-tx/project-creator/add-project-managers` *(newly created)*

### Next Steps

1. **Update Platform Registry**: Change role from "contributor" to "project-creator" for ACCEPT_PROJECT, REFUSE_PROJECT, and DENY_PROJECT transactions
2. **Verify Deployment Params**: Ensure all policy IDs and addresses are correct in `public/yaml/deployments/preprod-v1/params.yaml` and `mainnet-v1/params.yaml`
3. **Document MDX Pages**: Verify transaction documentation exists at `/docs/protocol/v1/transactions/{role}/{transaction-name}`
4. **Test Endpoints**: Validate all 29 expected-tx endpoints return correct data for both preprod and mainnet deployments

---

## File References

- **Transaction List**: `src/components/cardano/tx/andamio-transaction-list.ts`
- **Cost Registry**: `src/components/cardano/tx/tx-cost-registry.ts`
- **Component Directory**: `src/components/cardano/tx/`
- **Type Definitions**: `src/types/transaction-cost.ts`
