---
name: translate-it-article
description: 专业IT技术文章翻译工具，将英文技术文档、博客文章、学术论文翻译成通俗易懂、引人入胜的简体中文，并保持格式完整保存到本地。
license: MIT
allowed-tools: [WebFetch, Read, Write, mcp__filesystem__write_file, mcp__filesystem__read_file]
---

## 使用方法
当用户需要翻译IT技术文章时，使用以下调用方式：
```
/translate-it-article  [英文文章URL]
或
/translate-it-article  [直接粘贴英文文章内容]
或
/翻译it文章 [英文文章URL]
或
/翻译it文章 [直接粘贴英文文章内容]
或
/translate-it-article [英文文章URL]
或
/translate-it-article [直接粘贴英文文章内容]
```

## 技能调用时机
当用户提出以下需求时，使用此skill：
- "翻译这篇技术文章"
- "把这段英文翻译成中文"
- "翻译一下这个IT文档"
- "帮我翻译技术博客"
- "translate this technical article"
- "help me translate this IT documentation"
- 类似的翻译需求

## 功能说明
输入英文技术文章URL或直接粘贴英文文章内容，系统将自动：
1. **智能翻译** - 保持技术准确性的同时，使用通俗易懂的语言表达
2. **格式保留** - 完整保持原文的Markdown格式、图片、链接等元素
3. **术语规范** - 专业术语使用标准翻译，首次出现时标注英文原文
4. **本地保存** - 自动保存翻译结果为本地Markdown文件

## 翻译原则

### 🎯 目标读者
- 对IT技术感兴趣的普通读者
- 非英语母语的技术从业者
- 需要快速了解国外技术资讯的开发者

### ✨ 翻译风格
- **故事化叙述** - 像讲故事一样解释技术概念，避免枯燥学术风格
- **口语化表达** - 使用自然的中文语序，避免翻译腔
- **逻辑清晰** - 保持原文逻辑链条完整，条理清楚

### 🔍 技术准确性
- **事实一致** - 核心数据、技术原理、逻辑关系必须与原文完全一致
- **术语标准** - 使用行业公认的中文技术术语翻译
  - 首次出现：`人工智能 (Artificial Intelligence)`
  - 后续出现：`AI` 或 `人工智能`
- **代码完整** - 代码块、命令行、API调用保持原样不翻译

### 📝 格式处理
- **标题层级** - 保持H1/H2/H3等标题层级结构
- **强调格式** - 保留粗体、斜体、删除线等强调格式
- **列表结构** - 保持有序列表和无序列表结构
- **链接引用** - 保持超链接和引用链接格式
- **图片说明** - 翻译图片alt文本，保留图片链接

### 🌐 文化适配
- **技术背景** - 对欧美特有的技术背景或文化现象进行适当解释
- **案例说明** - 将不熟悉的外国案例替换为更容易理解的中文对应案例
- **注释规范** - 需要额外解释的内容使用 `**（注释内容）**` 格式

### 📋 处理流程
1. **内容分析** - 识别文章类型（技术博客/学术论文/新闻资讯）
2. **术语提取** - 提取专业术语，建立翻译对照表
3. **结构翻译** - 按段落和标题结构进行翻译
4. **格式检查** - 确保Markdown格式完整无损
5. **质量校对** - 检查技术准确性和表达流畅性
6. **本地保存** - 保存为 `[原文件名]_zh.md`

## 输出格式

### 文件命名
- URL文章：`[网站名称]_[文章标题]_zh.md`
- 直接粘贴：`翻译文章_[日期时间]_zh.md`

### 文件结构
```markdown
# [翻译后的文章标题]

**原文链接**: [原始URL]
**翻译时间**: [翻译日期]
**文章类型**: [技术博客/学术论文/新闻资讯]

---

[翻译后的文章内容，保持完整格式]
```

## 质量保证

### ✅ 准确性检查
- [ ] 技术术语翻译正确
- [ ] 数据和事实与原文一致
- [ ] 逻辑关系保持完整
- [ ] 代码和命令未错误翻译

### ✅ 可读性检查
- [ ] 中文表达自然流畅
- [ ] 长句已适当拆分
- [ ] 段落结构清晰
- [ ] 无明显翻译腔

### ✅ 格式检查
- [ ] Markdown格式完整
- [ ] 图片链接正常
- [ ] 代码块格式正确
- [ ] 列表和标题层级正确

## 示例对比

### 原文
```
## Machine Learning in Production

Deploying ML models at scale requires careful consideration of latency, throughput, and monitoring.
```

### 翻译后
```
## 生产环境中的机器学习应用

大规模部署机器学习模型时，需要仔细考虑延迟、吞吐量和监控等关键因素。
```

---

*💡 提示：此技能专注于技术文章的高质量翻译，确保技术准确性的同时提升中文读者的阅读体验。*

## 🌐 Multi-language Support
This skill supports both Chinese and English commands:
- Chinese: `/翻译it文章`
- English: `/translate-it-article`  
- Original: `/it-translate`