---
name: trend-analysis
description: Frameworks for identifying, evaluating, and acting on trends. Use when researching trends, generating trend-based content ideas, or timing content publication.
---

# Trend Analysis Skill

Frameworks and techniques for identifying emerging trends and turning them into content opportunities.

## The Trend Lifecycle

```
          Discovery → Growth → Peak → Decline → Maturity
              ↑          ↑       ↑       ↑          ↑
            Early    Rising   Hot   Saturated  Evergreen
           Adopters  Stars   Topic   Takes     Reference
```

### Phase Characteristics

| Phase | Discussion | Competition | Opportunity |
|-------|------------|-------------|-------------|
| Discovery | Niche communities | Very low | Define the conversation |
| Growth | Expanding rapidly | Low-Medium | Build authority |
| Peak | Maximum volume | High | Need unique angle |
| Decline | Moving on | Decreasing | Contrarian takes |
| Maturity | Established | Low (new entrants) | Best practices |

## Trend Identification Signals

### Early Stage Signals (High Value)
- Questions appearing in niche forums
- "What is X?" search patterns rising
- Early adopter communities buzzing
- First mainstream article appears
- Investors starting to mention

### Growth Stage Signals
- Multiple articles/podcasts covering
- Debates about approach/implementation
- "How to X" content proliferating
- Job postings mentioning topic
- Conference sessions being added

### Peak Stage Signals
- Everyone has an opinion
- Backlash articles appearing
- "Is X overhyped?" pieces
- Mainstream media coverage
- Parody/meme content

### Decline Signals
- "X is dead" articles
- Conversation shifts to "what's next"
- New topic replacing it
- Only laggards still discovering
- Best practices established

## Trend Evaluation Framework

### TEMPO Analysis

**T - Timing**
- Where in the lifecycle?
- How long until peak?
- When is the optimal moment to publish?

**E - Evidence**
- What data supports this trend?
- How strong are the signals?
- Are sources credible?

**M - Momentum**
- Is discussion accelerating?
- What's the velocity of new content?
- Are influencers engaging?

**P - Positioning**
- How does user's expertise align?
- What unique angle is available?
- Can they add genuine value?

**O - Opportunity**
- What content formats fit?
- What's the competition like?
- What's the upside?

### Scoring Matrix

| Factor | Weight | Score (1-5) | Weighted |
|--------|--------|-------------|----------|
| Timing | 25% | | |
| Evidence | 20% | | |
| Momentum | 20% | | |
| Positioning | 20% | | |
| Opportunity | 15% | | |
| **Total** | **100%** | | |

**Interpretation:**
- 4.0+ : Excellent opportunity, act now
- 3.0-4.0 : Good opportunity, plan content
- 2.0-3.0 : Monitor, may improve
- <2.0 : Pass or wait

## Content Timing Strategy

### Optimal Timing by Content Type

| Content Type | Best Phase | Why |
|--------------|------------|-----|
| Explainer/101 | Early Growth | Be the reference |
| Opinion/Take | Growth to Peak | Join the conversation |
| Deep Analysis | Peak | Differentiate from hot takes |
| Contrarian | Late Peak | Stand out from consensus |
| Best Practices | Decline/Maturity | Provide closure |
| Retrospective | Maturity | Historical perspective |

### Timing Considerations

- **Speed vs. Quality**: Early phases favor speed; peak favors quality
- **Expertise Match**: Only go early if you genuinely know the topic
- **Audience Readiness**: Are your followers aware of this trend?
- **Platform Fit**: LinkedIn may lag Twitter by days/weeks

## Research Techniques

### Search Pattern Variations

```
[topic] + trends
[topic] + what's changing
[topic] + controversy
[topic] + vs [alternative]
[topic] + dead
[topic] + future
[topic] + predictions 2026
[topic] + hot take
why [topic] matters
[topic] + problem
[topic] + mistake
```

### Source Prioritization

1. **Leading Indicators**
   - Hacker News discussions
   - Substack newsletters
   - Early-adopter Twitter/X
   - Reddit niche communities

2. **Confirming Indicators**
   - Industry publications
   - Tech news sites
   - Mainstream business press
   - Conference agendas

3. **Lagging Indicators**
   - General news coverage
   - LinkedIn trending
   - "What is X" articles
   - Corporate announcements

## Trend-to-Content Mapping

### From Trend to Article Angle

**Trend**: AI code assistants changing developer workflows

**Possible Angles**:
1. "The hidden cost of AI-assisted coding" (contrarian)
2. "How I use [tool] without losing my skills" (personal/practical)
3. "5 tasks where AI assistants fail completely" (specific/surprising)
4. "The junior developer's guide to AI coding tools" (audience-specific)
5. "AI coding tools: 3 months later" (retrospective)

### Angle Selection Criteria

- **Uniqueness**: Am I saying something new?
- **Evidence**: Can I back this up?
- **Voice Match**: Is this how I naturally think?
- **Audience Value**: Does my audience need this?
- **Timeliness**: Why now specifically?

## Memory Integration for Trends

### What to Store

**Store in semantic memory:**
- Trend name and current phase
- Key sources/evidence
- Optimal content angles
- Timing recommendations

**Example:**
```
Category: ["trends", "developer-tools"]
Content: "AI code assistant trend in growth phase (Jan 2026).
Evidence: HN discussions up 300% QoQ, GitHub Copilot surpassed
1M users. Best angles: productivity claims (contrarian),
skill development concerns, workflow integration tips.
Optimal timing: next 4-6 weeks before peak saturation."
```

### What to Query

Before trend research:
- Past trends in this space
- User's expertise areas
- Previous content on related topics

## Common Trend Research Mistakes

1. **Confirmation Bias** - Only looking for trends you want to find
2. **Echo Chamber** - Relying on single source/community
3. **Recency Bias** - Assuming new = trending
4. **Trend Conflation** - Combining separate trends into one
5. **Peak Blindness** - Missing that peak has passed
6. **Evergreen Confusion** - Calling persistent topics "trends"

## Trend Report Template

```markdown
# Trend Report: [Industry/Topic]
Generated: [Date]
Research Depth: [Quick/Standard/Deep]

## Executive Summary
[2-3 sentence overview of findings]

## Top Trends

### 1. [Trend Name]
- **Phase**: Discovery/Growth/Peak/Decline
- **TEMPO Score**: X.X/5.0
- **Evidence**: [Brief summary with sources]
- **Your Angle**: [Recommended approach]
- **Timing**: [When to act]
- **Content Recommendation**: [Specific suggestion]

### 2. [Trend Name]
[Same structure]

## Quick Opportunities
[Bullet list of immediate actions]

## Watch List
[Emerging topics to monitor]

## Not Worth Pursuing
[Trends that don't fit or are saturated]
```
