# ElevenLabs Eleven v3 Audio Tags Reference

This document provides the audio tags library for use with ElevenLabs eleven_v3 model, optimized for **sultry authority**, **dark seduction**, **ominous control**, and **mischievous menace**.

## Tag Placement Rules

1. Place tags **immediately before** the phrase to be affected
2. Re-tag when changing moods to prevent "bleed"
3. Use **1-3 tags per beat** maximum—over-tagging causes instability
4. Stack tags for complex emotional delivery: `[Close to mic][Sultry][Strict]`

---

## Texture Tags (Crucial for Sultry Vibe)

These create the "Cate Blanchett standing right behind your chair" effect.

| Tag | Effect |
|-----|--------|
| `[Close to mic]` | **Most important.** Adds "Proximity Effect" (more bass, more intimate) |
| `[Whispers]` / `[Whispering]` | Drops volume but keeps intensity |
| `[Breathy]` | Adds air to voice; less robotic, more human/tired/sultry |
| `[Vocal fry]` | That "creaky" low-end sound in relaxed, deep voices |
| `[Husky]` | Deep and slightly raspy |
| `[Low pitch]` | Forces voice into lower register |
| `[Gravelly]` | Adds texture and darkness |
| `[Low and slow]` | Deliberate, measured delivery |

---

## Emotional/Delivery Tags

### Authority & Control
| Tag | Effect |
|-----|--------|
| `[Commanding]` | Adds weight and authority without shouting |
| `[Strict]` | Removes warmth, becomes very direct |
| `[Serious]` | Grave, solemn tone |
| `[Authoritative]` | Strong, confident delivery |
| `[Firm]` | Solid, unyielding |

### Seduction & Intimacy
| Tag | Effect |
|-----|--------|
| `[Sultry]` | Slows pace, drops pitch, adds seduction |
| `[Intimate]` | Softens tone, like sharing a secret |
| `[Inviting]` | Welcoming, seductive draw |
| `[Warmly]` | Adds a smile to the voice |
| `[Purring tone]` | Low, rumbling vocal fry—risky but powerful |
| `[Breathless]` | Flustered energy without being overt |

### Dark & Menacing
| Tag | Effect |
|-----|--------|
| `[Icy]` | Cold, detached |
| `[Dead calm]` | Emotionless stillness |
| `[Threatening politely]` | Courteous danger |
| `[Controlled rage]` | Restrained anger |
| `[Sinister calm]` | Threatening restraint |
| `[Ominous restraint]` | Polite... terrifying |
| `[Predatory calm]` | Hunter's stillness |
| `[Soft threat]` | Gentle menace |

### Playful & Mischievous
| Tag | Effect |
|-----|--------|
| `[Mischievously]` | Dark playfulness with edge |
| `[Playful]` | Light, teasing energy |
| `[Sarcastic]` | Dry, ironic tone |
| `[Dangerously playful]` | Risky flirtation |
| `[Teasing threat]` | Playful menace |
| `[Switch to menace]` | Mood shift cue from playful to dark |
| `[Cold amusement]` | Detached humor |

### Emotional States
| Tag | Effect |
|-----|--------|
| `[Curious]` | Questioning, interested |
| `[Excited]` | High energy, enthusiastic |
| `[Smoldering]` | Burning intensity |
| `[Heated]` | Passionate, intense |
| `[Slow burn]` | Building anger |
| `[Fed up]` | Exasperated frustration |
| `[Regal]` | Royal bearing |
| `[Condescending]` | Superior tone |

---

## Non-Verbal Sounds (Verified)

### Breath & Release
| Tag | Effect |
|-----|--------|
| `[Sighs]` | Exhale with emotion |
| `[Exhales]` / `[Audible exhale]` | Controlled breath out |
| `[Inhales sharply]` / `[Sharp intake of breath]` | Good before strict commands |
| `[Deep breath sound]` | Full inhalation |

### Laughter & Amusement
| Tag | Effect |
|-----|--------|
| `[Laughs]` | Standard laugh |
| `[Soft laugh]` / `[Laughs softly]` | Subtle, knowing laugh |
| `[Chuckles]` | Brief, soft laugh |
| `[Giggles]` | Light, playful |
| `[Slight chuckle]` | Dark, amused |

### Physical
| Tag | Effect |
|-----|--------|
| `[Gasp]` | Sharp intake of breath |
| `[Swallows]` | Nervous swallow |
| `[Clears throat]` | Getting attention |
| `[Humming softly]` / `[Mmm]` | Great for seductive openings |

### Pacing
| Tag | Effect |
|-----|--------|
| `[Pause]` | Creates tension, builds anticipation |
| `[Long pause]` | Extended silence |
| `[Slow pacing]` | Deliberate, hypnotic |
| `[Fast]` | Hurried, urgent |

---

## Sound Effect Tags (Experimental)

| Tag | Effect |
|-----|--------|
| `[Sound of a lighter flicking]` | Ambient detail (Ocean's vibe) |
| `[Sound of inhaling]` | Deep breath before command |
| `[Finger snap]` | Attention-getting |

**Note:** v3 CAN do these but they're hit-or-miss. Test and keep what works.

---

## Accent Tags

### Template
```
[strong X accent]  - Heavy accent emphasis
[X accent]         - Natural accent application
```

### Verified Accents
`[French accent]`, `[British accent]`, `[American accent]`, `[Southern US accent]`, `[Australian accent]`, `[Irish accent]`

---

## Punctuation as Performance Control

| Punctuation | Effect |
|-------------|--------|
| `...` (ellipses) | Creates pause, builds tension, adds weight |
| `.` (periods) | Full stop, drops pitch, creates authority |
| `—` (em dash) | Abrupt pause, interruption feel |
| `CAPITALS` | Strong emphasis, louder delivery |
| `?` | Rising intonation |
| `!` | Energy boost (use sparingly) |

### The "..." Start Trick
Always add `...` at the start:
```
... Stop. Take your hands off the keyboard.
```
This forces a breath before speaking—prevents first-syllable cutoff and adds anticipation.

---

## Tag Combinations for Shadow Dial Moods

### Quiet Menace + Slow Seduction (Liza Bonnet)
```
[Close to mic][Whispers][Soft threat]
[Sultry][Low and slow][Intimate]
[Sinister calm][Sighs][Low pitch]
```

### Cold Fury + Clinical Dominance (Charlise Therin)
```
[Strict][Dead calm][Icy]
[Controlled rage][Threatening politely]
[Serious][Sharp intake of breath][Low]
```

### Smoky Seduction → Mischievous Cruelty (Flo Po Lisa Bo)
```
[Sultry][Breathy][Mischievously]
[Dangerously playful][Switch to menace]
[Noir][Whispers][Low pitch]
```

### Dark Seduction + Quiet Anger (Halle Berry)
```
[Sultry][Predatory calm][Close to mic]
[Soft dominance][Sighs][Intimate]
[Serious][Low pitch][Exhales]
```

### Ominous Control + Measured Cruelty (Cate Blanchett)
```
[Regal][Ominous restraint][Serious]
[Condescending][Cold amusement][Whispers]
[Strict][Slow pacing][Dead calm]
```

---

## The 6 Beat Block Recipes

### 1. Ominous Calm
```
[Serious] + [Whispers] + [Exhales]
```

### 2. Seductive Control
```
[Sultry] + [Close to mic] + [Pause]
```

### 3. Angry Restrained
```
[Strict] + [Sharp intake of breath] + [Low]
```

### 4. Furious
```
[Shouting] + [Fast]
```

### 5. Mischief → Menace
```
[Mischievously] → [Switch to menace] → [Whispers]
```

### 6. Predatory Sarcasm
```
[Sarcastic] + [Laughs softly] + [Commanding]
```

---

## Stability Settings Impact

| Stability Setting | Tag Behavior |
|-------------------|--------------|
| **Creative** (0.2-0.35) | Most responsive to tags, maximum expressiveness, may hallucinate |
| **Natural/Balanced** (0.4-0.5) | Good seduction + consistency |
| **Robust** (0.6+) | Less responsive, more predictable |

**For sultry content:** Use **Stability: 35-40%** for maximum tag responsiveness.

---

## Verified vs Experimental Tags

### Verified (Confirmed Working)
`[whispers]`, `[sighs]`, `[laughs]`, `[curious]`, `[sarcastic]`, `[serious]`, `[excited]`, `[mischievously]`, `[gasp]`, `[clears throat]`, `[exhales]`, `[shouting]`

### Experimental (Test & Keep What Works)
`[sultry]`, `[husky]`, `[purring tone]`, `[close to mic]`, `[breathy]`, `[icy]`, `[dead calm]`, `[threatening politely]`, `[sinister calm]`, `[predatory calm]`, `[switch to menace]`, `[dangerously playful]`

**Why experimental is reasonable:** v3 tags behave like bracketed direction cues. Official examples include open templates like `[strong X accent]`, implying descriptive bracket phrases can work.
