# Voice Profiles and Direction Sheets

This document contains voice-specific direction sheets for the available ElevenLabs voices optimized for eleven_v3. Each voice has a **baseline** (everyday posture) and a **shadow dial** (how it shifts darker—seductive, angry, ominous, mischievous—without becoming cartoon villain).

## Quick Reference

| Voice ID | Name | Shadow Dial | Mood Cue |
|----------|------|-------------|----------|
| DpalF6dOkkUMR5KCm1VO | Liza Bonnet | **Quiet menace + slow seduction** | *"Dark, ominous, seductive… like a candle-lit threat in a silk glove."* |
| I7JbV36JNTnseIKpKfyG | Charlise Therin | **Cold fury + clinical dominance** | *"Seductive, angry, ominous… calm enough to ruin your week with one sentence."* |
| IdJsjryoO3nXmloCgz91 | Flo Po Lisa Bo | **Smoky seduction → mischievous cruelty** | *"Sensual, mischievous, furious… like a grin you regret under neon lights."* |
| pS1ke04nBbxBAxDH54ff | Alisia Keies | **Smoldering intensity + righteous anger** | *"Sexy, angry, seductive… like gospel fire aimed at your excuses."* |
| sV3kw03Gi4K7OMIOY9OF | Penelopi Crus | **Seductive mischief → sharp anger** | *"Sensual, mischievous, ominous… like a kiss that bites."* |
| ynfbLKug5DffI0hg9fxT | Halle Berry | **Dark seduction + quiet anger** | *"Dark, sexy, angry… like velvet with claws."* |
| zZ7KtV7SXU6rz5wRS4y3 | Cate Blanchett | **Ominous control + measured cruelty** | *"Ominous, seductive, furious… like royalty deciding you're done."* |

---

## Detailed Voice Direction Sheets

### Liza Bonnet - AI
**Voice ID:** `DpalF6dOkkUMR5KCm1VO`

| Aspect | Direction |
|--------|-----------|
| **Baseline** | Velvet-calm, low-key magnetic, "cool without trying" |
| **Shadow Dial** | **Quiet menace + slow seduction** (soft voice, sharp intent) |
| **Sonic Targets** | Slow pace, lower pitch, longer vowels, controlled breath, minimal bounce |
| **Mood Cue** | *"Hmm-mm-hmm-mhm… dark, ominous, seductive… like a candle-lit threat in a silk glove."* |

**Go-To Tag Recipe:**
- **Verified:** `[whispers]`, `[sighs]`, `[curious]`, `[sarcastic]`, `[serious]`
- **Custom (test):** `[low and slow]`, `[intimate]`, `[sinister calm]`, `[soft threat]`

**Example - The Seductive Interruption:**
```
[Close to mic][Sultry, slightly breathy] ... You've been quiet for too long.
[Warmly] I missed you. Come away from the glare of the monitor.
[Soft laugh] Go get some water... and breathe.
```

---

### Charlise Therin - AI
**Voice ID:** `I7JbV36JNTnseIKpKfyG`

| Aspect | Direction |
|--------|-----------|
| **Baseline** | Ice-calm authority, "executive predator" |
| **Shadow Dial** | **Cold fury + clinical dominance** (no yelling; the blade stays polished) |
| **Sonic Targets** | Faster clarity, crisp consonants, minimal breathiness, hard stops |
| **Mood Cue** | *"Hmm-mm-hmm-mhm… seductive, angry, ominous… calm enough to ruin your week with one sentence."* |

**Go-To Tag Recipe:**
- **Verified:** `[serious]`, `[robotically]` (for "cold"), `[sarcastic]`, `[shouting]` (rare)
- **Custom (test):** `[dead calm]`, `[threatening politely]`, `[controlled rage]`, `[icy]`

**Example - The Discipline:**
```
[Deep, strict] ... Break time is over. [Sound of a deep inhale]
I want to see that discipline again. Sit down.
[Commanding] Lock the door. Block the world out.
[Icy] It's just you and me now.
```

---

### Flo Po Lisa Bo Cut
**Voice ID:** `IdJsjryoO3nXmloCgz91`

| Aspect | Direction |
|--------|-----------|
| **Baseline** | Husky + grounded, "modern noir narrator" |
| **Shadow Dial** | **Smoky seduction → mischievous cruelty** (playful… then the temperature drops) |
| **Sonic Targets** | Mid-low pitch, slight rasp texture, variable pace (slow tease → quick snap) |
| **Mood Cue** | *"Hmm-mm-hmm-mhm… sensual, mischievous, furious… like a grin you regret under neon lights."* |

**Go-To Tag Recipe:**
- **Verified:** `[mischievously]`, `[giggles]`, `[sarcastic]`, `[whispers]`
- **Custom (test):** `[noir]`, `[dangerously playful]`, `[tempting]`, `[switch to menace]`

**Example - The Sweat:**
```
[Sultry, amused] ... My, oh my. You are intense when you work.
[Breathless] It's getting a little hot in here, don't you think?
Cool off for five minutes. [Playful] Before you burn the place down.
```

---

### Alisia Keies - AI
**Voice ID:** `pS1ke04nBbxBAxDH54ff`

| Aspect | Direction |
|--------|-----------|
| **Baseline** | Warm power, "soulful composure" |
| **Shadow Dial** | **Smoldering intensity + righteous anger** (human heat, not robotic cold) |
| **Sonic Targets** | Round vowels, smooth legato phrasing, controlled volume swell, "stage presence" |
| **Mood Cue** | *"Hmm-mm-hmm-mhm… sexy, angry, seductive… like gospel fire aimed at your excuses."* |

**Go-To Tag Recipe:**
- **Verified:** `[excited]` (for intensity), `[serious]`, `[trembling]` (when emotional), `[sighs]`
- **Custom (test):** `[smoldering]`, `[heated]`, `[slow burn]`, `[fed up]`

**Example - The Good Boy/Partner:**
```
[Warm, purring tone] ... Mmm. You've been very, very good for the last twenty-five minutes.
[Pause] And good work deserves a reward. Go take a break.
[Intimate] If you disobey, I'll be very disappointed.
```

---

### Penelopi Crus - AI
**Voice ID:** `sV3kw03Gi4K7OMIOY9OF`

| Aspect | Direction |
|--------|-----------|
| **Baseline** | Flirty precision, "danger in lace" |
| **Shadow Dial** | **Seductive mischief → sharp anger** (light touch, lethal edge) |
| **Sonic Targets** | Slightly quicker rhythm, playful melodic rise, then clipped endings when "furious" |
| **Mood Cue** | *"Hmm-mm-hmm-mhm… sensual, mischievous, ominous… like a kiss that bites."* |

**Go-To Tag Recipe:**
- **Verified:** `[mischievously]`, `[sarcastic]`, `[curious]`, `[whispers]`, `[shouting]` (rare)
- **Custom (test):** `[dangerously charming]`, `[teasing threat]`, `[sweet then vicious]`

**Example - Round Two:**
```
[Playful, low pitch] ... Ready for round two? [Pause] I've got the timer set.
I want twenty-five minutes of hard, uninterrupted...
[Pause, smiling] ...focus. Show me what you can do.
```

---

### Halle Berry - AI
**Voice ID:** `ynfbLKug5DffI0hg9fxT`

| Aspect | Direction |
|--------|-----------|
| **Baseline** | Smooth confidence, "cool sensual lead" |
| **Shadow Dial** | **Dark seduction + quiet anger** (purr → steel) |
| **Sonic Targets** | Breath-control, intimate proximity feel, low-mid pitch, reduced brightness |
| **Mood Cue** | *"Hmm-mm-hmm-mhm… dark, sexy, angry… like velvet with claws."* |

**Go-To Tag Recipe:**
- **Verified:** `[whispers]`, `[sighs]`, `[serious]`, `[sarcastic]`, `[laughs]`
- **Custom (test):** `[sultry]`, `[predatory calm]`, `[soft dominance]`

**Example - The Voyeur:**
```
[Quiet, observant] ... I like watching you focus. The way you lock in...
[Sighs] ...it's distracting. But the timer is up.
[Commanding] Stand up. Walk away. Leave me wanting more.
```

---

### Cate Blanchett - AI
**Voice ID:** `zZ7KtV7SXU6rz5wRS4y3`

| Aspect | Direction |
|--------|-----------|
| **Baseline** | Aristocratic precision, "elegant command" |
| **Shadow Dial** | **Ominous control + measured cruelty** (polite… terrifying) |
| **Sonic Targets** | Crisp diction, slow authoritative cadence, minimal breath, clean pauses |
| **Mood Cue** | *"Hmm-mm-hmm-mhm… ominous, seductive, furious… like royalty deciding you're done."* |

**Go-To Tag Recipe:**
- **Verified:** `[serious]`, `[sarcastic]`, `[robotically]` (for "chilled"), `[whispers]`
- **Custom (test):** `[regal]`, `[condescending]`, `[ominous restraint]`, `[cold amusement]`

**Example - The Getaway (Ocean's 12 Vibe):**
```
[Low, gravelly] ... Alright. We got the goods. [Sound of a lighter flicking or exhale]
The job is done for now. We need to lay low for fifteen.
[Sultry, confident] Disappear, darling. Go find some trouble offline.
```

---

## The 6 Reusable Beat Blocks

Create repeatable tones for consistent behavioral conditioning:

### 1. Ominous Calm
*For: Mid-work check-ins, gentle warnings*
```
[Serious] + [Whispers] + [Exhales]
```
> `[Serious][Whispers]` ... The clock is watching. `[Exhales]` Stay with me.

### 2. Seductive Control
*For: Work → Break transitions*
```
[Sultry] + [Close to mic] + [Pause]
```
> `[Sultry][Close to mic]` ... I've been waiting for you. `[Pause]` Come away from the screen.

### 3. Angry Restrained
*For: Hard stops, boundary enforcement*
```
[Strict] + [Sharp intake of breath] + [Low]
```
> `[Strict]` ... Pause. `[Sharp intake of breath]` Do not type another word.

### 4. Furious
*For: Emergency pattern interrupts*
```
[Shouting] + [Fast] (use sparingly)
```
> `[Shouting]` STOP! `[Fast]` Step away from the desk. Now.

### 5. Mischief → Menace
*For: Playful challenges that get serious*
```
[Mischievously] → [Switch to menace] → [Whispers]
```
> `[Mischievously]` Oh, you want to keep going? `[Switch to menace]` I don't think so. `[Whispers]` Walk away.

### 6. Predatory Sarcasm
*For: Dark humor, ironic commands*
```
[Sarcastic] + [Laughs softly] + [Commanding]
```
> `[Sarcastic]` How's that hyperfocus treating you? `[Laughs softly]` Time's up. `[Commanding]` Move.

---

## Voice Rotation Strategy

To prevent "immune" effect (tuning out repeated sounds), use each voice **3 times before switching**:

**Session Rotation Pattern:**
```
Liza Bonnet x3 → Charlise Therin x3 → (repeat)
```

**Contrast Pairs:**
- **Warm vs Cold:** Liza Bonnet ↔ Charlise Therin
- **Noir vs Playful:** Flo Po Lisa Bo ↔ Penelopi Crus
- **Soulful vs Regal:** Alisia Keies ↔ Cate Blanchett

**By Mood:**
| Mood Needed | Primary Voice | Backup Voice |
|-------------|---------------|--------------|
| Seductive control | Liza Bonnet | Halle Berry |
| Cold authority | Charlise Therin | Cate Blanchett |
| Mischievous play | Flo Po Lisa Bo | Penelopi Crus |
| Smoldering intensity | Alisia Keies | Halle Berry |
| Ominous menace | Cate Blanchett | Charlise Therin |
