---
name: tumblbug-launch-strategist
description: Plan and execute Tumblbug crowdfunding campaigns for indie games. Designs reward tiers, 90-day marketing plans, community building strategies, and crisis response protocols based on successful Korean indie game campaigns (Skul 72M KRW, Sannabi 143M KRW). Use when planning crowdfunding campaigns, designing reward structures, or preparing Tumblbug project pages for game launches.
---

# Tumblbug Launch Strategist

Plan successful Tumblbug crowdfunding campaigns for indie games based on proven Korean success cases.

## Purpose

This skill provides crowdfunding strategies for:
- Tumblbug project page design
- Reward tier structure optimization
- 90-day pre-launch marketing plan
- Community building (Discord, social media)
- Crisis management (slow funding, negative feedback)

## When to Use This Skill

Use this skill when:
- Planning Tumblbug crowdfunding campaign for games
- Designing reward tiers and pricing
- Creating pre-launch marketing strategy
- Building beta tester community
- Responding to funding challenges

## Success Case Analysis

### Skul (2021): 72M KRW

**Key Success Factors**:
- 70-80% game completion before funding
- Demo version provided (transparency)
- Clear development timeline
- Active community engagement
- Streamer marketing (YouTube/Twitch)

**Funding Pattern**:
- Day 1: 30% of total
- Week 1: 60% of total
- Final week: Remaining 40%

### Sannabi (2024): 143M KRW

**Key Success Factors**:
- Existing IP (game already successful on Steam)
- Premium goods strategy (70% chose high-tier rewards)
- Average pledge: 97,800 KRW (vs 15,000 KRW for new games)
- Community demand (proven fanbase)

**Lesson**: IP matters enormously (10× multiplier)

### Typical New Game: 3-8M KRW

**Realistic Targets** for first-time developers:
- Goal: 10-20M KRW (conservative)
- Expected: 15-30M KRW if executed well
- Outlier: 50M+ KRW (requires viral moment)

## Reward Tier Design

### Optimal Structure (5 tiers)

| Tier | Price | Content | Margin | Expected Sales |
|------|-------|---------|--------|----------------|
| **Early Bird** | 8,000 KRW | Game access (20% discount) | 100% | 100 (sell out) |
| **Standard** | 10,000 KRW | Game access | 100% | 500 |
| **Premium** | 15,000 KRW | Game + artbook + OST | 95% | 300 |
| **Supporter** | 18,000 KRW | Premium + credit name | 95% | 80 |
| **Collector** | 30,000 KRW | All + dev commentary | 90% | 20 |

**Revenue Calculation**:
```
100 × 8,000 = 800,000
500 × 10,000 = 5,000,000
300 × 15,000 = 4,500,000
80 × 18,000 = 1,440,000
20 × 30,000 = 600,000

Total: 12,340,000 KRW (1,000 backers)
Platform fee (8%): -987,200
Net: 11,352,800 KRW
```

**Avg pledge**: 12,340 KRW (healthy for digital game)

### Reward Design Principles

✅ **Do**:
- Offer digital-only rewards (no shipping costs)
- Include "supporter" tier (pay more to support)
- Limit early bird (creates urgency)
- Make Standard tier attractive (most sales)

❌ **Don't**:
- Promise physical goods (shipping nightmare)
- Make tiers confusing (too many options)
- Undervalue base tier (devalues game)
- Over-promise (delay/cancellation risk)

## 90-Day Marketing Plan

### Phase 1: Pre-Campaign (D-90 to D-30)

**Goal**: Build 300-person community

```
Week -12 to -8: Foundation
- [ ] Create Discord server (channels: announcements, feedback, general)
- [ ] Open social media (Instagram, Twitter, TikTok)
- [ ] Post dev logs (2-3× per week)
- [ ] Recruit beta testers (50 people)
- Target: 100 Discord members

Week -7 to -4: Content Creation
- [ ] Record gameplay video (30-60 sec teaser)
- [ ] Create hero image (1920×1080)
- [ ] Write project description (2,000 words)
- [ ] Design reward tiers
- [ ] Prepare FAQ (10+ questions)
- Target: 200 Discord members

Week -3 to -1: Teaser Campaign
- [ ] Release teaser video (TikTok, YouTube)
- [ ] Influencer outreach (3-5 game streamers)
- [ ] "Coming soon" on Tumblbug
- [ ] Email list signup (embedded in demo)
- Target: 300 Discord members, 500 email signups
```

### Phase 2: Campaign Launch (D-Day to D+30)

**Day 1 (Critical)**:

```
Timeline:
00:00 - Campaign goes live (midnight for early birds)
06:00 - Team social media blast (all channels)
09:00 - Influencer wave 1 (YouTube streamers)
12:00 - Discord live Q&A (dev team)
18:00 - Influencer wave 2 (post-work audience)
21:00 - Day 1 progress update ("4 hours, 5M raised!")
23:59 - Day 1 wrap-up (thank backers, set Week 1 goal)

Target: 30-40% of goal (6-8M KRW for 20M goal)
```

**Week 1**:
- Daily updates (progress, dev logs, backer thanks)
- Engage all comments within 2 hours
- Influencer wave 3-5 (extend reach)
- Target: 50% of goal (10M KRW)

**Week 2-3**:
- 2-3 updates per week
- Community events (fan art contest, Q&A sessions)
- Press releases to gaming media
- Target: 80% of goal (16M KRW)

**Week 4**:
- Daily countdown ("7 days left!", "3 days left!")
- Final push marketing
- Unlock stretch goals if exceeded 100%
- Target: 100%+ of goal (20M+ KRW)

### Phase 3: Post-Campaign (D+30 onwards)

**Week 1-2 after close**:
- Thank you video (dev team)
- Backer survey (feature preferences)
- Development timeline update

**Week 3-12 (Development)**:
- Weekly dev log (Friday)
- Monthly newsletter (email)
- Backer-exclusive beta access

## Community Building

### Discord Server Structure

```
📢 Announcements (read-only)
   - Campaign updates
   - Dev milestones

💬 General Chat
   - Backer discussion
   - Questions

🎮 Beta Testing
   - Test feedback
   - Bug reports

🎨 Fan Creations
   - Fan art, theories
   - Community engagement

❓ FAQ
   - Pinned answers
```

**Management**: Respond within 24 hours, pin important Q&A

### Social Media Strategy

| Platform | Content Type | Frequency | Target Metric |
|----------|--------------|-----------|---------------|
| **TikTok** | 15-sec gameplay clips | 3-5×/week | 1,000 followers |
| **Instagram** | Screenshots, character art | 3×/week | 500 followers |
| **Twitter/X** | Dev updates, GIFs | Daily | 300 followers |
| **YouTube** | Dev vlogs, trailers | 1×/week | 200 subscribers |

**Content Calendar** in `references/social-media-calendar.md`.

## Crisis Response Protocols

### Scenario 1: Slow Funding (<30% by Week 1)

**Response**:
```
Immediate (24 hours):
- [ ] Analyze traffic sources (where are backers from?)
- [ ] Additional early bird release (50 slots)
- [ ] Flash sale (10% extra discount for 48 hours)
- [ ] Influencer emergency outreach (pay if needed)

Week 2:
- [ ] Adjust goal (if too ambitious)
- [ ] Revise rewards (make Standard more attractive)
- [ ] Major promotional push (paid ads)
```

### Scenario 2: Negative Feedback

**Response Template**:
```
"[Backer name]님, 소중한 의견 감사합니다!

[지적하신 문제]에 대해 [구체적 대응 방안]을 진행하고 있습니다.

[개선 전후 비교 이미지/영상]

앞으로도 피드백 부탁드립니다!"
```

**Key Principles**:
- Respond within 24 hours
- Never defensive
- Show concrete action (not just words)
- Update progress publicly

### Scenario 3: Development Delay

**Response**:
```
Transparency (immediate announcement):
- Explain delay reason honestly
- Provide new timeline
- Offer compensation (extra DLC, beta access)
- Allow refunds (no questions asked)

Rebuild Trust:
- Weekly dev logs (prove work continues)
- Backer-exclusive content
- Prioritize quality over speed
```

## Tumblbug Project Page Template

**Structure** (see `references/project-page-template.md` for full version):

1. **Hero Section** (first impression)
   - Hero image (1920×1080, dramatic scene)
   - 30-60 sec video (hook + gameplay + CTA)
   - One-sentence pitch

2. **Story Section** (emotional connection)
   - "Who was killed? Why should you care?"
   - Victim backstory (humanize)
   - Stakes (what happens if truth hidden?)

3. **Features Section** (value proposition)
   - AI NPC dialogue
   - 3-act structure
   - 5 endings
   - Mobile optimized

4. **Demo Section** (trust building)
   - Playable web demo link
   - Gameplay video (3 min)
   - Screenshot gallery (10 images)

5. **Team Section** (credibility)
   - Developer bio
   - Previous work
   - Development progress (70%+ recommended)

6. **Timeline Section** (transparency)
   - Funding period
   - Development phases
   - Expected delivery date
   - Risk mitigation

7. **FAQ Section** (objection handling)
   - "What if funding fails?"
   - "When will I receive the game?"
   - "Can I play on mobile?"
   - "Is it in English?"

## Budget Allocation

**For 20M KRW Campaign**:

| Item | Cost | % |
|------|------|---|
| Platform fee (8%) | 1,600,000 | 8% |
| Digital rewards (artbook, OST) | 800,000 | 4% |
| Marketing (influencers, ads) | 2,000,000 | 10% |
| Development (Act 3 completion) | 3,000,000 | 15% |
| Taxes (income tax est.) | 2,000,000 | 10% |
| **Reserve** | 1,600,000 | 8% |
| **Net profit** | **9,000,000** | **45%** |

**Healthy campaign**: 45-55% net profit margin

## Success Metrics

**Funding Phase**:
- Day 1: 30% funded (6M KRW)
- Week 1: 50% funded (10M KRW)
- Week 2-3: 80% funded (16M KRW)
- Final week: 100%+ funded (20M+ KRW)
- Total backers: 800-1,500 people
- Avg pledge: 13,000-15,000 KRW

**Post-Funding**:
- Update frequency: Weekly minimum
- Response time: <24 hours
- Delivery on time: 95%+ (late = trust damage)
- Final rating: 4.5+/5 stars

## Resources

**Templates**: `references/project-page-template.md` - Complete Tumblbug page
**Rewards**: `references/reward-tier-templates.md` - 10 pricing strategies
**Marketing**: `references/90-day-marketing-plan.md` - Day-by-day calendar
**Crisis**: `references/crisis-response-playbook.md` - 10 scenarios + responses
**Budget**: `references/budget-calculator.md` - Spreadsheet template

## Success Criteria

Successful Tumblbug campaign should:
- ✅ Reach 100% funding (20M KRW minimum)
- ✅ Build 300+ community members pre-launch
- ✅ Achieve 30% funding in first 24 hours
- ✅ Maintain 4.5+ backer satisfaction
- ✅ Deliver rewards on time (no delays)
- ✅ Build email list (500+ for future launches)
- ✅ Create reusable marketing assets (for Steam launch)
- ✅ Establish brand (foundation for sequel games)

---

**Version**: 1.0
**Last Updated**: 2025-01-04
**Author**: Crowdfunding Strategy Specialist
