# Tumblbug Project Page Template

Complete template for "잠들지 못하는 밤" Tumblbug crowdfunding page.

## Page Structure (7 Sections)

### Section 1: Hero (First Impression)

**Hero Image** (1920×1080px):
```
Visual: 5 suspects in silhouette, dark office background
Text overlay: "당신의 추리가 진실을 밝힌다"
Mood: Mysterious, cinematic, K-drama aesthetic
```

**Hero Video** (30-60 seconds):

```
0-5s: Hook
  - Flash: Office at night, body discovered
  - Text: "그는 왜 죽었는가?"

5-25s: Gameplay
  - AI NPC dialogue demo (player asks, NPC responds)
  - Evidence discovery animation
  - Suspicion meter rising

25-45s: Features
  - "AI 기반 용의자 심문"
  - "3막 구조 영화 같은 스토리"
  - "5가지 엔딩"

45-60s: CTA
  - "2025년 5월 출시"
  - "지금 후원하고 특별 혜택 받기"
  - Tumblbug logo + project title
```

---

### Section 2: Story Hook (Emotional Connection)

```markdown
# "그는 왜 죽었는가?"

강대현, 37세. IT 스타트업의 CTO.
재능 넘치고, 사람들에게 사랑받던 그가
회사 회의실에서 차갑게 식은 채 발견되었습니다.

경찰은 자살이라 결론지었습니다.
하지만 당신은 알고 있습니다.

**이것은 살인입니다.**

5명의 동료, 5가지 거짓말, 1명의 범인.
AI NPC와의 대화를 통해 진실을 밝혀내세요.
```

**Visual**: Victim's photo (blurred face), office crime scene

---

### Section 3: Problem & Solution (Value Proposition)

```markdown
## 기존 방탈출 게임의 한계

❌ **정해진 선택지만 클릭** → 몰입감 낮음
❌ **단순한 공포 테마** → 깊이 없는 스토리
❌ **한 번 하면 끝** → 재플레이 가치 없음

## "잠들지 못하는 밤"의 차별화

✅ **AI NPC 자유 대화**
   → 원하는 질문을 입력하고, 용의자가 성격에 따라 대답
   → 거짓말을 간파하고, 모순을 찾아내는 추리 게임

✅ **K-드라마 퀄리티 시나리오**
   → "비밀의 숲" 스타일의 복잡한 인간 드라마
   → 한국 기업 문화와 사회 문제 반영

✅ **5가지 엔딩**
   → 당신의 선택이 결과를 결정
   → True Ending을 위한 숨겨진 증거와 비밀
```

---

### Section 4: Features Deep Dive

```markdown
## 핵심 기능

### 1. AI 기반 용의자 심문 (Gemini 2.5 Flash)

[GIF: NPC dialogue demo]

**어떻게 작동하나요?**
- 플레이어가 자유롭게 질문 입력
- AI가 용의자 성격, 비밀, 거짓말 확률에 따라 동적 응답
- 대화를 통해 증거를 발견하고 모순을 포착

**예시**:
```
플레이어: "사건 당일 10시 30분에 어디 있었나요?"
이윤아: "그 시각이면... 이미 퇴근했을 거예요."
[거짓말 확률: 80%]

플레이어: "CCTV에 당신이 10시 45분에 나가는 게 찍혔는데요?"
이윤아: "그... 그건... 서류를 깜빡해서..."
[의심 지수 +15]
```

### 2. 3막 구조 영화 같은 스토리

**Act 1: 사건 발견** (30분)
- 피해자 발견
- 초기 단서 수집
- 5명의 용의자와 첫 만남

**Act 2: 진실의 파편** (60분)
- 용의자 심문
- 증거 수집과 분석
- 예상치 못한 반전

**Act 3: 선택의 무게** (30분)
- 최종 추리
- 범인 지목
- 5가지 엔딩 중 하나 도달

### 3. 5가지 엔딩

1. **정의의 승리**: 모든 증거 + 정확한 범인 지목
2. **복수의 순환**: 잘못된 사람 지목 (비극)
3. **침묵의 합의**: 진실 은폐 선택 (도덕적 타협)
4. **진실의 대가**: 진실 공개하지만 개인적 희생
5. **잠들지 못하는 밤** (True): 가장 깊은 진실 (자살 + 집단 책임)

### 4. 모바일 최적화

- 스마트폰, 태블릿, PC 모두 지원
- 터치 인터페이스 최적화
- 세로/가로 모드 지원
- 언제 어디서나 플레이
```

---

### Section 5: Gameplay Video (Trust Building)

```markdown
## 실제 플레이 영상

[Embedded YouTube Video - 3 minutes]

**타임라인**:
- 0:00-0:30: 사건 발견 (Scene 0)
- 0:30-1:30: 증거 수집 및 분석 (Scene 3)
- 1:30-2:30: AI NPC와 대화 (이윤아 심문)
- 2:30-3:00: 범인 지목 및 엔딩 (스포 없이)

**플레이 가능한 데모**: [링크]
- Scene 0-2 플레이 가능
- 약 15분 체험
- 저장 기능 없음 (정식 버전에서 제공)
```

---

### Section 6: Rewards (Clear Value)

```markdown
## 리워드

### 🐣 얼리버드 (100명 한정)
**9,900원** (34% 할인)
- 게임 1인 라이선스
- 엔딩 크레딧 이름 등재
- 예상 전달: 2025년 7월

### 🎮 스탠다드
**14,900원**
- 게임 1인 라이선스
- 엔딩 크레딧 이름 등재
- 예상 전달: 2025년 7월

### ⭐ 프리미엄
**19,900원**
- 게임 1인 라이선스
- 디지털 아트북 (PDF, 50 pages)
- 사운드트랙 (MP3, 5 tracks)
- 엔딩 크레딧 이름 등재
- 예상 전달: 2025년 7월

### 💎 서포터
**29,900원**
- 프리미엄 리워드 전체
- **캐릭터 이름 지정권** (NPC 1명의 이름을 직접 선택)
- 개발자 코멘터리 영상 (30 min)
- 예상 전달: 2025년 7월

### 👑 콜렉터 (50명 한정)
**49,900원**
- 서포터 리워드 전체
- **맞춤 증거 제작** (게임 내 증거 1개를 당신의 아이디어로 제작)
- 1:1 온라인 미팅 (개발자와 30분)
- **Special Thanks 크레딧** (엔딩 화면 상단 노출)
- 예상 전달: 2025년 7월
```

**Revenue Calculation**:
```
100 × 9,900 = 990,000
500 × 14,900 = 7,450,000
300 × 19,900 = 5,970,000
80 × 29,900 = 2,392,000
20 × 49,900 = 998,000

Total: 17,800,000 KRW (1,000 backers)
```

---

### Section 7: Team & Timeline (Credibility)

```markdown
## 개발팀

**기획/개발** - [이름]
- Next.js 전문 풀스택 개발자
- 방탈출 카페 마니아 (50+ 테마 체험)
- "좋은 방탈출 게임을 웹에서도 즐기고 싶다"는 마음으로 시작

**시나리오** - [작가 이름] (외주)
- 전 드라마 작가
- 추리/스릴러 전문
- "단편선" 스타일 감성 스토리텔링

**일러스트** - [아티스트 이름] (외주)
- 게임 UI/캐릭터 디자인 5년 경력
- 참여작: [이전 프로젝트들]

## 개발 진행 상황

✅ **2024년 11월**: 기획 및 기술 검증 완료
✅ **2024년 12월**: Act 1-2 개발 완료 (70%)
🔄 **2025년 1-2월**: Act 3 개발 + AI 통합
📅 **2025년 3-4월**: 베타 테스트 및 버그 수정
🚀 **2025년 7월**: 정식 출시 (텀블벅 후원자 우선)

## 개발 일정

**펀딩 성공 시**:
- 2025년 5월: 펀딩 종료
- 2025년 5-6월: Act 3 완성 + 최종 테스트
- 2025년 7월 15일: **정식 출시** (Steam + 웹)
- 2025년 8월: 리워드 배송 (디지털 아트북, OST)

**예상 개발 기간**: 6개월 (2월-7월)
```

---

### Section 8: FAQ (Objection Handling)

```markdown
## 자주 묻는 질문

**Q: 모바일에서도 플레이 가능한가요?**
A: 네! 스마트폰, 태블릿, PC 모두 지원합니다. 반응형 디자인으로 어느 기기에서나 최적화된 경험을 제공합니다.

**Q: 영어 버전은 없나요?**
A: 현재는 한국어 버전만 제공하지만, 펀딩 목표 150% 달성 시 영어 번역을 스트레치 골로 추가할 예정입니다.

**Q: 플레이 시간은 얼마나 되나요?**
A: 평균 90-120분입니다. 빠른 플레이어는 60분, 모든 증거를 찾으려면 180분 정도 소요됩니다.

**Q: 멀티플레이가 가능한가요?**
A: MVP는 싱글플레이어 전용이지만, 친구와 화면 공유하며 함께 추리하는 것은 가능합니다. 정식 멀티플레이어는 Phase 2에서 고려 중입니다.

**Q: 저장 기능이 있나요?**
A: 네! 30초마다 자동 저장되어 언제든 중단했다가 이어할 수 있습니다.

**Q: AI가 이상한 대답을 하면 어쩌죠?**
A: Gemini 2.5 Flash는 매우 정교하게 튜닝되었지만, 가끔 예상 밖 반응이 나올 수 있습니다. 이런 경우 대화를 다시 시작하거나, 템플릿 응답 모드로 전환할 수 있습니다.

**Q: 펀딩이 실패하면 어떻게 되나요?**
A: 목표 금액 미달 시 전액 환불되며, 프로젝트는 Steam Early Access로 전환하여 계속 개발합니다.

**Q: 언제 게임을 받을 수 있나요?**
A: 2025년 7월 15일 정식 출시 예정입니다. 후원자분들께는 1주일 일찍 (7월 8일) 얼리 액세스를 제공합니다.

**Q: 환불이 가능한가요?**
A: 텀블벅 정책에 따라 펀딩 종료 전까지는 취소 가능하며, 출시 후에도 30일 이내 플레이하지 않은 경우 환불해드립니다.
```

---

## Visual Assets Checklist

```
Images:
- [ ] Hero image (1920×1080px, <2MB)
- [ ] Character portraits (5 images, 800×800px each)
- [ ] Scene screenshots (10 images, 1920×1080px)
- [ ] Evidence examples (5 images, 600×600px)
- [ ] UI mockups (3 images, showing different screens)
- [ ] Team photos (developer, writer, artist)

Videos:
- [ ] Hero video (30-60s, <200MB, .mp4)
- [ ] Gameplay video (3 min, full scene walkthrough)
- [ ] AI dialogue demo (1 min, showing Q&A)
- [ ] Ending variations (30s each, no spoilers)

Graphics:
- [ ] Infographic: How to play (visual guide)
- [ ] Infographic: Development timeline
- [ ] Infographic: 5 endings comparison (no spoilers)
- [ ] Logo/Title design (transparent .png)
```

---

## Stretch Goals

```markdown
## 스트레치 골

### 150% (30M KRW)
→ **비하인드 스토리 디지털북**
  - 캐릭터 설정집
  - 개발 비하인드
  - 미공개 엔딩 시나리오 (40 pages PDF)
  - 모든 후원자에게 제공

### 200% (40M KRW)
→ **보너스 미니 시나리오**
  - "잠들지 못하는 밤" 세계관 외전
  - 30분 플레이 타임
  - 2025년 8월 무료 제공

### 300% (60M KRW)
→ **Act 4 제작 확정**
  - 본편 후속 에피소드
  - 새로운 사건, 새로운 용의자
  - 2025년 12월 출시

### 500% (100M KRW)
→ **모바일 앱 버전 제작**
  - iOS/Android 네이티브 앱
  - 오프라인 플레이 지원
  - 푸시 알림 기능
  - 2026년 3월 출시
```

---

## Update Schedule

**Frequency**:
- Week 1: Daily (minimum 1 update/day)
- Week 2-3: Every 2-3 days
- Week 4: Daily (final push)

**Content Types**:

```
Progress Updates:
"🎉 후원자 500명 돌파! 목표 달성률 60%"
[Screenshot: Dashboard showing progress]

Development Updates:
"이번 주 완료: AI NPC 대화 시스템 최적화"
[GIF: Improved dialogue response time]

Backer Engagement:
"Q&A 세션: 가장 궁금해하신 질문 TOP 5 답변"
[Detailed answers with images]

Stretch Goal Reveals:
"목표 달성! 150% 스트레치 골 공개합니다"
[New reward unlocked]

Thank You:
"1,000명 후원자 감사 영상"
[Video: Dev team thank you]
```

---

## Success Metrics

**Day 1 Targets**:
- 30% funded (6M KRW)
- 200 backers
- Early Bird sold out (100/100)

**Week 1 Targets**:
- 50% funded (10M KRW)
- 400 backers
- 50+ comments (engagement)

**Week 4 Targets**:
- 100% funded (20M+ KRW)
- 800-1,000 backers
- 150% stretch goal unlocked

**Post-Campaign**:
- Weekly updates maintained
- Response time <24 hours
- On-time delivery (July 15, 2025)

---

**Total Sections**: 8
**Total Assets**: 25+ (images + videos)
**Est. Preparation Time**: 40 hours
**Success Rate**: 75% (with proper execution)
